/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.impl.CDIContainerImpl;
import com.ibm.ws.cdi.impl.CDIImpl;
import com.ibm.ws.cdi.impl.weld.WebSphereEEModuleDescriptor;
import com.ibm.ws.cdi.internal.archive.liberty.RuntimeFactory;
import com.ibm.ws.cdi.internal.interfaces.Application;
import com.ibm.ws.cdi.internal.interfaces.ArchiveType;
import com.ibm.ws.cdi.internal.interfaces.CDIArchive;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.CDIUtils;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.classloading.LibertyClassLoadingService;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.injectionengine.InjectionMetaDataListener;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.EEModuleDescriptor;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class AbstractCDIRuntime
implements CDIService,
CDIRuntime,
CDIProvider {
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR;
    private static final ServiceCaller<LibertyClassLoadingService> classLoadingServiceCaller;
    private CDIContainerImpl cdiContainer;
    protected RuntimeFactory runtimeFactory;
    static final long serialVersionUID = -532538009176290897L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void start() {
        this.cdiContainer = new CDIContainerImpl(this);
        CDI.setCDIProvider((CDIProvider)this);
        this.getInjectionEngine().registerInjectionMetaDataListener((InjectionMetaDataListener)this.cdiContainer);
    }

    protected void stop() {
        this.getInjectionEngine().unregisterInjectionMetaDataListener((InjectionMetaDataListener)this.cdiContainer);
        this.cdiContainer = null;
        CDIImpl.clear();
    }

    public final BeanManager getModuleBeanManager(ModuleMetaData moduleMetaData) {
        BeanManager beanManager = this.getCDIContainer().getBeanManager(moduleMetaData);
        return beanManager;
    }

    public final boolean isApplicationCDIEnabled(ApplicationMetaData applicationMetaData) {
        boolean enabled = this.getCDIContainer().isApplicationCDIEnabled(applicationMetaData);
        return enabled;
    }

    public final boolean isCurrentApplicationCDIEnabled() {
        boolean enabled = this.getCDIContainer().isCurrentApplicationCDIEnabled();
        return enabled;
    }

    public final boolean isModuleCDIEnabled(ModuleMetaData moduleMetaData) {
        boolean enabled = this.getCDIContainer().isModuleCDIEnabled(moduleMetaData);
        return enabled;
    }

    public final boolean isCurrentModuleCDIEnabled() {
        boolean enabled = this.getCDIContainer().isCurrentModuleCDIEnabled();
        return enabled;
    }

    public final boolean skipCreatingBda(CDIArchive archive) {
        boolean skip = this.isImplicitBeanArchivesScanningDisabled(archive);
        skip = skip && archive.getBeansXml() == null;
        skip = skip && archive.getType() != ArchiveType.WEB_MODULE;
        return skip;
    }

    public final BeanManager getCurrentModuleBeanManager() {
        return this.getCDIContainer().getCurrentModuleBeanManager();
    }

    public final String getCurrentApplicationContextID() {
        return this.getCDIContainer().getCurrentApplicationContextID();
    }

    public final WebSphereCDIDeployment getCurrentDeployment() {
        return this.getCDIContainer().getCurrentDeployment();
    }

    public final BeanManager getClassBeanManager(Class<?> targetClass) {
        return this.getCDIContainer().getClassBeanManager(targetClass);
    }

    public final WebSphereBeanDeploymentArchive getClassBeanDeploymentArchive(Class<?> targetClass) {
        return this.getCDIContainer().getClassBeanDeploymentArchive(targetClass);
    }

    public final BeanManager getCurrentBeanManager() {
        return this.getCDIContainer().getCurrentBeanManager();
    }

    public CDI<Object> getCDI() {
        CDI cdi = null;
        WebSphereCDIDeployment deployment = this.getCDIContainer().getCurrentDeployment();
        if (deployment != null) {
            cdi = deployment.getCDI();
        }
        if (this.runtimeFactory != null && cdi == null) {
            Collection applications = this.runtimeFactory.getApplications();
            ClassLoader tccl = AccessController.doPrivileged(() -> THREAD_CONTEXT_ACCESSOR.getContextClassLoader(Thread.currentThread()));
            LibertyClassLoadingService classLoadingService = (LibertyClassLoadingService)classLoadingServiceCaller.current().get();
            for (Application application : applications) {
                if (!application.getClassLoader().equals(tccl) && !classLoadingService.isThreadContextClassLoaderForAppClassLoader(tccl, application.getClassLoader())) continue;
                deployment = this.cdiContainer.getDeployment(application);
                if (deployment == null) break;
                cdi = deployment.getCDI();
                break;
            }
        }
        if (deployment == null) {
            throw new IllegalStateException("Could not find deployment");
        }
        if (cdi == null) {
            throw new IllegalStateException("Could not find CDI");
        }
        return cdi;
    }

    public CDIContainerImpl getCDIContainer() {
        return this.cdiContainer;
    }

    public Set<Annotation> getInterceptorBindingsFromInvocationContext(InvocationContext ic) throws IllegalArgumentException {
        return CDIUtils.getInterceptorBindingsFromInvocationContext((InvocationContext)ic);
    }

    public Optional<J2EEName> getModuleNameForClass(Class<?> clazz) {
        return Optional.ofNullable(this.getClassBeanDeploymentArchive(clazz)).map(bda -> (EEModuleDescriptor)bda.getServices().get(EEModuleDescriptor.class)).filter(desc -> desc.getType() == EEModuleDescriptor.ModuleType.WEB || desc.getType() == EEModuleDescriptor.ModuleType.EJB_JAR).filter(WebSphereEEModuleDescriptor.class::isInstance).map(WebSphereEEModuleDescriptor.class::cast).map(desc -> desc.getJ2eeName());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.cdi.impl.AbstractCDIRuntime", AbstractCDIRuntime.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
        THREAD_CONTEXT_ACCESSOR = ThreadContextAccessor.getThreadContextAccessor();
        classLoadingServiceCaller = new ServiceCaller(AbstractCDIRuntime.class, LibertyClassLoadingService.class);
    }
}

