/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.exception.DiscriminationProcessException;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.net.SocketTimeoutException;

public class NewConnectionInitialReadCallback
implements TCPReadCompletedCallback {
    private final TCPChannel tcpChannel;
    private static final TraceComponent tc = Tr.register(NewConnectionInitialReadCallback.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");

    public NewConnectionInitialReadCallback(TCPChannel _tcpChannel) {
        this.tcpChannel = _tcpChannel;
    }

    private boolean requestFull(TCPReadRequestContext req) {
        boolean rc;
        WsByteBuffer[] wsBuffArray = req.getBuffers();
        boolean bl = rc = !wsBuffArray[wsBuffArray.length - 1].hasRemaining();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("requestFull: " + rc), (Object[])new Object[0]);
        }
        return rc;
    }

    @Override
    public void complete(VirtualConnection vc, TCPReadRequestContext req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"complete", (Object[])new Object[0]);
        }
        this.sendToDiscriminators(vc, req, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"complete");
        }
    }

    @Override
    public void error(VirtualConnection vc, TCPReadRequestContext req, IOException ioe) {
        WsByteBuffer[] buffArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("error: " + vc), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Error occurred during initial read of request from client: " + req.getInterface().getRemoteAddress() + " " + req.getInterface().getRemotePort() + " : " + ioe), (Object[])new Object[0]);
        }
        if ((buffArray = req.getBuffers()) != null) {
            for (int i = 0; i < buffArray.length; ++i) {
                if (buffArray[i] == null) continue;
                buffArray[i].release();
            }
        }
        req.setBuffers(null);
        if (ioe != null && ioe instanceof SocketTimeoutException) {
            this.sendToDiscriminators(vc, req, true);
        } else {
            ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, ioe);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"error");
        }
    }

    private void sendToDiscriminators(VirtualConnection inVC, TCPReadRequestContext req, boolean errorOnRead) {
        boolean doAgain;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendToDiscriminators", (Object[])new Object[0]);
        }
        req.setJITAllocateSize(0);
        TCPConnLink conn = ((TCPReadRequestContextImpl)req).getTCPConnLink();
        VirtualConnection vc = inVC;
        do {
            int state;
            doAgain = false;
            try {
                state = this.tcpChannel.getDiscriminationProcess().discriminate(vc, req.getBuffers(), conn);
            }
            catch (DiscriminationProcessException dpe) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Exception occurred while discriminating data received from client " + req.getInterface().getRemoteAddress() + " " + req.getInterface().getRemotePort()), (Object[])new Object[0]);
                }
                ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, new IOException("Discrimination failed " + dpe.getMessage()));
                break;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Discrimination returned " + state), (Object[])new Object[0]);
            }
            if (state == 1) {
                ConnectionReadyCallback cb = conn.getApplicationCallback();
                if (cb != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Calling application callback.ready method", (Object[])new Object[0]);
                    }
                    cb.ready(vc);
                    continue;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No application callback found, closing connection", (Object[])new Object[0]);
                }
                ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, null);
                continue;
            }
            if (state == 2) {
                if (errorOnRead) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("First read timed out, and more than one discriminator asked for more data" + req.getInterface().getRemoteAddress() + " " + req.getInterface().getRemotePort()), (Object[])new Object[0]);
                    }
                    ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, null);
                    continue;
                }
                if (this.requestFull(req)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("Discrimination failed, no one claimed data even after 1 complete buffer presented - probably garbage passed in" + req.getInterface().getRemoteAddress() + " " + req.getInterface().getRemotePort()), (Object[])new Object[0]);
                    }
                    ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, null);
                    continue;
                }
                vc = req.read(1L, this, false, 0);
                if (vc == null) continue;
                doAgain = true;
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error occurred while discriminating data received from client " + req.getInterface().getRemoteAddress() + " " + req.getInterface().getRemotePort()), (Object[])new Object[0]);
            }
            ((TCPReadRequestContextImpl)req).getTCPConnLink().close(vc, null);
        } while (doAgain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendToDiscriminators");
        }
    }
}

