/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;

final class Validator {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(Validator.class);

    private Validator() {
    }

    public static void checkValid(Class<?> userType) throws RestClientDefinitionException {
        if (!userType.isInterface()) {
            Validator.throwException("VALIDATION_NOT_AN_INTERFACE", userType);
        }
        Method[] methods = userType.getMethods();
        Validator.checkMethodsForMultipleHTTPMethodAnnotations(methods);
        Validator.checkMethodsForInvalidURITemplates(userType, methods);
    }

    private static void checkMethodsForMultipleHTTPMethodAnnotations(Method[] clientMethods) throws RestClientDefinitionException {
        HashMap<String, Class<? extends Annotation>> httpMethods = new HashMap<String, Class<? extends Annotation>>();
        for (Method method : clientMethods) {
            for (Annotation anno : method.getAnnotations()) {
                Class<? extends Annotation> annoClass = anno.annotationType();
                HttpMethod verb = annoClass.getAnnotation(HttpMethod.class);
                if (verb == null) continue;
                httpMethods.put(verb.value(), annoClass);
            }
            if (httpMethods.size() > 1) {
                Validator.throwException("VALIDATION_METHOD_WITH_MULTIPLE_VERBS", method, httpMethods.values());
            }
            httpMethods.clear();
        }
    }

    private static void checkMethodsForInvalidURITemplates(Class<?> userType, Method[] methods) throws RestClientDefinitionException {
        Path classPathAnno = userType.getAnnotation(Path.class);
        HashSet classLevelVariables = new HashSet();
        URITemplate classTemplate = null;
        if (classPathAnno != null) {
            classTemplate = new URITemplate(classPathAnno.value());
            classLevelVariables.addAll(classTemplate.getVariables());
        }
        for (Method method : methods) {
            PathParam pathParam;
            Path methodPathAnno = method.getAnnotation(Path.class);
            URITemplate template = methodPathAnno != null ? (classPathAnno == null ? new URITemplate(methodPathAnno.value()) : new URITemplate(classPathAnno.value() + "/" + methodPathAnno.value())) : classTemplate;
            if (template == null) continue;
            HashSet allVariables = new HashSet(template.getVariables());
            if (!allVariables.isEmpty()) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                for (Parameter p : method.getParameters()) {
                    pathParam = p.getAnnotation(PathParam.class);
                    if (pathParam == null) continue;
                    paramMap.put(pathParam.value(), "x");
                }
                try {
                    template.substitute(paramMap, Collections.emptySet(), false);
                }
                catch (IllegalArgumentException ex) {
                    Validator.throwException("VALIDATION_UNRESOLVED_PATH_PARAMS", userType, method);
                }
                continue;
            }
            ArrayList<String> foundParams = new ArrayList<String>();
            for (Parameter p : method.getParameters()) {
                pathParam = p.getAnnotation(PathParam.class);
                if (pathParam == null) continue;
                foundParams.add(pathParam.value());
            }
            if (foundParams.isEmpty()) continue;
            Validator.throwException("VALIDATION_EXTRA_PATH_PARAMS", userType, method);
        }
    }

    private static void throwException(String msgKey, Object ... msgParams) throws RestClientDefinitionException {
        Message msg = new Message(msgKey, BUNDLE, msgParams);
        throw new RestClientDefinitionException(msg.toString());
    }
}

