/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.impl.LongAdderAdapter;
import com.ibm.ws.microprofile.metrics.impl.LongAdderProxy;
import com.ibm.ws.microprofile.metrics.impl.Reservoir;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.helper.BucketManager;
import io.openliberty.microprofile.metrics30.setup.config.MetricPercentileConfiguration;
import io.openliberty.microprofile.metrics30.setup.config.MetricsConfigurationManager;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Snapshot;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Histogram30Impl
implements Histogram {
    private final Reservoir reservoir;
    private final LongAdderAdapter count;
    private final LongAdderAdapter sum;
    private final BucketManager manager;
    private final double[] percentiles;
    static final long serialVersionUID = -6005042538980834842L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Histogram30Impl(Reservoir reservoir, Metadata metadata) {
        this.reservoir = reservoir;
        this.count = LongAdderProxy.create();
        this.sum = LongAdderProxy.create();
        this.manager = new BucketManager(metadata);
        this.percentiles = this.setConfiguredPercentiles(metadata);
    }

    public void update(int value) {
        this.update((long)value);
    }

    public void update(long value) {
        this.count.increment();
        this.sum.add(value);
        this.reservoir.update(value);
        this.manager.updateHistogram(value);
    }

    public long getCount() {
        return this.count.sum();
    }

    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }

    public Map<String, Map<Double, BucketManager.BucketValue>> getBuckets() {
        return this.manager.getBuckets();
    }

    public long getSum() {
        return this.sum.sum();
    }

    public double[] getConfiguredPercentiles() {
        return this.percentiles;
    }

    public double[] setConfiguredPercentiles(Metadata metadata) {
        Optional percentileConfiguration = ConfigProvider.getConfig().getOptionalValue("mp.metrics.distribution.percentiles", String.class);
        String metricName = metadata.getName();
        if (percentileConfiguration.isPresent()) {
            MetricPercentileConfiguration percentileConfig = MetricsConfigurationManager.getInstance().getPercentilesConfiguration(metricName);
            if (percentileConfig != null && percentileConfig.getValues() != null && ((Double[])percentileConfig.getValues()).length > 0 && !percentileConfig.isDisabled()) {
                double[] vals = Stream.of((Double[])percentileConfig.getValues()).mapToDouble(Double::doubleValue).toArray();
                return vals;
            }
            if (percentileConfig == null) {
                return null;
            }
            return new double[0];
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.metrics30.internal.impl.Histogram30Impl", Histogram30Impl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    }
}

