/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.data;

import java.util.ArrayList;
import java.util.Map;

public class NameAliases {
    private final String[] originalNames;
    public volatile String[] aliases;
    public ExtensionAliases extensionAliases;

    public NameAliases(String[] originalNames) {
        this.originalNames = originalNames;
        this.aliases = (String[])originalNames.clone();
        this.extensionAliases = new ExtensionAliases();
    }

    public void newAliases(Map<String, String> newAliases) {
        String[] tempAliases = (String[])this.originalNames.clone();
        ExtensionAliases tempExtensionAliases = new ExtensionAliases();
        for (Map.Entry<String, String> entry : newAliases.entrySet()) {
            if (entry.getKey().trim().startsWith("ext_")) {
                tempExtensionAliases.addExtensionAlias(entry.getKey().trim(), entry.getValue().trim());
                continue;
            }
            for (int i = 0; i < this.originalNames.length; ++i) {
                if (!this.originalNames[i].equals(entry.getKey().trim())) continue;
                tempAliases[i] = entry.getValue().trim();
            }
        }
        this.aliases = tempAliases;
        this.extensionAliases = tempExtensionAliases;
    }

    public void resetAliases() {
        this.aliases = (String[])this.originalNames.clone();
        this.extensionAliases = new ExtensionAliases();
    }

    static class ExtensionAliases {
        public ArrayList<String> originalExtensions = new ArrayList();
        public ArrayList<String> aliasesExtensions = new ArrayList();

        public void addExtensionAlias(String originalName, String alias) {
            this.originalExtensions.add(originalName);
            this.aliasesExtensions.add(alias);
        }

        public String getAlias(String original) {
            for (int i = 0; i < this.originalExtensions.size(); ++i) {
                if (!this.originalExtensions.get(i).equals(original)) continue;
                return this.aliasesExtensions.get(i);
            }
            return original;
        }
    }
}

