/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.jakartasec.el.ELUtils;
import io.openliberty.security.oidcclientcore.client.OidcProviderMetadata;
import jakarta.security.enterprise.authentication.mechanism.http.openid.OpenIdProviderMetadata;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenIdProviderMetadataWrapper
implements OidcProviderMetadata {
    private final OpenIdProviderMetadata providerMetadata;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userinfoEndpoint;
    private final String endSessionEndpoint;
    private final String jwksURI;
    private final String issuer;
    private final String subjectTypeSupported;
    private final String[] idTokenSigningAlgorithmsSupported;
    private final String responseTypeSupported;
    static final long serialVersionUID = -8900041608263351617L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OpenIdProviderMetadataWrapper(OpenIdProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
        this.authorizationEndpoint = this.evaluateAuthorizationEndpoint(true);
        this.tokenEndpoint = this.evaluateTokenEndpoint(true);
        this.userinfoEndpoint = this.evaluateUserinfoEndpoint(true);
        this.endSessionEndpoint = this.evaluateEndSessionEndpoint(true);
        this.jwksURI = this.evaluateJwksURI(true);
        this.issuer = this.evaluateIssuer(true);
        this.subjectTypeSupported = this.evaluateSubjectTypeSupported(true);
        this.idTokenSigningAlgorithmsSupported = this.evaluateIdTokenSigningAlgorithmsSupported(true);
        this.responseTypeSupported = this.evaluateResponseTypeSupported(true);
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint != null ? this.authorizationEndpoint : this.evaluateAuthorizationEndpoint(false);
    }

    private String evaluateAuthorizationEndpoint(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("authorizationEndpoint", this.providerMetadata.authorizationEndpoint(), "", immediateOnly);
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint != null ? this.tokenEndpoint : this.evaluateTokenEndpoint(false);
    }

    private String evaluateTokenEndpoint(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("tokenEndpoint", this.providerMetadata.tokenEndpoint(), "", immediateOnly);
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint != null ? this.userinfoEndpoint : this.evaluateUserinfoEndpoint(false);
    }

    private String evaluateUserinfoEndpoint(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("userinfoEndpoint", this.providerMetadata.userinfoEndpoint(), "", immediateOnly);
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint != null ? this.endSessionEndpoint : this.evaluateEndSessionEndpoint(false);
    }

    private String evaluateEndSessionEndpoint(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("endSessionEndpoint", this.providerMetadata.endSessionEndpoint(), "", immediateOnly);
    }

    public String getJwksURI() {
        return this.jwksURI != null ? this.jwksURI : this.evaluateJwksURI(false);
    }

    private String evaluateJwksURI(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("jwksURI", this.providerMetadata.jwksURI(), "", immediateOnly);
    }

    public String getIssuer() {
        return this.issuer != null ? this.issuer : this.evaluateIssuer(false);
    }

    private String evaluateIssuer(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("issuer", this.providerMetadata.issuer(), "", immediateOnly);
    }

    public String getSubjectTypeSupported() {
        return this.subjectTypeSupported != null ? this.subjectTypeSupported : this.evaluateSubjectTypeSupported(false);
    }

    private String evaluateSubjectTypeSupported(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("subjectTypeSupported", this.providerMetadata.subjectTypeSupported(), "public", immediateOnly);
    }

    public String[] getIdTokenSigningAlgorithmsSupported() {
        return this.idTokenSigningAlgorithmsSupported != null ? this.idTokenSigningAlgorithmsSupported : this.evaluateIdTokenSigningAlgorithmsSupported(false);
    }

    private String[] evaluateIdTokenSigningAlgorithmsSupported(boolean immediateOnly) {
        return ELUtils.evaluateStringArrayAttribute("idTokenSigningAlgorithmsSupported", this.providerMetadata.idTokenSigningAlgorithmsSupported(), new String[]{"RS256"}, immediateOnly);
    }

    public String getResponseTypeSupported() {
        return this.responseTypeSupported != null ? this.responseTypeSupported : this.evaluateResponseTypeSupported(false);
    }

    private String evaluateResponseTypeSupported(boolean immediateOnly) {
        return ELUtils.evaluateStringAttribute("responseTypeSupported", this.providerMetadata.responseTypeSupported(), "code,id_token,token id_token", immediateOnly);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.jakartasec.OpenIdProviderMetadataWrapper", OpenIdProviderMetadataWrapper.class, (String)"OpenIdConnect", (String)"io.openliberty.security.jakartasec.internal.resources.JakartaSecurity30Messages");
    }
}

