/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import org.eclipse.yasson.internal.DeserializationContextImpl;
import org.eclipse.yasson.internal.deserializer.ModelDeserializer;

class ArrayDeserializer
implements ModelDeserializer<JsonParser> {
    private final ModelDeserializer<JsonParser> delegate;

    ArrayDeserializer(ModelDeserializer<JsonParser> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object deserialize(JsonParser parser, DeserializationContextImpl context) {
        ArrayList<Object> collection = new ArrayList<Object>();
        block4: while (parser.hasNext()) {
            JsonParser.Event next = parser.next();
            context.setLastValueEvent(next);
            switch (next) {
                case START_OBJECT: 
                case START_ARRAY: 
                case VALUE_STRING: 
                case VALUE_TRUE: 
                case VALUE_FALSE: 
                case VALUE_NUMBER: 
                case VALUE_NULL: {
                    DeserializationContextImpl newContext = new DeserializationContextImpl(context);
                    collection.add(this.delegate.deserialize(parser, newContext));
                    continue block4;
                }
                case END_ARRAY: {
                    return collection;
                }
            }
            throw new JsonbException("Unexpected state: " + next);
        }
        return collection;
    }
}

