/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.resteasy.concurrent.ContextualExecutorService;
import org.jboss.resteasy.concurrent.ContextualThreadFactory;
import org.jboss.resteasy.concurrent.SecurityActions;

class GlobalContextualExecutorService
extends ContextualExecutorService
implements AutoCloseable {
    static final GlobalContextualExecutorService INSTANCE = new GlobalContextualExecutorService();
    private final Thread shutdownHook = new Thread("resteasy-shutdown"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GlobalContextualExecutorService globalContextualExecutorService = GlobalContextualExecutorService.this;
            synchronized (globalContextualExecutorService) {
                if (GlobalContextualExecutorService.this.delegate != null) {
                    GlobalContextualExecutorService.this.delegate.shutdown();
                    GlobalContextualExecutorService.this.delegate = null;
                }
            }
        }
    };
    private volatile ExecutorService delegate;

    private GlobalContextualExecutorService() {
        super(null, true);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ExecutorService getDelegate() {
        if (this.delegate == null) {
            GlobalContextualExecutorService globalContextualExecutorService = this;
            synchronized (globalContextualExecutorService) {
                if (this.delegate == null) {
                    int poolSize = SecurityActions.getCoreThreads("dev.resteasy.concurrent.core.pool.size");
                    this.delegate = new ThreadPoolExecutor(poolSize, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ContextualThreadFactory("contextual-pool"));
                    SecurityActions.registerShutdownHook(this.shutdownHook);
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        GlobalContextualExecutorService globalContextualExecutorService = this;
        synchronized (globalContextualExecutorService) {
            SecurityActions.removeShutdownHook(this.shutdownHook);
            if (this.delegate != null) {
                this.delegate.shutdown();
                this.delegate = null;
            }
        }
    }
}

