/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.yoko.orb.OB.CharMapInfo;

public enum CodeSetInfo {
    NONE("none", 0, 2, new short[0]),
    ISO_LATIN_1("ISO 8859-1:1987; Latin Alphabet No. 1", 65537, 1, new short[]{17}, CharMapInfo.CM_IDENTITY),
    ISO_LATIN_2("ISO 8859-2:1987; Latin Alphabet No. 2", 65538, 1, new short[]{18}, CharMapInfo.CM_8859_2),
    ISO_LATIN_3("ISO 8859-3:1988; Latin Alphabet No. 3", 65539, 1, new short[]{19}, CharMapInfo.CM_8859_3),
    ISO_LATIN_4("ISO 8859-4:1988; Latin Alphabet No. 4", 65540, 1, new short[]{20}, CharMapInfo.CM_8859_4),
    ISO_8859_5("ISO/IEC 8859-5:1988; Latin-Cyrillic Alphabet", 65541, 1, new short[]{21}, CharMapInfo.CM_8859_5),
    ISO_8859_6("ISO 8859-6:1987; Latin-Arabic Alphabet", 65542, 1, new short[]{22}),
    ISO_8859_7("ISO 8859-7:1987; Latin-Greek Alphabet", 65543, 1, new short[]{23}, CharMapInfo.CM_8859_7),
    ISO_8859_8("ISO 8859-8:1988; Latin-Hebrew Alphabet", 65544, 1, new short[]{24}),
    ISO_8859_9("ISO/IEC 8859-9:1989; Latin Alphabet No. 5", 65545, 1, new short[]{25}, CharMapInfo.CM_8859_9),
    ISO_IEC_8859_10_1992("ISO/IEC 8859-10:1992; Latin Alphabet No. 6", 65546, 1, new short[]{26}),
    ISO_IEC_8859_15_1999("ISO/IEC 8859-15:1999; Latin Alphabet No. 9", 65551, 1, new short[]{17}),
    ISO_646_IRV("ISO 646:1991 IRV (International Reference Version)", 65568, 1, new short[]{1}, CharMapInfo.CM_IDENTITY),
    UCS_2("ISO/IEC 10646-1:1993; UCS-2, Level 1", 65792, 2, new short[]{4096}, CharMapInfo.CM_IDENTITY),
    UCS2_L2("ISO/IEC 10646-1:1993; UCS-2, Level 2", 65793, 2, new short[]{4096}),
    UCS2_L3("ISO/IEC 10646-1:1993; UCS-2, Level 3", 65794, 2, new short[]{4096}),
    USC4_L1("ISO/IEC 10646-1:1993; UCS-4, Level 1", 65796, 4, new short[]{4096}),
    USC4_L2("ISO/IEC 10646-1:1993; UCS-4, Level 2", 65797, 4, new short[]{4096}),
    USC4_L3("ISO/IEC 10646-1:1993; UCS-4, Level 3", 65798, 4, new short[]{4096}),
    UTF1("ISO/IEC 10646-1:1993; UTF-1, UCS Transformation Format 1", 65800, 5, new short[]{4096}),
    UTF_16("ISO/IEC 10646-1:1993; UTF-16, UCS Transformation Format 16-bit form", 65801, 2, new short[]{4096}, CharMapInfo.CM_IDENTITY),
    JIS_X0201_1976("JIS X0201:1976; Japanese phonetic characters", 196609, 1, new short[]{128}),
    JIS_X0208_1978("JIS X0208:1978 Japanese Kanji Graphic Characters", 196612, 2, new short[]{129}),
    JIS_X0208_1983("JIS X0208:1983 Japanese Kanji Graphic Characters", 196613, 2, new short[]{129}),
    JIS_X0208_1990("JIS X0208:1990 Japanese Kanji Graphic Characters", 196614, 2, new short[]{129}),
    JIS_X0212_1990("JIS X0212:1990; Supplementary Japanese Kanji Graphic Chars", 196618, 2, new short[]{130}),
    JIS_eucJP_1993("JIS eucJP:1993; Japanese EUC", 196624, 3, new short[]{17, 128, 129, 130}),
    KS_C5601_1987("KS C5601:1987; Korean Hangul and Hanja Graphic Characters", 262145, 2, new short[]{256}),
    KS_C5657_1991("KS C5657:1991; Supplementary Korean Graphic Characters", 262146, 2, new short[]{257}),
    KS_eucKR_1991("KS eucKR:1991; Korean EUC", 262154, 2, new short[]{17, 256, 257}),
    CNS_11643_1986("CNS 11643:1986; Taiwanese Hanzi Graphic Characters", 327681, 2, new short[]{384}),
    CNS_11643_1992("CNS 11643:1992; Taiwanese Extended Hanzi Graphic Chars", 327682, 4, new short[]{385}),
    CNS_eucTW_1991("CNS eucTW:1991; Taiwanese EUC", 327690, 4, new short[]{1, 384}),
    CNS_eucTW_1993("CNS eucTW:1993; Taiwanese EUC", 327696, 4, new short[]{1, 385}),
    TIS_620_2529("TIS 620-2529, Thai characters", 720897, 1, new short[]{512}),
    TTB_CCDC_1984("TTB CCDC:1984; Chinese Code for Data Communications", 851969, 2, new short[]{384}),
    OSF_Japanese_UJIS("OSF Japanese UJIS", 0x5000010, 2, new short[]{1, 128, 129}),
    OSF_Japanese_SJIS_1("OSF Japanese SJIS-1", 0x5000011, 2, new short[]{1, 128, 129}),
    OSF_Japanese_SJIS_2("OSF Japanese SJIS-2", 83886098, 2, new short[]{1, 128, 129}),
    UTF_8("X/Open UTF-8; UCS Transformation Format 8 (UTF-8)", 0x5010001, 6, new short[]{4096}, CharMapInfo.CM_IDENTITY),
    JVC_eucJP("JVC_eucJP", 84017153, 3, new short[]{1, 128, 129, 130}),
    JVC_SJIS("JVC_SJIS", 0x5020002, 2, new short[]{1, 128, 129}),
    DEC_Kanji("DEC Kanji", 0x10000001, 2, new short[]{17, 128, 129}),
    Super_DEC_Kanji("Super DEC Kanji", 0x10000002, 3, new short[]{17, 128, 129, 130}),
    DEC_Shift_JIS("DEC Shift JIS", 0x10000003, 2, new short[]{17, 128, 129}),
    HP_roman8("HP roman8; English and Western European languages", 0x10010001, 1, new short[]{17}),
    HP_kana8("HP kana8; Japanese katakana (incl JIS X0201:1976)", 0x10010002, 1, new short[]{128}),
    HP_arabic8("HP arabic8; Arabic", 0x10010003, 1, new short[]{22}),
    HP_greek8("HP greek8; Greek", 0x10010004, 1, new short[]{23}),
    HP_hebrew8("HP hebrew8; Hebrew", 0x10010005, 1, new short[]{24}),
    HP_turkish8("HP turkish8; Turkish", 0x10010006, 1, new short[]{19, 25}),
    HP15CN("HP15CN; encoding method for Simplified Chinese", 0x10010007, 2, new short[]{1, 768}),
    HP_big5("HP big5; encoding method for Traditional Chinese", 0x10010008, 2, new short[]{1, 384}),
    HP_japanese15__sjis("HP japanese15 (sjis); Shift-JIS for mainframe (incl JIS X0208:1990)", 0x10010009, 2, new short[]{1, 128, 129}),
    HP_sjishi("HP sjishi; Shift-JIS for HP user (incl JIS X0208:1990)", 0x1001000A, 2, new short[]{1, 128, 129}),
    HP_sjispc("HP sjispc; Shift-JIS for PC (incl JIS X0208:1990)", 0x1001000B, 2, new short[]{1, 128, 129}),
    HP_ujis("HP ujis; EUC (incl JIS X0208:1990)", 0x1001000C, 2, new short[]{1, 128, 129}),
    IBM_037__CCSID_00037("IBM-037 (CCSID 00037); CECP for USA, Canada, NL, Ptgl, Brazil, Australia, NZ", 268566565, 1, new short[]{17}),
    IBM_273__CCSID_00273("IBM-273 (CCSID 00273); CECP for Austria, Germany", 0x10020111, 1, new short[]{17}),
    IBM_277__CCSID_00277("IBM-277 (CCSID 00277); CECP for Denmark, Norway", 268566805, 1, new short[]{17}),
    IBM_278__CCSID_00278("IBM-278 (CCSID 00278); CECP for Finland, Sweden", 268566806, 1, new short[]{17}),
    IBM_280__CCSID_00280("IBM-280 (CCSID 00280); CECP for Italy", 268566808, 1, new short[]{17}),
    IBM_282__CCSID_00282("IBM-282 (CCSID 00282); CECP for Portugal", 268566810, 1, new short[]{17}),
    IBM_284__CCSID_00284("IBM-284 (CCSID 00284); CECP for Spain, Latin America (Spanish)", 268566812, 1, new short[]{17}),
    IBM_285__CCSID_00285("IBM-285 (CCSID 00285); CECP for United Kingdom", 268566813, 1, new short[]{17}),
    IBM_290__CCSID_00290("IBM-290 (CCSID 00290); Japanese Katakana Host Ext SBCS", 0x10020122, 1, new short[]{128}),
    IBM_297__CCSID_00297("IBM-297 (CCSID 00297); CECP for France", 268566825, 1, new short[]{17}),
    IBM_300__CCSID_00300("IBM-300 (CCSID 00300); Japanese Host DBCS incl 4370 UDC", 268566828, 2, new short[]{129}),
    IBM_301__CCSID_00301("IBM-301 (CCSID 00301); Japanese PC Data DBCS incl 1880 UDC", 268566829, 2, new short[]{129}),
    IBM_420__CCSID_00420("IBM-420 (CCSID 00420); Arabic (presentation shapes)", 268566948, 1, new short[]{22}),
    IBM_424__CCSID_00424("IBM-424 (CCSID 00424); Hebrew", 268566952, 1, new short[]{24}),
    IBM_437__CCSID_00437("IBM-437 (CCSID 00437); PC USA", 268566965, 1, new short[]{17}),
    IBM_500__CCSID_00500("IBM-500 (CCSID 00500); CECP for Belgium, Switzerland", 268567028, 1, new short[]{17}),
    IBM_833__CCSID_00833("IBM-833 (CCSID 00833); Korean Host Extended SBCS", 268567361, 1, new short[]{1}),
    IBM_834__CCSID_00834("IBM-834 (CCSID 00834); Korean Host DBCS incl 1227 UDC", 268567362, 2, new short[]{256}),
    IBM_835__CCSID_00835("IBM-835 (CCSID 00835); T-Ch Host DBCS incl 6204 UDC", 268567363, 2, new short[]{384}),
    IBM_836__CCSID_00836("IBM-836 (CCSID 00836); S-Ch Host Extended SBCS", 268567364, 1, new short[]{1}),
    IBM_837__CCSID_00837("IBM-837 (CCSID 00837); S-Ch Host DBCS incl 1880 UDC", 268567365, 2, new short[]{768}),
    IBM_838__CCSID_00838("IBM-838 (CCSID 00838); Thai Host Extended SBCS", 268567366, 1, new short[]{512}),
    IBM_839__CCSID_00839("IBM-839 (CCSID 00839); Thai Host DBCS incl 374 UDC", 268567367, 2, new short[]{512}),
    IBM_850__CCSID_00850("IBM-850 (CCSID 00850); Multilingual IBM PC Data-MLP 222", 268567378, 1, new short[]{17}),
    IBM_852__CCSID_00852("IBM-852 (CCSID 00852); Multilingual Latin-2", 268567380, 1, new short[]{18}),
    IBM_855__CCSID_00855("IBM-855 (CCSID 00855); Cyrillic PC Data", 268567383, 1, new short[]{21}),
    IBM_856__CCSID_00856("IBM-856 (CCSID 00856); Hebrew PC Data (extensions)", 268567384, 1, new short[]{24}),
    IBM_857__CCSID_00857("IBM-857 (CCSID 00857); Turkish Latin-5 PC Data", 268567385, 1, new short[]{25}),
    IBM_861__CCSID_00861("IBM-861 (CCSID 00861); PC Data Iceland", 268567389, 1, new short[]{17}),
    IBM_862__CCSID_00862("IBM-862 (CCSID 00862); PC Data Hebrew", 268567390, 1, new short[]{24}),
    IBM_863__CCSID_00863("IBM-863 (CCSID 00863); PC Data Canadian French", 268567391, 1, new short[]{17}),
    IBM_864__CCSID_00864("IBM-864 (CCSID 00864); Arabic PC Data", 268567392, 1, new short[]{22}),
    IBM_866__CCSID_00866("IBM-866 (CCSID 00866); PC Data Cyrillic 2", 268567394, 1, new short[]{21}),
    IBM_868__CCSID_00868("IBM-868 (CCSID 00868); Urdu PC Data", 268567396, 1, new short[]{22}),
    IBM_869__CCSID_00869("IBM-869 (CCSID 00869); Greek PC Data", 268567397, 1, new short[]{23}),
    IBM_870__CCSID_00870("IBM-870 (CCSID 00870); Multilingual Latin-2 EBCDIC", 268567398, 1, new short[]{18}),
    IBM_871__CCSID_00871("IBM-871 (CCSID 00871); CECP for Iceland", 268567399, 1, new short[]{17}),
    IBM_874__CCSID_00874("IBM-874 (CCSID 00874); Thai PC Display Extended SBCS", 268567402, 1, new short[]{512}),
    IBM_875__CCSID_00875("IBM-875 (CCSID 00875); Greek", 268567403, 1, new short[]{23}),
    IBM_880__CCSID_00880("IBM-880 (CCSID 00880); Multilingual Cyrillic", 268567408, 1, new short[]{21}),
    IBM_891__CCSID_00891("IBM-891 (CCSID 00891); Korean PC Data SBCS", 268567419, 1, new short[]{1}),
    IBM_896__CCSID_00896("IBM-896 (CCSID 00896); Japanese Katakana characters; superset of JIS X0201:1976", 268567424, 1, new short[]{128}),
    IBM_897__CCSID_00897("IBM-897 (CCSID 00897); PC Data Japanese SBCS (use with CP 00301)", 268567425, 1, new short[]{128}),
    IBM_903__CCSID_00903("IBM-903 (CCSID 00903); PC Data Simplified Chinese SBCS (use with  DBCS)", 268567431, 1, new short[]{1}),
    IBM_904__CCSID_00904("IBM-904 (CCSID 00904); PC Data Traditional Chinese SBCS (use with  DBCS)", 268567432, 1, new short[]{1}),
    IBM_918__CCSID_00918("IBM-918 (CCSID 00918); Urdu", 268567446, 1, new short[]{22}),
    IBM_921__CCSID_00921("IBM-921 (CCSID 00921); Baltic 8-Bit", 268567449, 1, new short[]{26}),
    IBM_922__CCSID_00922("IBM-922 (CCSID 00922); Estonia 8-Bit", 268567450, 1, new short[]{26}),
    IBM_926__CCSID_00926("IBM-926 (CCSID 00926); Korean PC Data DBCS incl 1880 UDC", 268567454, 2, new short[]{256}),
    IBM_927__CCSID_00927("IBM-927 (CCSID 00927); T-Ch PC Data DBCS incl 6204 UDC", 268567455, 2, new short[]{384}),
    IBM_928__CCSID_00928("IBM-928 (CCSID 00928); S-Ch PC Data DBCS incl 1880 UDC", 268567456, 2, new short[]{768}),
    IBM_929__CCSID_00929("IBM-929 (CCSID 00929); Thai PC Data DBCS incl 374 UDC", 268567457, 2, new short[]{512}),
    IBM_930__CCSID_00930("IBM-930 (CCSID 00930); Kat-Kanji Host MBCS Ext-SBCS", 268567458, 2, new short[]{128, 129}),
    IBM_932__CCSID_00932("IBM-932 (CCSID 00932); Japanese PC Data Mixed", 268567460, 2, new short[]{128, 129}),
    IBM_933__CCSID_00933("IBM-933 (CCSID 00933); Korean Host Extended SBCS", 268567461, 2, new short[]{1, 256}),
    IBM_934__CCSID_00934("IBM-934 (CCSID 00934); Korean PC Data Mixed", 268567462, 2, new short[]{1, 256}),
    IBM_935__CCSID_00935("IBM-935 (CCSID 00935); S-Ch Host Mixed", 268567463, 2, new short[]{1, 768}),
    IBM_936__CCSID_00936("IBM-936 (CCSID 00936); PC Data S-Ch MBCS", 268567464, 2, new short[]{1, 768}),
    IBM_937__CCSID_00937("IBM-937 (CCSID 00937); T-Ch Host Mixed", 268567465, 2, new short[]{1, 384}),
    IBM_938__CCSID_00938("IBM-938 (CCSID 00938); PC Data T-Ch MBCS", 268567466, 2, new short[]{1, 384}),
    IBM_939__CCSID_00939("IBM-939 (CCSID 00939); Latin-Kanji Host MBCS", 268567467, 2, new short[]{128, 129}),
    IBM_941__CCSID_00941("IBM-941 (CCSID 00941); Japanese PC DBCS for Open", 268567469, 2, new short[]{129}),
    IBM_942__CCSID_00942("IBM-942 (CCSID 00942); Japanese PC Data Mixed", 268567470, 2, new short[]{128, 129}),
    IBM_943__CCSID_00943("IBM-943 (CCSID 00943); Japanese PC MBCS for Open", 268567471, 2, new short[]{128, 129}),
    IBM_946__CCSID_00946("IBM-946 (CCSID 00946); S-Ch PC Data Mixed", 268567474, 2, new short[]{1, 768}),
    IBM_947__CCSID_00947("IBM-947 (CCSID 00947); T-Ch PC Data DBCS incl 6204 UDC", 268567475, 2, new short[]{384}),
    IBM_948__CCSID_00948("IBM-948 (CCSID 00948); T-Ch PC Data Mixed", 268567476, 2, new short[]{1, 384}),
    IBM_949__CCSID_00949("IBM-949 (CCSID 00949); IBM KS PC Data Mixed", 268567477, 2, new short[]{1, 256}),
    IBM_950__CCSID_00950("IBM-950 (CCSID 00950); T-Ch PC Data Mixed", 268567478, 2, new short[]{1, 384}),
    IBM_951__CCSID_00951("IBM-951 (CCSID 00951); IBM KS PC Data DBCS incl 1880 UDC", 268567479, 2, new short[]{256}),
    IBM_955__CCSID_00955("IBM-955 (CCSID 00955); Japan Kanji characters; superset of JIS X0208:1978", 268567483, 2, new short[]{129}),
    IBM_964__CCSID_00964("IBM-964 (CCSID 00964); T-Chinese EUC CNS1163 plane 1,2", 268567492, 4, new short[]{1, 384}),
    IBM_970__CCSID_00970("IBM-970 (CCSID 00970); Korean EUC", 268567498, 2, new short[]{17, 256, 257}),
    IBM_1006__CCSID_01006("IBM-1006 (CCSID 01006); Urdu 8-bit", 268567534, 1, new short[]{22}),
    IBM_1025__CCSID_01025("IBM-1025 (CCSID 01025); Cyrillic Multilingual", 268567553, 1, new short[]{21}),
    IBM_1026__CCSID_01026("IBM-1026 (CCSID 01026); Turkish Latin-5", 268567554, 1, new short[]{25}),
    IBM_1027__CCSID_01027("IBM-1027 (CCSID 01027); Japanese Latin Host Ext SBCS", 268567555, 1, new short[]{128}),
    IBM_1040__CCSID_01040("IBM-1040 (CCSID 01040); Korean PC Data Extended SBCS", 268567568, 1, new short[]{1}),
    IBM_1041__CCSID_01041("IBM-1041 (CCSID 01041); Japanese PC Data Extended SBCS", 268567569, 1, new short[]{128}),
    IBM_1043__CCSID_01043("IBM-1043 (CCSID 01043); T-Ch PC Data Extended SBCS", 268567571, 1, new short[]{1}),
    IBM_1046__CCSID_01046("IBM-1046 (CCSID 01046); Arabic PC Data", 268567574, 1, new short[]{22}),
    IBM_1047__CCSID_01047("IBM-1047 (CCSID 01047); Latin-1 Open System", 268567575, 1, new short[]{17}),
    IBM_1088__CCSID_01088("IBM-1088 (CCSID 01088); IBM KS Code PC Data SBCS", 268567616, 1, new short[]{1}),
    IBM_1097__CCSID_01097("IBM-1097 (CCSID 01097); Farsi", 268567625, 1, new short[]{22}),
    IBM_1098__CCSID_01098("IBM-1098 (CCSID 01098); Farsi PC Data", 268567626, 1, new short[]{22}),
    IBM_1112__CCSID_01112("IBM-1112 (CCSID 01112); Baltic Multilingual", 268567640, 1, new short[]{26}),
    IBM_1114__CCSID_01114("IBM-1114 (CCSID 01114); T-Ch PC Data SBCS (IBM BIG-5)", 268567642, 1, new short[]{1}),
    IBM_1115__CCSID_01115("IBM-1115 (CCSID 01115); S-Ch PC Data SBCS (IBM GB)", 268567643, 1, new short[]{1}),
    IBM_1122__CCSID_01122("IBM-1122 (CCSID 01122); Estonia", 268567650, 1, new short[]{26}),
    IBM_1250__CCSID_01250("IBM-1250 (CCSID 01250); MS Windows Latin-2", 268567778, 1, new short[]{18}),
    IBM_1251__CCSID_01251("IBM-1251 (CCSID 01251); MS Windows Cyrillic", 268567779, 1, new short[]{21}),
    IBM_1252__CCSID_01252("IBM-1252 (CCSID 01252); MS Windows Latin-1", 268567780, 1, new short[]{17}),
    IBM_1253__CCSID_01253("IBM-1253 (CCSID 01253); MS Windows Greek", 268567781, 1, new short[]{23}),
    IBM_1254__CCSID_01254("IBM-1254 (CCSID 01254); MS Windows Turkey", 268567782, 1, new short[]{25}),
    IBM_1255__CCSID_01255("IBM-1255 (CCSID 01255); MS Windows Hebrew", 268567783, 1, new short[]{24}),
    IBM_1256__CCSID_01256("IBM-1256 (CCSID 01256); MS Windows Arabic", 268567784, 1, new short[]{22}),
    IBM_1257__CCSID_01257("IBM-1257 (CCSID 01257); MS Windows Baltic", 268567785, 1, new short[]{26}),
    IBM_1380__CCSID_01380("IBM-1380 (CCSID 01380); S-Ch PC Data DBCS incl 1880 UDC", 268567908, 2, new short[]{768}),
    IBM_1381__CCSID_01381("IBM-1381 (CCSID 01381); S-Ch PC Data Mixed incl 1880 UDC", 268567909, 2, new short[]{1, 768}),
    IBM_1383__CCSID_01383("IBM-1383 (CCSID 01383); S-Ch EUC GB 2312-80 set (1382)", 268567911, 3, new short[]{1, 768}),
    IBM_300__CCSID_04396("IBM-300 (CCSID 04396); Japanese Host DBCS incl 1880 UDC", 268570924, 2, new short[]{129}),
    IBM_850__CCSID_04946("IBM-850 (CCSID 04946); Multilingual IBM PC Data-190", 268571474, 1, new short[]{17}),
    IBM_852__CCSID_04948("IBM-852 (CCSID 04948); Latin-2 Personal Computer", 268571476, 1, new short[]{18}),
    IBM_855__CCSID_04951("IBM-855 (CCSID 04951); Cyrillic Personal Computer", 268571479, 1, new short[]{21}),
    IBM_856__CCSID_04952("IBM-856 (CCSID 04952); Hebrew PC Data", 268571480, 1, new short[]{24}),
    IBM_857__CCSID_04953("IBM-857 (CCSID 04953); Turkish Latin-5 PC Data", 268571481, 1, new short[]{25}),
    IBM_864__CCSID_04960("IBM-864 (CCSID 04960); Arabic PC Data (all shapes)", 268571488, 1, new short[]{22}),
    IBM_868__CCSID_04964("IBM-868 (CCSID 04964); PC Data for Urdu", 268571492, 1, new short[]{22}),
    IBM_869__CCSID_04965("IBM-869 (CCSID 04965); Greek PC Data", 268571493, 1, new short[]{23}),
    IBM_5026__CCSID_05026("IBM-5026 (CCSID 05026); Japanese Katakana-Kanji Host Mixed", 268571554, 2, new short[]{128, 129}),
    IBM_5031__CCSID_05031("IBM-5031 (CCSID 05031); S-Ch Host MBCS", 268571559, 2, new short[]{1, 768}),
    IBM_1027_and__300__CCSID_05035("IBM-1027 and -300 (CCSID 05035); Japanese Latin-Kanji Host Mixed", 268571563, 2, new short[]{128, 129}),
    IBM_5048__CCSID_05048("IBM-5048 (CCSID 05048); Japanese Kanji characters; superset of JIS X0208:1990 (and 1983)", 268571576, 2, new short[]{129}),
    IBM_5049__CCSID_05049("IBM-5049 (CCSID 05049); Japanese Kanji characters; superset of JIS X0212:1990", 268571577, 2, new short[]{130}),
    IBM_5067__CCSID_05067("IBM-5067 (CCSID 05067); Korean Hangul and Hanja; superset of KS C5601:1987", 268571595, 2, new short[]{256}),
    IBM_420__CCSID_08612("IBM-420 (CCSID 08612); Arabic (base shapes only)", 268575140, 1, new short[]{22}),
    IBM_833__CCSID_09025("IBM-833 (CCSID 09025); Korean Host SBCS", 268575553, 1, new short[]{1}),
    IBM_834__CCSID_09026("IBM-834 (CCSID 09026); Korean Host DBCS incl 1880 UDC", 268575554, 2, new short[]{256}),
    IBM_838__CCSID_09030("IBM-838 (CCSID 09030); Thai Host Extended SBCS", 268575558, 1, new short[]{512}),
    IBM_864__CCSID_09056("IBM-864 (CCSID 09056); Arabic PC Data (unshaped)", 268575584, 1, new short[]{22}),
    IBM_874__CCSID_09066("IBM-874 (CCSID 09066); Thai PC Display Extended SBCS", 268575594, 1, new short[]{512}),
    IBM_9125__CCSID_09125("IBM-9125 (CCSID 09125); Korean Host Mixed incl 1880 UDC", 268575653, 2, new short[]{1, 256}),
    IBM_850__CCSID_25426("IBM-850 (CCSID 25426); Multilingual IBM PC Display-MLP", 268591954, 1, new short[]{17}),
    IBM_856__CCSID_25432("IBM-856 (CCSID 25432); Hebrew PC Display (extensions)", 268591960, 1, new short[]{24}),
    IBM_1042__CCSID_25618("IBM-1042 (CCSID 25618); S-Ch PC Display Ext SBCS", 268592146, 1, new short[]{1}),
    IBM_037__CCSID_28709("IBM-037 (CCSID 28709); T-Ch Host Extended SBCS", 268595237, 1, new short[]{1}),
    IBM_856__CCSID_33624("IBM-856 (CCSID 33624); Hebrew PC Display", 268600152, 1, new short[]{24}),
    IBM33722__CCSID_33722("IBM33722 (CCSID 33722); Japanese EUC JISx201,208,212", 268600250, 3, new short[]{128, 129, 130}),
    HTCsjis("HTCsjis; Hitachi SJIS 90-1", 0x10030001, 2, new short[]{1, 128, 129}),
    HTCujis("HTCujis; Hitachi eucJP 90-1", 268632066, 2, new short[]{1, 128, 129}),
    Fujitsu_U90("Fujitsu U90; Japanese EUC", 0x10040001, 3, new short[]{1, 128, 129}),
    Fujitsu_S90("Fujitsu S90; Japanese EUC", 268697602, 3, new short[]{1, 128, 129}),
    Fujitsu_R90("Fujitsu R90; Fujitsu Shift JIS", 268697603, 2, new short[]{1, 128, 129}),
    EBCDIC_ASCII__and_JEF("EBCDIC(ASCII) and JEF; Japanese encoding method for mainframe", 0x10040004, 3, new short[]{1, 129}),
    EBCDIC_Katakana__and_JEF("EBCDIC(Katakana) and JEF; Japanese encoding method for mainframe", 268697605, 3, new short[]{1, 128, 129}),
    EBCDIC_Japanese_English__and_JEF("EBCDIC(Japanese English) and JEF; Japanese encoding method for mainframe", 268697606, 3, new short[]{1, 129});

    private static final Map<Integer, CodeSetInfo> REGISTRY;
    public final short max_bytes;
    final String description;
    public final int id;
    final CharMapInfo charMap;
    private final short[] charsets;

    private CodeSetInfo(String desc, int reg_id, int max_width, short[] charsets, CharMapInfo charMap) {
        this.description = desc;
        this.id = reg_id;
        this.max_bytes = (short)max_width;
        this.charsets = charsets;
        this.charMap = charMap;
    }

    private CodeSetInfo(String desc, int reg_id, int max_width, short[] charsets) {
        this(desc, reg_id, max_width, charsets, null);
    }

    public static int getRegistryIdForName(String name) {
        Objects.requireNonNull(name);
        for (CodeSetInfo value : REGISTRY.values()) {
            if (!value.description.contains(name)) continue;
            return value.id;
        }
        return CodeSetInfo.NONE.id;
    }

    public static CodeSetInfo forRegistryId(int registryId) {
        return REGISTRY.get(registryId);
    }

    public static String describe(int registryId) {
        CodeSetInfo info = REGISTRY.get(registryId);
        return null == info ? CodeSetInfo.NONE.description : info.description;
    }

    boolean isCompatibleWith(CodeSetInfo that) {
        if (that == null) {
            return false;
        }
        for (short thisCharset : this.charsets) {
            for (short thatCharset : that.charsets) {
                if (thisCharset != thatCharset) continue;
                return true;
            }
        }
        return false;
    }

    static {
        LinkedHashMap<Integer, CodeSetInfo> m = new LinkedHashMap<Integer, CodeSetInfo>();
        for (CodeSetInfo info : EnumSet.complementOf(EnumSet.of(NONE))) {
            m.put(info.id, info);
        }
        REGISTRY = Collections.unmodifiableMap(m);
    }
}

