/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.servlet;

import com.ibm.ws.webcontainer.servlet.TimedServletPoolElement;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class TimedServletPool {
    private long _maxIdleTime;
    protected Vector _allElements = new Vector();
    private Vector _idleElements = new Vector();
    protected ServletConfig _config;
    protected Class _servletClass;

    public TimedServletPool(int initialPoolSize, long maxIdleTime, Class servletClass, ServletConfig config) throws InstantiationException, IllegalAccessException, ServletException {
        this._maxIdleTime = maxIdleTime;
        this._servletClass = servletClass;
        this._config = config;
        long l = maxIdleTime = maxIdleTime < 1000L ? 1000L : maxIdleTime;
        if (initialPoolSize < 1) {
            initialPoolSize = 1;
        }
        for (int i = 0; i < initialPoolSize; ++i) {
            this.addElementToIdleList(this.createNewElement());
        }
    }

    public synchronized TimedServletPoolElement getNextElement() throws InstantiationException, IllegalAccessException, ServletException {
        int idleCount = this._idleElements.size();
        TimedServletPoolElement e = null;
        if (idleCount > 0) {
            int lastIndex = 0;
            e = (TimedServletPoolElement)this._idleElements.elementAt(lastIndex);
            this._idleElements.removeElementAt(lastIndex);
        } else {
            e = this.createNewElement();
        }
        return e;
    }

    synchronized void removeExpiredElements() {
        TimedServletPoolElement e = null;
        int idleCount = this._idleElements.size();
        for (int i = 0; i < idleCount; ++i) {
            e = (TimedServletPoolElement)this._idleElements.elementAt(0);
            if (e.getIdleTime() <= this._maxIdleTime) {
                return;
            }
            this._allElements.removeElement(e);
            this._idleElements.removeElementAt(0);
            e.getServlet().destroy();
        }
    }

    synchronized void removeAllElements() {
        Enumeration elements = this._allElements.elements();
        while (elements.hasMoreElements()) {
            TimedServletPoolElement e = (TimedServletPoolElement)elements.nextElement();
            this._allElements.removeElement(e);
            this._idleElements.removeElement(e);
            e.getServlet().destroy();
        }
    }

    public synchronized void returnElement(TimedServletPoolElement e) {
        this.addElementToIdleList(e);
    }

    public void setMaxIdleTime(long millisecs) {
        this._maxIdleTime = millisecs;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSize() {
        return this._allElements.size();
    }

    protected TimedServletPoolElement createNewElement() throws InstantiationException, IllegalAccessException, ServletException {
        Servlet s = (Servlet)this._servletClass.newInstance();
        s.init(this._config);
        TimedServletPoolElement e = new TimedServletPoolElement(s);
        this._allElements.addElement(e);
        return e;
    }

    protected synchronized void addElementToIdleList(TimedServletPoolElement e) {
        e.access();
        this._idleElements.addElement(e);
    }
}

