/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.providers.AbstractLibraryListener;
import com.ibm.ws.classloading.internal.providers.Providers;
import com.ibm.ws.classloading.internal.util.BlockingList;
import com.ibm.ws.classloading.internal.util.ElementNotReadyException;
import com.ibm.ws.classloading.internal.util.ElementNotValidException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.library.Library;
import java.util.EnumSet;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class GetLibraryLoaders
implements BlockingList.Retriever<String, Providers.LoaderInfo>,
BlockingList.Listener<String, Providers.LoaderInfo> {
    static final TraceComponent tc = Tr.register(GetLibraryLoaders.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private final EnumSet<ApiType> ownerAPIs;
    private final String ownerID;
    private final GlobalClassloadingConfiguration.LibraryPrecedence precedence;
    static final long serialVersionUID = -1174749213537539807L;

    GetLibraryLoaders(String ownerId, EnumSet<ApiType> ownerAPIs, GlobalClassloadingConfiguration.LibraryPrecedence precedence) {
        this.ownerID = ownerId;
        this.ownerAPIs = ownerAPIs;
        this.precedence = precedence;
    }

    @Override
    public Providers.LoaderInfo fetch(String id) throws ElementNotReadyException, ElementNotValidException {
        Library lib = Providers.getSharedLibrary(id);
        if (lib == null) {
            throw new ElementNotReadyException(id);
        }
        if (this.libraryAndLoaderApiTypesDoNotMatch(lib)) {
            throw new ElementNotValidException();
        }
        return new Providers.LoaderInfo((LibertyLoader)lib.getClassLoader(), this.precedence);
    }

    @Override
    public void listenFor(final String libraryId, final BlockingList.Slot<? super Providers.LoaderInfo> slot) {
        new AbstractLibraryListener(libraryId, this.ownerID, Providers.bundleContext){
            static final long serialVersionUID = -7034744589467751027L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            void update() {
                String methodName = "update(): ";
                Library library = Providers.getSharedLibrary(libraryId);
                if (library == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("update(): class loader " + GetLibraryLoaders.this.ownerID + "received a notification from the shared library " + libraryId + " but the library could not be retrieved."), (Object[])new Object[0]);
                    }
                    return;
                }
                if (GetLibraryLoaders.this.libraryAndLoaderApiTypesDoNotMatch(library)) {
                    slot.delete();
                } else {
                    LibertyLoader libCL = (LibertyLoader)library.getClassLoader();
                    slot.fill(new Providers.LoaderInfo(libCL, GetLibraryLoaders.this.precedence));
                }
                this.deregister();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.providers.GetLibraryLoaders$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        };
    }

    private boolean libraryAndLoaderApiTypesDoNotMatch(Library sharedLibrary) {
        return !Providers.checkAPITypesMatch(sharedLibrary, this.ownerID, this.ownerAPIs);
    }
}

