/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class ConcurrentHashSet
extends AbstractSet {
    private static final Class cclass = ConcurrentHashSet.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(ConcurrentHashSet.class, "ObjectManagerMaps");
    private final Set[] subSets;

    public ConcurrentHashSet(int subSetCount) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", "subSetCount=" + subSetCount + "(int)");
        }
        this.subSets = new HashSet[subSetCount];
        for (int i = 0; i < this.subSets.length; ++i) {
            this.subSets[i] = new HashSet();
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    private final Set getSubSet(Object key) {
        return this.subSets[(key.hashCode() & Integer.MAX_VALUE) % this.subSets.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(Object key) {
        Set subSet;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "add", "key=" + key + "(Object)");
        }
        boolean found = false;
        Set set = subSet = this.getSubSet(key);
        synchronized (set) {
            found = subSet.add(key);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "add", "returns found=" + found + "(boolean)");
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        for (int i = 0; i < this.subSets.length; ++i) {
            Set set = this.subSets[i];
            synchronized (set) {
                this.subSets[i].clear();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        HashSet combinedSet = new HashSet();
        if (this.subSets != null) {
            for (int i = 0; i < this.subSets.length; ++i) {
                Set set = this.subSets[i];
                synchronized (set) {
                    combinedSet.addAll(this.subSets[i]);
                    continue;
                }
            }
        }
        return combinedSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean remove(Object key) {
        Set subSet;
        Set set = subSet = this.getSubSet(key);
        synchronized (set) {
            return subSet.remove(key);
        }
    }

    @Override
    public final int size() {
        int overallSize = 0;
        if (this.subSets != null) {
            for (int i = 0; i < this.subSets.length; ++i) {
                overallSize += this.subSets[i].size();
            }
        }
        return overallSize;
    }

    @Override
    public String toString() {
        return new String(cclass.getName() + "/" + (this.subSets == null ? 0 : this.subSets.length) + "/" + Integer.toHexString(this.hashCode()));
    }
}

