/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.jaxrs20.multipart;

import com.ibm.websphere.jaxrs20.multipart.IAttachment;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs20.multipart.impl.AttachmentImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AttachmentBuilder {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_ID_HEADER = "Content-ID";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final List<String> DEFAULT_CONTENT_ID;
    private InputStream inputStream;
    private String fileName;
    private final MultivaluedMap<String, String> headers = new MultivaluedHashMap();
    private final String fieldName;
    static final long serialVersionUID = 2254972926981473625L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static AttachmentBuilder newBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must be non-null");
        }
        return new AttachmentBuilder(fieldName);
    }

    private AttachmentBuilder(String fieldName) {
        this.fieldName = fieldName;
    }

    public AttachmentBuilder contentId(String contentId) {
        this.headers.putSingle((Object)CONTENT_ID_HEADER, (Object)contentId);
        return this;
    }

    public AttachmentBuilder contentType(MediaType contentType) {
        return this.contentType(contentType.toString());
    }

    public AttachmentBuilder contentType(String contentType) {
        this.headers.putSingle((Object)CONTENT_TYPE_HEADER, (Object)contentType);
        return this;
    }

    public AttachmentBuilder header(String headerName, String ... headerValues) {
        if (headerValues.length < 1) {
            this.headers.remove((Object)headerName);
        } else {
            this.headers.put((Object)headerName, Arrays.asList(headerValues));
        }
        return this;
    }

    public AttachmentBuilder headers(MultivaluedMap<String, String> newHeaders) {
        this.headers.putAll(newHeaders);
        return this;
    }

    public AttachmentBuilder fileName(String fileName) {
        AttachmentBuilder.checkNull("fileName", fileName);
        this.fileName = fileName;
        return this;
    }

    public AttachmentBuilder inputStream(InputStream inputStream) {
        AttachmentBuilder.checkNull("inputStream", inputStream);
        this.inputStream = inputStream;
        return this;
    }

    public AttachmentBuilder inputStream(String fileName, InputStream inputStream) {
        return this.fileName(fileName).inputStream(inputStream);
    }

    public IAttachment build() {
        if (this.inputStream == null) {
            throw new IllegalStateException("inputStream must be set");
        }
        this.headers.putIfAbsent((Object)CONTENT_ID_HEADER, DEFAULT_CONTENT_ID);
        this.headers.computeIfAbsent((Object)CONTENT_DISPOSITION_HEADER, this::constructContentDispositionHeaderValue);
        this.headers.computeIfAbsent((Object)CONTENT_TYPE_HEADER, this::constructContentTypeHeaderValue);
        Attachment att = new Attachment(this.inputStream, this.headers);
        AttachmentImpl attImpl = new AttachmentImpl(att);
        return attImpl;
    }

    private List<String> constructContentDispositionHeaderValue(String headerName) {
        StringBuilder sb = new StringBuilder();
        sb.append("form-data; name=\"");
        sb.append(this.fieldName);
        sb.append("\"");
        if (this.fileName != null) {
            sb.append("; filename=\"");
            sb.append(this.fileName);
            sb.append("\"");
        }
        return Collections.singletonList(sb.toString());
    }

    private List<String> constructContentTypeHeaderValue(String headerName) {
        String mediaType = this.fileName == null ? "text/plain" : "application/octet-stream";
        return Collections.singletonList(mediaType);
    }

    private static void checkNull(String attr, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(attr + " must not be null");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.jaxrs20.multipart.AttachmentBuilder", AttachmentBuilder.class, null, null);
        DEFAULT_CONTENT_ID = Collections.singletonList("[root.message@openliberty.io]");
    }
}

