/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.FederationRegistry;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.wim.ConfigManager;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.security.wim.registry.util.BridgeUtils;
import com.ibm.ws.security.wim.registry.util.DisplayNameBridge;
import com.ibm.ws.security.wim.registry.util.LoginBridge;
import com.ibm.ws.security.wim.registry.util.MembershipBridge;
import com.ibm.ws.security.wim.registry.util.SearchBridge;
import com.ibm.ws.security.wim.registry.util.SecurityNameBridge;
import com.ibm.ws.security.wim.registry.util.UniqueIdBridge;
import com.ibm.ws.security.wim.registry.util.ValidBridge;
import com.ibm.wsspi.security.wim.exception.NoUserRepositoriesFoundException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.ws.security.registry.type=WIM"})
public class WIMUserRegistry
implements FederationRegistry,
UserRegistry {
    private static final TraceComponent tc = Tr.register(WIMUserRegistry.class, null, null);
    @Reference
    ConfigManager configManager;
    @Reference
    VMMService vmmService;
    private static final String TOKEN_DELIMETER = "::";
    private BridgeUtils mappingUtils;
    private LoginBridge loginBridge;
    private DisplayNameBridge displayBridge;
    private SecurityNameBridge securityBridge;
    private UniqueIdBridge uniqueBridge;
    private ValidBridge validBridge;
    private SearchBridge searchBridge;
    private MembershipBridge membershipBridge;
    private final Random failResponseRandom = new Random();
    static final long serialVersionUID = -6605449661554825517L;

    @Activate
    protected void activate() {
        Map props = this.configManager.getConfigurationProperties();
        this.initializeUtils(props);
    }

    public String getType() {
        return "WIM";
    }

    private void initializeUtils(Map<String, Object> configProps) {
        this.mappingUtils = new BridgeUtils(this.vmmService, this.configManager);
        this.loginBridge = new LoginBridge(this.mappingUtils);
        this.displayBridge = new DisplayNameBridge(this.mappingUtils);
        this.securityBridge = new SecurityNameBridge(this.mappingUtils);
        this.uniqueBridge = new UniqueIdBridge(this.mappingUtils);
        this.validBridge = new ValidBridge(this.mappingUtils);
        this.searchBridge = new SearchBridge(this.mappingUtils);
        this.membershipBridge = new MembershipBridge(this.mappingUtils);
        this.mappingUtils.initialize(configProps);
    }

    @Deactivate
    protected void deinitializeUtils() {
        this.mappingUtils = null;
        this.loginBridge = null;
        this.displayBridge = null;
        this.securityBridge = null;
        this.uniqueBridge = null;
        this.validBridge = null;
        this.searchBridge = null;
        this.membershipBridge = null;
    }

    @FFDCIgnore(value={Exception.class})
    public String checkPassword(String inputUser, @Sensitive String inputPassword) throws RegistryException {
        if (this.loginBridge == null) {
            return null;
        }
        String returnValue = null;
        try {
            String string = returnValue = this.loginBridge.checkPassword(inputUser, inputPassword);
            return string;
        }
        catch (Exception excp) {
            if (excp instanceof RegistryException) {
                Throwable t = excp.getCause();
                if (t != null && t instanceof NoUserRepositoriesFoundException) {
                    throw excp;
                }
                String string = null;
                return string;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
        finally {
            if (returnValue == null) {
                this.failedLoginDelay();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void failedLoginDelay() {
        block6: {
            String methodName = "failedLoginDelay";
            try {
                int failResponseDelayMax = this.mappingUtils.getCoreConfiguration().getFailResponseDelayMax();
                int failResponseDelayMin = this.mappingUtils.getCoreConfiguration().getFailResponseDelayMin();
                if (failResponseDelayMax > 0) {
                    int random = this.failResponseRandom.nextInt(failResponseDelayMax + 1 - failResponseDelayMin) + failResponseDelayMin;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(methodName + " failed response login delay is " + random + " ms. The minimum and maximum delay for failed logons are " + failResponseDelayMin + " ms and " + failResponseDelayMax + " ms."), (Object[])new Object[0]);
                    }
                    Thread.sleep(random);
                }
            }
            catch (InterruptedException failResponseDelayMax) {
                FFDCFilter.processException((Throwable)failResponseDelayMax, (String)"com.ibm.ws.security.wim.registry.WIMUserRegistry", (String)"208", (Object)this, (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(methodName + " failed response login delay sleep was interrupted."), (Object[])new Object[0]);
                }
            }
            catch (Exception ie) {
                void e;
                FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws.security.wim.registry.WIMUserRegistry", (String)"213", (Object)this, (Object[])new Object[0]);
                if (!tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)(methodName + " failed response login delay processing hit an exception. Ignore so we return the failed login."), (Object[])new Object[]{e});
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        try {
            String returnValue = this.loginBridge.mapCertificate(chain);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof CertificateMapFailedException) {
                throw (CertificateMapFailedException)excp;
            }
            if (excp instanceof CertificateMapNotSupportedException) {
                throw (CertificateMapNotSupportedException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    public String getRealm() {
        return this.vmmService.getRealmName();
    }

    @FFDCIgnore(value={Exception.class})
    public SearchResult getUsers(String inputPattern, int inputLimit) throws RegistryException {
        try {
            SearchResult returnValue = this.searchBridge.getUsers(inputPattern, inputLimit);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String getUserDisplayName(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            String returnValue = this.displayBridge.getUserDisplayName(inputUserSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    protected String parseUserId(String securityName) {
        int idx = securityName.indexOf(TOKEN_DELIMETER);
        if (idx > 0) {
            return securityName.substring(0, idx);
        }
        return securityName;
    }

    @FFDCIgnore(value={Exception.class})
    public String getUniqueUserId(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        HashMap<String, String> result = null;
        try {
            result = this.uniqueBridge.getUniqueUserId(this.parseUserId(inputUserSecurityName));
            return result.get("RESULT");
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String getUserSecurityName(String inputUniqueUserId) throws EntryNotFoundException, RegistryException {
        HashMap<String, String> result = null;
        try {
            result = this.uniqueBridge.getUniqueUserId(this.parseUserId(inputUniqueUserId));
            String returnValue = result.get("RESULT");
            if (!inputUniqueUserId.equalsIgnoreCase(returnValue)) {
                inputUniqueUserId = returnValue;
            }
        }
        catch (Exception returnValue) {
            // empty catch block
        }
        try {
            String id = inputUniqueUserId;
            if (id.startsWith("user:") || id.startsWith("group:")) {
                id = this.getUserFromUniqueID(id);
            }
            return this.securityBridge.getUserSecurityName(id);
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public boolean isValidUser(String inputUserSecurityName) throws RegistryException {
        try {
            boolean returnValue = this.validBridge.isValidUser(inputUserSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public SearchResult getGroups(String inputPattern, int inputLimit) throws RegistryException {
        try {
            SearchResult returnValue = this.searchBridge.getGroups(inputPattern, inputLimit);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String getGroupDisplayName(String inputGroupSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            String returnValue = this.displayBridge.getGroupDisplayName(inputGroupSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String getUniqueGroupId(String inputGroupSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            String returnValue = this.uniqueBridge.getUniqueGroupId(inputGroupSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public List<String> getUniqueGroupIdsForUser(String inputUniqueUserId) throws EntryNotFoundException, RegistryException {
        try {
            String id = inputUniqueUserId;
            if (id.startsWith("user:") || id.startsWith("group:")) {
                id = this.getUserFromUniqueID(id);
            }
            List<String> returnValue = this.membershipBridge.getUniqueGroupIds(id);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public String getGroupSecurityName(String inputUniqueGroupId) throws EntryNotFoundException, RegistryException {
        try {
            String returnValue = this.securityBridge.getGroupSecurityName(inputUniqueGroupId);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public boolean isValidGroup(String inputGroupSecurityName) throws RegistryException {
        try {
            boolean returnValue = this.validBridge.isValidGroup(inputGroupSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public List<String> getGroupsForUser(String inputUserSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            List<String> returnValue = this.membershipBridge.getGroupsForUser(inputUserSecurityName);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException, RegistryException {
        try {
            SearchResult returnValue = this.membershipBridge.getUsersForGroup(groupSecurityName, limit);
            return returnValue;
        }
        catch (Exception excp) {
            if (excp instanceof EntryNotFoundException) {
                throw (EntryNotFoundException)excp;
            }
            if (excp instanceof RegistryException) {
                throw (RegistryException)excp;
            }
            throw new RegistryException(excp.getMessage(), (Throwable)excp);
        }
    }

    private String getUserFromUniqueID(String id) {
        if (id == null) {
            return "";
        }
        int realmDelimiterIndex = (id = id.trim()).indexOf("/");
        if (realmDelimiterIndex < 0) {
            return "";
        }
        return id.substring(realmDelimiterIndex + 1);
    }

    public void addFederationRegistries(List<UserRegistry> registries) {
        this.mappingUtils.addFederationRegistries(registries);
    }

    public void removeAllFederatedRegistries() {
        this.mappingUtils.removeAllFederatedRegistries();
    }
}

