/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.utils.ras.SibTr;

public class JFapUtils {
    private static final TraceComponent tc = SibTr.register(JFapUtils.class, (String)"SIBJFapSummary", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

    public static void debugTraceWsByteBuffer(Object _this, TraceComponent _tc, WsByteBuffer buffer, int amount, String comment) {
        int start;
        byte[] data = null;
        int count = amount;
        if (count > buffer.remaining()) {
            count = buffer.remaining();
        }
        if (buffer.hasArray()) {
            data = buffer.array();
            start = buffer.arrayOffset() + buffer.position();
        } else {
            data = new byte[count];
            int pos = buffer.position();
            buffer.get(data);
            buffer.position(pos);
            start = 0;
        }
        StringBuffer sb = new StringBuffer(comment);
        sb.append("\nbuffer hashcode:  ");
        sb.append(buffer.hashCode());
        sb.append("\nbuffer position:  ");
        sb.append(buffer.position());
        sb.append("\nbuffer remaining: ");
        sb.append(buffer.remaining());
        sb.append("\n");
        SibTr.debug((Object)_this, (TraceComponent)_tc, (String)sb.toString());
        if (count > 0) {
            SibTr.bytes((Object)_this, (TraceComponent)_tc, (byte[])data, (int)start, (int)count, (String)("First " + count + " bytes of buffer data:"));
        }
    }

    public static int copyWsByteBuffer(WsByteBuffer src, WsByteBuffer dst, int amount) {
        int amountCopied = amount;
        int dstRemaining = dst.remaining();
        int srcRemaining = src.remaining();
        if (amountCopied > dstRemaining) {
            amountCopied = dstRemaining;
        }
        if (amountCopied > srcRemaining) {
            amountCopied = srcRemaining;
        }
        if (amountCopied > 0) {
            int srcLimit = src.limit();
            src.limit(src.position() + amountCopied);
            dst.put(src);
            src.limit(srcLimit);
        }
        return amountCopied;
    }

    public static void debugTraceWsByteBufferInfo(Object _this, TraceComponent _tc, WsByteBuffer buffer, String string) {
        if (buffer != null) {
            StringBuffer sb = new StringBuffer(buffer.getClass().toString());
            sb.append("@");
            sb.append(Integer.toHexString(System.identityHashCode(buffer)));
            sb.append(" pos=");
            sb.append(buffer.position());
            sb.append(" limit=");
            sb.append(buffer.limit());
            sb.append(" - ");
            sb.append(string);
            SibTr.debug((Object)_this, (TraceComponent)_tc, (String)sb.toString());
        } else {
            SibTr.debug((Object)_this, (TraceComponent)_tc, (String)("WsByteBuffer: null - " + string));
        }
    }

    public static void debugSummaryMessage(TraceComponent callersTrace, Connection connection, ConversationImpl conversation, String remark, int requestNumber) {
        if (tc.isDebugEnabled() || callersTrace.isDebugEnabled() || SIBMessageTraceJfap.tcjfs.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("{JFAPSUMMARY}");
            sb.append("[");
            if (connection != null) {
                sb.append(connection.getEyeCatcher());
            }
            sb.append(":");
            if (conversation != null) {
                sb.append(conversation.getId());
            }
            sb.append(":");
            sb.append(requestNumber);
            sb.append("] ");
            if (connection != null) {
                sb.append(Integer.toHexString(System.identityHashCode(connection)));
                sb.append("[");
                sb.append(connection.description);
                sb.append(", closeDeferred=");
                sb.append(connection.isCloseDeferred());
                sb.append(", invalidateDeferred=");
                sb.append(connection.isInvalidateDeferred());
                sb.append("]:");
            } else {
                sb.append("null[]:");
            }
            if (conversation != null) {
                sb.append(Integer.toHexString(System.identityHashCode(conversation)));
                sb.append("[");
                sb.append(conversation.description);
                sb.append("] ");
            } else {
                sb.append("null[] ");
            }
            if (remark != null) {
                sb.append(remark);
            } else {
                sb.append("null");
            }
            if (SIBMessageTraceJfap.tcjfs.isDebugEnabled()) {
                SibTr.debug((TraceComponent)SIBMessageTraceJfap.tcjfs, (String)sb.toString());
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)sb.toString());
            } else if (callersTrace.isDebugEnabled()) {
                SibTr.debug((TraceComponent)callersTrace, (String)sb.toString());
            }
        }
    }

    public static void debugSummaryMessage(TraceComponent callersTrace, Connection connection, ConversationImpl conversation, String remark) {
        JFapUtils.debugSummaryMessage(callersTrace, connection, conversation, remark, -1);
    }

    private static final class SIBMessageTraceJfap {
        private static final TraceComponent tcjfs = SibTr.register(SIBMessageTraceJfap.class, (String)"SIBMessageTraceJFap", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");

        private SIBMessageTraceJfap() {
        }
    }
}

