/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.resource;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.inputsource.JspInputSourceContainerImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.resource.ResourceUtil;
import com.ibm.ws.jsp.translator.resource.ResourcesImpl;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagFileInfo;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class TagFileResourcesImpl
extends ResourcesImpl
implements TagFileResources {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.resource.TagFileResourcesImpl";
    private boolean hasContainer;
    private String webinfClassRelativeUrl;
    private transient Container container;
    static final long serialVersionUID = -999206091927164156L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagFileResourcesImpl(JspInputSource inputSource, TagFileInfo tfi, JspOptions options, JspCoreContext context) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{inputSource, tfi, options, context});
        }
        this.hasContainer = false;
        this.inputSource = inputSource;
        if (inputSource instanceof JspInputSourceContainerImpl) {
            this.hasContainer = true;
            this.container = ((JspInputSourceContainerImpl)inputSource).getContainer();
        } else if (inputSource.getAbsoluteURL().getProtocol().equals("file")) {
            this.sourceFile = new File(context.getRealPath(inputSource.getRelativeURL()));
        } else {
            String file = inputSource.getContextURL().getFile();
            this.sourceFile = new File(file.substring(file.indexOf("file:") + 5, file.indexOf("!/")));
        }
        String tagFilePath = null;
        String tldOriginatorId = null;
        TagLibraryInfoImpl tli = (TagLibraryInfoImpl)tfi.getTagInfo().getTagLibrary();
        tldOriginatorId = tli.getOriginatorId();
        if (tfi.getPath().startsWith("/WEB-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/WEB-INF/tags") + 13);
        } else if (tfi.getPath().startsWith("/META-INF/tags")) {
            tagFilePath = tfi.getPath().substring(tfi.getPath().indexOf("/META-INF/tags") + 14);
        }
        tagFilePath = tagFilePath.substring(0, tagFilePath.lastIndexOf("/"));
        if (tagFilePath.indexOf("-") > -1) {
            tagFilePath = NameMangler.handlePackageName(tagFilePath);
            tagFilePath = File.separatorChar + tagFilePath;
            tagFilePath = tagFilePath.replace('.', File.separatorChar);
        } else {
            tagFilePath = tagFilePath.replace('/', File.separatorChar);
        }
        tagFilePath = tagFilePath.replace('/', File.separatorChar);
        tagFilePath = Constants.TAGFILE_PACKAGE_PATH + tldOriginatorId + tagFilePath;
        this.packageName = tagFilePath.replace(File.separatorChar, '.');
        this.className = tfi.getPath();
        this.className = this.className.substring(this.className.lastIndexOf(47) + 1);
        this.className = this.className.substring(0, this.className.indexOf(".tag"));
        this.className = NameMangler.mangleClassName(this.className);
        File generatedSourceDir = new File(options.getOutputDir().getPath() + File.separator + tagFilePath);
        String convertedName = generatedSourceDir.getPath() + File.separator + this.className;
        this.generatedSourceFile = new File(convertedName + ".java");
        this.classFile = new File(convertedName + ".class");
        if (this.hasContainer) {
            this.webinfClassRelativeUrl = "/WEB-INF/classes/" + tagFilePath;
        } else {
            String webinfClassFilePath = context.getRealPath("/WEB-INF/classes") + File.separator + tagFilePath;
            this.webinfClassFile = new File(webinfClassFilePath + File.separator + this.className + ".class");
        }
        this.keepgenerated = options.isKeepGenerated();
        this.keepGeneratedclassfiles = options.isKeepGeneratedclassfiles();
        this.sourceFileTimestamp = this.hasContainer ? inputSource.getLastModified() : this.sourceFile.lastModified();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isOutdated() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isOutdated", new Object[0]);
        }
        if (this.hasContainer) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){
                    static final long serialVersionUID = 1719398240971414712L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() {
                        if (!TagFileResourcesImpl.this.generatedSourceFile.getParentFile().exists()) {
                            boolean rc = TagFileResourcesImpl.this.generatedSourceFile.getParentFile().mkdirs();
                            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                                logger.logp(Level.FINEST, TagFileResourcesImpl.CLASS_NAME, "isOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + TagFileResourcesImpl.this.generatedSourceFile.getParentFile() + "]");
                            }
                        }
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.resource.TagFileResourcesImpl$1", 1.class, null, null);
                    }
                });
            } else if (!this.generatedSourceFile.getParentFile().exists()) {
                boolean rc = this.generatedSourceFile.getParentFile().mkdirs();
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "isOutdated", (rc ? "Created" : "Unable to create") + " directory for generated source file [" + this.generatedSourceFile.getParentFile() + "]");
                }
            }
            Entry webinfClassEntry = this.container.getEntry(this.webinfClassRelativeUrl);
            boolean bl = ResourceUtil.isTagFileOutdated(this.sourceFileTimestamp, this.generatedSourceFile, this.classFile, webinfClassEntry, this.webinfClassFile);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isOutdated", bl);
            }
            return bl;
        }
        boolean bl = ResourceUtil.isTagFileOutdated(this.sourceFile, this.generatedSourceFile, this.classFile, this.webinfClassFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isOutdated", bl);
        }
        return bl;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void syncGeneratedSource() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncGeneratedSource", new Object[0]);
        }
        long sourceFileLastModified = 0L;
        sourceFileLastModified = this.hasContainer ? this.inputSource.getLastModified() : this.sourceFile.lastModified();
        ResourceUtil.syncGeneratedSource(sourceFileLastModified, this.generatedSourceFile);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncGeneratedSource");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void sync() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "sync", new Object[0]);
        }
        long sourceFileLastModified = 0L;
        sourceFileLastModified = this.hasContainer ? this.inputSource.getLastModified() : this.sourceFile.lastModified();
        ResourceUtil.syncTagFile(sourceFileLastModified, this.generatedSourceFile, this.classFile, this.keepgenerated, this.keepGeneratedclassfiles);
        this.sourceFileTimestamp = sourceFileLastModified;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "sync");
        }
    }
}

