/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPPtoPOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueueControllable;
import com.ibm.ws.sib.processor.runtime.SIMPXmitPoint;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamSetControl;
import com.ibm.ws.sib.processor.runtime.impl.XmitPoint;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;

public class XmitPointControl
extends AbstractControlAdapter
implements SIMPXmitPoint {
    private XmitPoint xmitQueue;
    private SIBUuid8 remoteME;
    private PtoPXmitMsgsItemStream itemStream;
    private SIMPMessageHandlerControllable messageHandlerControllable;
    private String messageHandlerName;
    private String id;
    private static final TraceComponent tc = SibTr.register(XmitPointControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public XmitPointControl(XmitPoint xmitQueue, PtoPXmitMsgsItemStream itemStream, DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"XmitPointControl", (Object)new Object[]{xmitQueue, itemStream, destinationHandler});
        }
        this.itemStream = itemStream;
        this.messageHandlerControllable = (SIMPMessageHandlerControllable)destinationHandler.getControlAdapter();
        this.messageHandlerName = this.messageHandlerControllable.getName();
        this.remoteME = itemStream.getLocalizingMEUuid();
        this.xmitQueue = xmitQueue;
        xmitQueue.setXmitQueuePointControl(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"XmitPointControl", (Object)this);
        }
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        return this.messageHandlerControllable;
    }

    public SIMPPtoPOutboundTransmitControllable getPtoPOutboundTransmit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPtoPOutboundTransmit");
        }
        PtoPOutputHandler outputHandler = (PtoPOutputHandler)this.itemStream.getOutputHandler();
        SourceStreamManager sourceStreamManager = outputHandler.getSourceStreamManager();
        SourceStreamSetControl control = sourceStreamManager.getStreamSetRuntimeControl();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPtoPOutboundTransmit");
        }
        return control;
    }

    public String getId() {
        try {
            if (this.id == null) {
                this.id = "" + this.itemStream.getID();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.XmitPointControl.getId", (String)"1:136:1.17", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        return this.id;
    }

    public String getName() {
        return this.messageHandlerName;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"XmitPointControl.assertValidControllable", "1:167:1.17", this.id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.itemStream = null;
        if (this.xmitQueue != null) {
            this.xmitQueue.dereferenceXmitQueuePointControl();
            this.xmitQueue = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public synchronized void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.messageHandlerControllable.isTemporary()) {
            this.xmitQueue.registerControlAdapterAsMBean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        this.dereferenceControllable();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public String getUuid() {
        return null;
    }

    @Override
    public String getConfigId() {
        return null;
    }

    @Override
    public String getRemoteEngineUuid() {
        return this.remoteME.toString();
    }

    public SIMPQueueControllable getQueue() {
        return null;
    }

    public SIBUuid12 getUUID() {
        return null;
    }

    public boolean isSendAllowed() {
        return false;
    }

    public void setSendAllowed(boolean arg) {
    }

    public long getDestinationHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long destHighMsgs = this.itemStream.getDestHighMsgs();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(destHighMsgs));
        }
        return destHighMsgs;
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (!this.messageHandlerControllable.isTemporary()) {
            this.xmitQueue.runtimeEventOccurred(event);
        }
    }
}

