/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.servlet.session.IBMApplicationSession;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionContextRegistry;
import com.ibm.ws.session.SessionCrossoverStackTrace;
import com.ibm.ws.session.http.AbstractHttpSession;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.servlet.session.IBMSessionExt;
import com.ibm.wsspi.session.ISession;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractSessionData
extends AbstractHttpSession
implements IBMSessionExt {
    protected LinkedList lockList;
    protected HashMap locks = null;
    protected String pathInfoForAppSession = null;
    String sipCookieInfo = null;
    protected SessionContext _sessCtx;
    protected String appName;
    private boolean affinityEstablished = false;
    protected IBMApplicationSession mIBMApplicationSession = null;
    protected static final WebSphereRuntimePermission invalidateAllPerm = new WebSphereRuntimePermission("accessInvalidateAll");
    private static final String methodClassName = "AbstractSessionData";
    private static final int PUT_SESSION_VALUE = 0;
    private static final int GET_SESSION_VALUE = 1;
    private static final int REMOVE_SESSION_VALUE = 2;
    private static final int SET_IBM_APPLICATION_SESSION = 3;
    private static final String[] methodNames = new String[]{"putSessionValue", "getSessionValue", "removeSessionValue", "setIBMApplicationSession"};

    protected AbstractSessionData(ISession session) {
        super(session);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "AbstractSessionData Constructor (ISession)");
        }
    }

    protected AbstractSessionData(ISession session, SessionContext sessCtx, ServletContext servCtx) {
        super(session);
        this._sessCtx = sessCtx;
        this.appName = this._sessCtx.getAppName();
        this.setServletContext(servCtx);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.log(Level.FINE, "AbstractSessionData Constructor (ISession, SessionContext, ServletContext)");
        }
    }

    @Override
    public void invalidateAll(boolean remote) throws SecurityException {
        SecurityManager sm;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINER)) {
            String logString = "(" + remote + ") for app " + this.appName + " id " + this.getId();
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "invalidateAll", logString);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission((Permission)invalidateAllPerm);
        }
        SessionContextRegistry.getInstance().invalidateAll(this.getId(), this._sessCtx.getAppName(), this, remote, false);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "invalidateAll");
        }
    }

    @Override
    public void invalidateAll() throws SecurityException {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "invalidateAll", "will default to invalidateAll(false)");
        }
        this.invalidateAll(false);
    }

    @Override
    public String getUserName() {
        return this.getISession().getUserName();
    }

    public void setUser(String value) {
        this.getISession().setUserName(value);
    }

    @Override
    public void sync() {
        this.getISession().flush();
    }

    @Override
    public Object getAttribute(String pName) {
        this.crossoverCheck("getAttribute");
        return this.getSessionValue(pName);
    }

    @Override
    public void setAttribute(String pName, Object pValue) {
        this.crossoverCheck("setAttribute");
        if (pName != null && pValue == null) {
            this.removeAttribute(pName);
        } else {
            this.putSessionValue(pName, pValue);
        }
    }

    @Override
    public void removeAttribute(String pName) {
        this.crossoverCheck("removeAttribute");
        this.removeSessionValue(pName);
    }

    @Override
    public void invalidate() {
        this.crossoverCheck("invalidate");
        super.invalidate();
    }

    protected void putSessionValue(String pName, Object value) {
        if (pName == null) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[0], "SessionData.putValErr1");
            return;
        }
        if (value == null) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.SEVERE, methodClassName, methodNames[0], "SessionData.putValErr2", pName);
            return;
        }
        super.setAttribute(pName, value);
    }

    protected Object getSessionValue(String pName) {
        return super.getAttribute(pName);
    }

    protected void removeSessionValue(String pName) {
        super.removeAttribute(pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getLockList() {
        if (this.lockList == null) {
            AbstractSessionData abstractSessionData = this;
            synchronized (abstractSessionData) {
                this.lockList = new LinkedList();
            }
        }
        return this.lockList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionLock(Object tid, Object lock) {
        AbstractSessionData abstractSessionData = this;
        synchronized (abstractSessionData) {
            if (this.locks == null) {
                this.locks = new HashMap(5);
            }
            this.locks.put(tid, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionLock(Object tid) {
        if (this.locks == null) {
            return null;
        }
        AbstractSessionData abstractSessionData = this;
        synchronized (abstractSessionData) {
            return this.locks.remove(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessionLocks() {
        if (this.locks != null) {
            AbstractSessionData abstractSessionData = this;
            synchronized (abstractSessionData) {
                this.locks.clear();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.getISession().writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.getISession().readExternal(in);
    }

    public void setIBMApplicationSession(IBMApplicationSession appSession) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[3], "for app " + this.appName + " IBMApplicationSession " + appSession);
        }
        this.mIBMApplicationSession = appSession;
    }

    @Override
    public IBMApplicationSession getIBMApplicationSession() {
        return this.getIBMApplicationSession(true);
    }

    @Override
    public IBMApplicationSession getIBMApplicationSession(boolean create) {
        return null;
    }

    public IBMApplicationSession getIBMApplicationSession(boolean create, String logicalServerName) {
        return null;
    }

    public SessionContext getSessCtx() {
        return this._sessCtx;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfoForAppSession = pathInfo;
    }

    public void setSIPCookieInfo(HttpServletRequest _request) {
        String sipLogicalServerName = null;
        byte[] byteSipLogicalServerName = null;
        if (byteSipLogicalServerName != null) {
            sipLogicalServerName = new String(byteSipLogicalServerName);
        }
        if (sipLogicalServerName != null && sipLogicalServerName.length() > 0) {
            this.sipCookieInfo = sipLogicalServerName;
        }
    }

    protected void crossoverCheck(String method) {
        if (this._sessCtx._smc.isDebugSessionCrossover() && this._sessCtx.crossoverCheck(this)) {
            Object[] parms = new Object[]{this.appName, this.getId(), method, this._sessCtx.getCurrentSessionId()};
            LoggingUtil.logParamsAndException(LoggingUtil.SESSION_LOGGER_CORE, Level.SEVERE, methodClassName, "crossoverCheck", "SessionContext.CrossoverOnReference", parms, new SessionCrossoverStackTrace());
        }
    }

    public void setAffinityEstablished(boolean val) {
        this.affinityEstablished = val;
    }

    public boolean isAffinityEstablished() {
        return this.affinityEstablished;
    }

    @Override
    public boolean isOverflow() {
        return this.getISession().isOverflow();
    }
}

