/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.eclipse.persistence.internal.databaseaccess.DatabaseJsonPlatform;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.spi.JsonPlatformProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class JsonPlatformManager {
    private final Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> platforms;

    public static JsonPlatformManager getInstance() {
        return new JsonPlatformManager();
    }

    private static Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> initDirectMap() {
        HashMap<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> fallbackMap = new HashMap<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>>();
        JsonPlatformManager.addProvider(fallbackMap, "org.eclipse.persistence.pgsql.PostgreSQLJsonPlatformProvider");
        JsonPlatformManager.addProvider(fallbackMap, "org.eclipse.persistence.platform.database.oracle.json.OracleJsonPlatformProvider");
        JsonPlatformManager.addProvider(fallbackMap, "org.eclipse.persistence.json.DefaultJsonPlatformProvider");
        return fallbackMap;
    }

    private static void addProvider(Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> fallbackMap, String className) {
        Class<JsonPlatformProvider> providerClass = JsonPlatformManager.getProvider(className);
        if (providerClass != null) {
            try {
                JsonPlatformProvider provider = providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> platformsMap = provider.platforms();
                if (platformsMap != null) {
                    fallbackMap.putAll(platformsMap);
                }
            }
            catch (ReflectiveOperationException ex) {
                AbstractSessionLog.getLog().log(3, String.format("Invocation of static platform method on class %s failed: %s", className, ex.getMessage()));
            }
        }
    }

    private static Class<JsonPlatformProvider> getProvider(String className) {
        try {
            Class<JsonPlatformProvider> candidate = Class.forName(className);
            if (JsonPlatformProvider.class.isAssignableFrom(candidate)) {
                return candidate;
            }
            AbstractSessionLog.getLog().log(3, String.format("JsonPlatformProvider candidate class %s does not implement JsonPlatformProvider", className));
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            AbstractSessionLog.getLog().log(3, String.format("JsonPlatformProvider class %s was not found", className));
        }
        return null;
    }

    private JsonPlatformManager() {
        Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> converters = JsonPlatformManager.initDirectMap();
        ServiceLoader<JsonPlatformProvider> providers = ServiceLoader.load(JsonPlatformProvider.class);
        for (JsonPlatformProvider provider : providers) {
            Map<Class<? extends DatabasePlatform>, Supplier<DatabaseJsonPlatform>> providerConverters = provider.platforms();
            for (Class<? extends DatabasePlatform> type : providerConverters.keySet()) {
                if (converters.containsKey(type)) continue;
                converters.put(type, providerConverters.get(type));
            }
        }
        this.platforms = Collections.unmodifiableMap(converters);
    }

    public DatabaseJsonPlatform createPlatform(Class<? extends DatabasePlatform> type) {
        Supplier<DatabaseJsonPlatform> supplier = this.platforms.get(type);
        if (supplier != null) {
            return supplier.get();
        }
        supplier = this.platforms.get(DatabasePlatform.class);
        return supplier != null ? supplier.get() : new DatabaseJsonPlatform(){};
    }
}

