/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.TimerNpImpl;
import com.ibm.ejs.container.passivator.PassivatorSerializableHandle;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejb.portable.Constants;
import jakarta.ejb.Timer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class TimerNpHandleImpl
implements Serializable,
PassivatorSerializableHandle {
    private static final TraceComponent tc = Tr.register(TimerNpHandleImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final long serialVersionUID = 1137182555465371492L;
    private static final byte[] EYECATCHER = Constants.TIMER_HANDLE_EYE_CATCHER;
    private static final short PLATFORM = 1;
    private static final short VERSION_ID = 1;
    private transient String ivTaskId;
    private transient BeanId ivBeanId;

    TimerNpHandleImpl(BeanId beanId, String taskId) {
        this.ivBeanId = beanId;
        this.ivTaskId = taskId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.toString(), (Object[])new Object[0]);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("writeObject: " + this), (Object[])new Object[0]);
        }
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeUTF(this.ivTaskId);
        out.writeObject(this.ivBeanId.getByteArrayBytes());
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeObject");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readObject", (Object[])new Object[0]);
        }
        in.defaultReadObject();
        byte[] eyeCatcher = new byte[EYECATCHER.length];
        int bytesRead = 0;
        for (int offset = 0; offset < EYECATCHER.length; offset += bytesRead) {
            bytesRead = in.read(eyeCatcher, offset, EYECATCHER.length - offset);
            if (bytesRead != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (int i = 0; i < EYECATCHER.length; ++i) {
            if (EYECATCHER[i] == eyeCatcher[i]) continue;
            String eyeCatcherString = new String(eyeCatcher);
            throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in TimerHandle input stream");
        }
        short incoming_platform = in.readShort();
        short incoming_vid = in.readShort();
        if (incoming_vid != 1) {
            throw new InvalidObjectException("EJB TimerHandle data stream is not of the correct version, this client should be updated.");
        }
        this.ivTaskId = in.readUTF();
        byte[] bytes = (byte[])in.readObject();
        ByteArray byteArray = new ByteArray(bytes);
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        this.ivBeanId = BeanId.getBeanId(byteArray, container2);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("readObject: " + this));
        }
    }

    @Override
    public Object getSerializedObject() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSerializedObject : " + this.ivBeanId + ", " + this.ivTaskId), (Object[])new Object[0]);
        }
        Timer timer = TimerNpImpl.getDeserializedTimer(this.ivBeanId, this.ivTaskId);
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSerializedObject : " + timer));
        }
        return timer;
    }
}

