/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.repository.download;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.EventManager;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepositoryDownloadUtil {
    private static Logger logger = InstallLogUtils.getInstallLogger();

    public static String getProductVersion(RepositoryResource installResource) {
        String resourceVersion = null;
        try {
            ArrayList<ProductInfoProductDefinition> pdList = new ArrayList<ProductInfoProductDefinition>();
            for (ProductInfo pi : ProductInfo.getAllProductInfo().values()) {
                pdList.add(new ProductInfoProductDefinition(pi));
            }
            resourceVersion = installResource.getAppliesToVersions(pdList);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, e.getMessage(), e);
        }
        if (resourceVersion == null) {
            resourceVersion = "noversion";
        }
        return resourceVersion;
    }

    public static boolean isPublicAsset(ResourceType resourceType, RepositoryResource installResource) {
        EsaResource esar;
        return resourceType.equals((Object)ResourceType.FEATURE) || resourceType.equals((Object)ResourceType.ADDON) ? (esar = (EsaResource)installResource).getVisibility().equals((Object)Visibility.PUBLIC) || esar.getVisibility().equals((Object)Visibility.INSTALL) : resourceType.equals((Object)ResourceType.PRODUCTSAMPLE) || resourceType.equals((Object)ResourceType.OPENSOURCE);
    }

    private static boolean isAddon(ResourceType resourceType, RepositoryResource installResource) {
        EsaResource esar;
        return !(!resourceType.equals((Object)ResourceType.FEATURE) && !resourceType.equals((Object)ResourceType.ADDON) || !(esar = (EsaResource)installResource).getVisibility().equals((Object)Visibility.PUBLIC) && !esar.getVisibility().equals((Object)Visibility.INSTALL) || !esar.getVisibility().equals((Object)Visibility.INSTALL));
    }

    public static String getAssetNameFromMassiveResource(RepositoryResource mr) {
        SampleResource sr;
        String assetName = "";
        ResourceType resourceType = mr.getType();
        if (RepositoryDownloadUtil.isAddon(resourceType, mr)) {
            resourceType = ResourceType.ADDON;
        }
        assetName = resourceType.equals((Object)ResourceType.FEATURE) || resourceType.equals((Object)ResourceType.ADDON) ? (((EsaResource)mr).getShortName() == null ? ((EsaResource)mr).getProvideFeature() : ((EsaResource)mr).getShortName()) : ((sr = (SampleResource)mr).getShortName() == null ? sr.getName() : sr.getShortName());
        return assetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResourcesToDiskRepo(Map<String, Collection<String>> downloaded, File toDir, RepositoryResource installResource, EventManager eventManager, int progress) throws RepositoryBackendException, RepositoryResourceException, IOException, InstallException {
        ResourceType resourceType = installResource.getType();
        if (RepositoryDownloadUtil.isAddon(resourceType, installResource)) {
            resourceType = ResourceType.ADDON;
        }
        if (resourceType.equals((Object)ResourceType.FEATURE) || resourceType.equals((Object)ResourceType.ADDON) || resourceType.equals((Object)ResourceType.PRODUCTSAMPLE) || resourceType.equals((Object)ResourceType.OPENSOURCE)) {
            StringBuffer relativeUrl = new StringBuffer();
            String assetName = RepositoryDownloadUtil.getAssetNameFromMassiveResource(installResource);
            String resourceTypeString = resourceType.getURLForType();
            String resourceVersion = RepositoryDownloadUtil.getProductVersion(installResource);
            relativeUrl.append(resourceTypeString);
            relativeUrl.append(File.separator);
            relativeUrl.append(resourceVersion);
            relativeUrl.append(File.separator);
            String mainAttachmentName = null;
            File contentDir = new File(toDir, relativeUrl.toString());
            contentDir.mkdirs();
            for (AttachmentResource ar : installResource.getAttachments()) {
                if (ar.getType() != AttachmentType.CONTENT) continue;
                mainAttachmentName = new File(ar.getName()).getName();
                break;
            }
            for (AttachmentResource ar : installResource.getAttachments()) {
                File resourceFile = null;
                switch (ar.getType()) {
                    case CONTENT: {
                        resourceFile = new File(contentDir, mainAttachmentName);
                        if (!RepositoryDownloadUtil.isPublicAsset(resourceType, installResource)) break;
                        try {
                            eventManager.fireProgressEvent(32, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING", assetName));
                        }
                        catch (Exception e) {
                            logger.log(Level.FINEST, "writeResourcesToDiskRepo: failed to fire event", e);
                        }
                        break;
                    }
                    default: {
                        resourceFile = null;
                    }
                }
                if (resourceFile == null) continue;
                if (resourceFile.exists()) {
                    resourceFile.delete();
                }
                if (resourceFile.exists()) continue;
                String url = ar.getURL();
                logger.log(Level.FINEST, "Downloading " + ar.getName() + " from " + (url.contains("public.dhe.ibm.com") ? "the IBM WebSphere Liberty Repository" : url + " of the repository " + installResource.getRepositoryConnection().getRepositoryLocation()) + " to " + contentDir.getAbsolutePath());
                InstallUtils.InputStreamFileWriter isfw = new InstallUtils.InputStreamFileWriter(ar.getInputStream());
                isfw.writeToFile(resourceFile);
                logger.log(Level.FINEST, "Downloaded " + ar.getName() + " from " + (url.contains("public.dhe.ibm.com") ? "the IBM WebSphere Liberty Repository" : url + " of the repository " + installResource.getRepositoryConnection().getRepositoryLocation()) + " to " + contentDir.getAbsolutePath());
                InstallUtils.validateDownloaded(resourceFile, installResource);
                if (ar.getType() != AttachmentType.CONTENT || !RepositoryDownloadUtil.isPublicAsset(resourceType, installResource)) continue;
                if (!downloaded.containsKey(resourceTypeString)) {
                    ArrayList<String> typeResourcesList = new ArrayList<String>();
                    typeResourcesList.add(assetName);
                    downloaded.put(resourceTypeString, typeResourcesList);
                    continue;
                }
                downloaded.get(resourceTypeString).add(assetName);
            }
            File json = new File(contentDir, mainAttachmentName + ".json");
            try (FileOutputStream os = new FileOutputStream(json);){
                installResource.writeDiskRepoJSONToStream((OutputStream)os);
            }
            logger.log(Level.FINEST, "Downloaded " + mainAttachmentName + " to " + contentDir.getAbsolutePath());
        }
    }

    public static Map<String, Collection<String>> writeResourcesToDiskRepo(Map<String, Collection<String>> downloaded, File toDir, Map<String, List<List<RepositoryResource>>> installResources, String productVersion, EventManager eventManager, boolean defaultRepo) throws InstallException {
        int progress = 10;
        int interval1 = installResources.size() == 0 ? 90 : 90 / installResources.size();
        for (List<List<RepositoryResource>> targetList : installResources.values()) {
            for (List<RepositoryResource> mrList : targetList) {
                int interval2 = mrList.size() == 0 ? interval1 : interval1 / mrList.size();
                for (RepositoryResource installResource : mrList) {
                    try {
                        RepositoryDownloadUtil.writeResourcesToDiskRepo(downloaded, toDir, installResource, eventManager, progress += interval2);
                    }
                    catch (InstallException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw ExceptionUtils.createFailedToDownload(installResource, e, toDir);
                    }
                }
            }
        }
        return downloaded;
    }
}

