/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class PriorityQueue {
    private static final int DEFAULT_START_SIZE = 16;
    protected int size;
    protected PriorityQueueNode[] elements;
    private static final TraceComponent tc = SibTr.register(PriorityQueue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public PriorityQueue() {
        this(16);
    }

    public PriorityQueue(int startSize) {
        this.elements = startSize != 0 ? new PriorityQueueNode[startSize] : null;
        this.size = 0;
    }

    protected final int parent(int i) {
        return (i - 1) / 2;
    }

    protected final int left(int i) {
        return i * 2 + 1;
    }

    protected final int right(int i) {
        return i * 2 + 2;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final void put(long priority, Object value) {
        PriorityQueueNode node = new PriorityQueueNode(priority, value);
        if (this.size == this.elements.length) {
            PriorityQueueNode[] tmp = new PriorityQueueNode[2 * this.size];
            System.arraycopy(this.elements, 0, tmp, 0, this.size);
            this.elements = tmp;
        }
        int pos = this.size++;
        this.setElement(node, pos);
        this.moveUp(pos);
    }

    protected void moveUp(int pos) {
        PriorityQueueNode node = this.elements[pos];
        long priority = node.priority;
        while (pos > 0 && this.elements[this.parent((int)pos)].priority > priority) {
            this.setElement(this.elements[this.parent(pos)], pos);
            pos = this.parent(pos);
        }
        this.setElement(node, pos);
    }

    public final Object getMin() throws NoSuchElementException {
        PriorityQueueNode max = null;
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        max = this.elements[0];
        this.setElement(this.elements[--this.size], 0);
        this.heapify(0);
        return max.value;
    }

    protected final void setElement(PriorityQueueNode node, int pos) {
        this.elements[pos] = node;
        node.pos = pos;
    }

    protected void heapify(int position) {
        int i = -1;
        int smallest = position;
        while (smallest != i) {
            i = smallest;
            int l = this.left(i);
            int r = this.right(i);
            smallest = l < this.size && this.elements[l].priority < this.elements[i].priority ? l : i;
            if (r < this.size && this.elements[r].priority < this.elements[smallest].priority) {
                smallest = r;
            }
            if (smallest == i) continue;
            PriorityQueueNode tmp = this.elements[smallest];
            this.setElement(this.elements[i], smallest);
            this.setElement(tmp, i);
        }
    }

    protected PriorityQueueNode minNode() throws NoSuchElementException {
        if (this.size > 0) {
            return this.elements[0];
        }
        throw new NoSuchElementException();
    }

    public Object minElement() throws NoSuchElementException {
        return this.minNode().value;
    }

    public long minPriority() throws NoSuchElementException {
        return this.minNode().priority;
    }

    class PriorityQueueNode {
        public long priority;
        public int pos;
        public Object value;

        public PriorityQueueNode(long p, Object v) {
            this.priority = p;
            this.value = v;
        }
    }
}

