/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.behavior;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.component.behavior.Behavior;
import org.apache.myfaces.cdi.behavior.FacesBehaviorAnnotationLiteral;
import org.apache.myfaces.cdi.behavior.FacesBehaviorInfo;
import org.apache.myfaces.cdi.util.AbstractDynamicProducer;
import org.apache.myfaces.shared.util.ClassUtils;

@Typed
public class FacesBehaviorProducer
extends AbstractDynamicProducer<Behavior> {
    public FacesBehaviorProducer(BeanManager beanManager, FacesBehaviorInfo typeInfo) {
        super(beanManager);
        FacesBehaviorAnnotationLiteral literal = new FacesBehaviorAnnotationLiteral(typeInfo.getBehaviorId() == null ? "" : typeInfo.getBehaviorId(), true);
        String behaviorId = typeInfo.getBehaviorId() == null ? "" : typeInfo.getBehaviorId();
        String id = "" + typeInfo.getType() + "_" + behaviorId;
        super.id(id).scope(Dependent.class).qualifiers(new Annotation[]{literal}).types(new Type[]{typeInfo.getType(), Object.class}).beanClass(ClassUtils.simpleClassForName(typeInfo.getType().getTypeName())).create((CreationalContext<T> e) -> this.createBehavior((CreationalContext<Behavior>)e));
    }

    protected Behavior createBehavior(CreationalContext<Behavior> cc) {
        Class<?> behaviorClass = this.getBeanClass();
        Behavior converter = null;
        try {
            converter = (Behavior)behaviorClass.newInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(FacesBehaviorProducer.class.getName()).log(Level.SEVERE, "Could not instantiate behavior " + behaviorClass.getName(), ex);
            throw new FacesException("Could not instantiate behavior: " + behaviorClass.getName(), (Throwable)ex);
        }
        return converter;
    }
}

