/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.base;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIMessages;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlMessages;
import jakarta.faces.component.search.SearchExpressionContext;
import jakarta.faces.component.search.SearchExpressionHandler;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.component.search.MyFacesSearchExpressionHints;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.renderkit.html.base.HtmlMessageRendererBase;
import org.apache.myfaces.renderkit.html.util.HTML;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;

public abstract class HtmlMessagesRendererBase
extends HtmlMessageRendererBase {
    private static final Logger log = Logger.getLogger(HtmlMessagesRendererBase.class.getName());
    protected static final String LAYOUT_LIST = "list";
    protected static final String LAYOUT_TABLE = "table";

    protected void renderMessages(FacesContext facesContext, UIComponent messages) throws IOException {
        this.renderMessages(facesContext, messages, false);
    }

    protected void renderMessages(FacesContext facesContext, UIComponent messages, boolean alwaysRenderSpan) throws IOException {
        this.renderMessages(facesContext, messages, alwaysRenderSpan, false);
    }

    protected void renderMessages(FacesContext facesContext, UIComponent messages, boolean alwaysRenderSpan, boolean renderDivWhenNoMessagesAndIdSet) throws IOException {
        Object forceSpan;
        boolean b;
        SearchExpressionHandler searchExpressionHandler;
        String forAttr = this.getFor(messages);
        String clientId = null;
        if (forAttr != null && !forAttr.isEmpty() && (clientId = (searchExpressionHandler = facesContext.getApplication().getSearchExpressionHandler()).resolveClientId(SearchExpressionContext.createSearchExpressionContext((FacesContext)facesContext, (UIComponent)messages, (Set)MyFacesSearchExpressionHints.SET_IGNORE_NO_RESULT, null), forAttr)) == null) {
            log.severe("Could not render Message. Unable to find component '" + forAttr + "' (calling findComponent on component '" + clientId + "'). If the provided id was correct, wrap the message and its component into an h:panelGroup or h:panelGrid.");
            return;
        }
        MessagesIterator messagesIterator = new MessagesIterator(facesContext, this.isGlobalOnly(messages), this.isRedisplay(messages), clientId);
        if (messagesIterator.hasNext()) {
            String layout = this.getLayout(messages);
            if (layout == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("No messages layout given, using default layout 'list'.");
                }
                this.renderList(facesContext, messages, messagesIterator);
            } else if (layout.equalsIgnoreCase(LAYOUT_TABLE)) {
                this.renderTable(facesContext, messages, messagesIterator);
            } else {
                if (log.isLoggable(Level.WARNING) && !layout.equalsIgnoreCase(LAYOUT_LIST)) {
                    log.warning("Unsupported messages layout '" + layout + "' - using default layout 'list'. Component: " + ComponentUtils.getPathToComponent(messages));
                }
                this.renderList(facesContext, messages, messagesIterator);
            }
        } else if (renderDivWhenNoMessagesAndIdSet && this.shouldRenderId(facesContext, messages)) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("div", messages);
            writer.writeAttribute("id", (Object)messages.getClientId(facesContext), null);
            writer.endElement("div");
        }
        if (!renderDivWhenNoMessagesAndIdSet && alwaysRenderSpan && (b = ((forceSpan = messages.getAttributes().get("forceSpan")) instanceof Boolean ? (Boolean)forceSpan : Boolean.valueOf(forceSpan.toString())).booleanValue())) {
            ResponseWriter writer = facesContext.getResponseWriter();
            writer.startElement("span", null);
            writer.writeAttribute("id", (Object)messages.getClientId(facesContext), null);
            if (messages.getAttributes().get("styleClass") != null) {
                writer.writeAttribute("class", messages.getAttributes().get("styleClass"), null);
            }
            if (messages.getAttributes().get("style") != null) {
                writer.writeAttribute("style", messages.getAttributes().get("style"), null);
            }
            writer.endElement("span");
        }
    }

    private void renderList(FacesContext facesContext, UIComponent messages, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("ul", messages);
        Map behaviors = null;
        if (messages instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)messages).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", (Object)messages.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, messages, facesContext);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, messages, HTML.UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE);
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)this.getComponentStyle(messages));
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)this.getComponentStyleClass(messages));
        while (messagesIterator.hasNext()) {
            writer.startElement("li", null);
            FacesMessage facesMessage = (FacesMessage)messagesIterator.next();
            String[] styleAndClass = HtmlMessagesRendererBase.getStyleAndStyleClass(messages, facesMessage.getSeverity());
            String style = styleAndClass[0];
            String styleClass = styleAndClass[1];
            HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
            HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
            this.renderSingleFacesMessage(facesContext, messages, facesMessage, messagesIterator.getClientId(), false, false, false);
            writer.endElement("li");
        }
        writer.endElement("ul");
    }

    private void renderTable(FacesContext facesContext, UIComponent messages, MessagesIterator messagesIterator) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement(LAYOUT_TABLE, messages);
        Map behaviors = null;
        if (messages instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)messages).getClientBehaviors();
        }
        if (behaviors != null && !behaviors.isEmpty()) {
            writer.writeAttribute("id", (Object)messages.getClientId(facesContext), null);
        } else {
            HtmlRendererUtils.writeIdIfNecessary(writer, messages, facesContext);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, messages, HTML.UNIVERSAL_ATTRIBUTES_WITHOUT_STYLE);
        HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)this.getComponentStyle(messages));
        HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)this.getComponentStyleClass(messages));
        while (messagesIterator.hasNext()) {
            writer.startElement("tr", null);
            writer.startElement("td", null);
            FacesMessage facesMessage = (FacesMessage)messagesIterator.next();
            String[] styleAndClass = HtmlMessagesRendererBase.getStyleAndStyleClass(messages, facesMessage.getSeverity());
            String style = styleAndClass[0];
            String styleClass = styleAndClass[1];
            HtmlRendererUtils.renderHTMLAttribute(writer, "style", "style", (Object)style);
            HtmlRendererUtils.renderHTMLAttribute(writer, "styleClass", "styleClass", (Object)styleClass);
            this.renderSingleFacesMessage(facesContext, messages, facesMessage, messagesIterator.getClientId(), false, false, false);
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement(LAYOUT_TABLE);
    }

    public static String[] getStyleAndStyleClass(UIComponent messages, FacesMessage.Severity severity) {
        String style = null;
        String styleClass = null;
        if (messages instanceof HtmlMessages) {
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = ((HtmlMessages)messages).getInfoStyle();
                styleClass = ((HtmlMessages)messages).getInfoClass();
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = ((HtmlMessages)messages).getWarnStyle();
                styleClass = ((HtmlMessages)messages).getWarnClass();
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = ((HtmlMessages)messages).getErrorStyle();
                styleClass = ((HtmlMessages)messages).getErrorClass();
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = ((HtmlMessages)messages).getFatalStyle();
                styleClass = ((HtmlMessages)messages).getFatalClass();
            }
        } else {
            Map attr = messages.getAttributes();
            if (severity == FacesMessage.SEVERITY_INFO) {
                style = (String)attr.get("infoStyle");
                styleClass = (String)attr.get("infoClass");
            } else if (severity == FacesMessage.SEVERITY_WARN) {
                style = (String)attr.get("warnStyle");
                styleClass = (String)attr.get("warnClass");
            } else if (severity == FacesMessage.SEVERITY_ERROR) {
                style = (String)attr.get("errorStyle");
                styleClass = (String)attr.get("errorClass");
            } else if (severity == FacesMessage.SEVERITY_FATAL) {
                style = (String)attr.get("fatalStyle");
                styleClass = (String)attr.get("fatalClass");
            }
        }
        return new String[]{style, styleClass};
    }

    protected String getComponentStyleClass(UIComponent messages) {
        String styleClass = null;
        styleClass = messages instanceof HtmlMessages ? ((HtmlMessages)messages).getStyleClass() : (String)messages.getAttributes().get("styleClass");
        return styleClass;
    }

    protected String getComponentStyle(UIComponent messages) {
        String style = null;
        style = messages instanceof HtmlMessages ? ((HtmlMessages)messages).getStyle() : (String)messages.getAttributes().get("style");
        return style;
    }

    @Override
    protected String getTitle(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).getTitle();
        }
        return (String)component.getAttributes().get("title");
    }

    @Override
    protected boolean isTooltip(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).isTooltip();
        }
        return AttributeUtils.getBooleanAttribute(component, "tooltip", false);
    }

    @Override
    protected boolean isShowSummary(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isShowSummary();
        }
        return AttributeUtils.getBooleanAttribute(component, "showSummary", false);
    }

    @Override
    protected boolean isShowDetail(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isShowDetail();
        }
        return AttributeUtils.getBooleanAttribute(component, "showDetail", false);
    }

    protected boolean isGlobalOnly(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isGlobalOnly();
        }
        return AttributeUtils.getBooleanAttribute(component, "globalOnly", false);
    }

    protected String getLayout(UIComponent component) {
        if (component instanceof HtmlMessages) {
            return ((HtmlMessages)component).getLayout();
        }
        return (String)component.getAttributes().get("layout");
    }

    @Override
    protected String getFor(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).getFor();
        }
        return (String)component.getAttributes().get("for");
    }

    @Override
    protected boolean isRedisplay(UIComponent component) {
        if (component instanceof UIMessages) {
            return ((UIMessages)component).isRedisplay();
        }
        return AttributeUtils.getBooleanAttribute(component, "redisplay", true);
    }

    private static class MessagesIterator
    implements Iterator {
        private FacesContext _facesContext;
        private Iterator _globalMessagesIterator;
        private Iterator _clientIdsWithMessagesIterator;
        private Iterator _componentMessagesIterator = null;
        private String _clientId = null;
        private boolean _redisplay;
        private Object _next;

        public MessagesIterator(FacesContext facesContext, boolean globalOnly, boolean redisplay, String clientId) {
            this._facesContext = facesContext;
            if (clientId != null) {
                this._clientId = clientId;
                this._componentMessagesIterator = facesContext.getMessages(this._clientId);
                this._globalMessagesIterator = Collections.emptyIterator();
                this._clientIdsWithMessagesIterator = Collections.emptyIterator();
            } else {
                if (globalOnly) {
                    this._globalMessagesIterator = facesContext.getMessages(null);
                    this._clientIdsWithMessagesIterator = Collections.emptyIterator();
                } else {
                    this._globalMessagesIterator = Collections.emptyIterator();
                    this._clientIdsWithMessagesIterator = facesContext.getClientIdsWithMessages();
                }
                this._componentMessagesIterator = null;
                this._clientId = null;
            }
            this._redisplay = redisplay;
            this._next = null;
        }

        @Override
        public boolean hasNext() {
            if (this._next != null) {
                return true;
            }
            if (this._globalMessagesIterator.hasNext()) {
                do {
                    this._next = this._globalMessagesIterator.next();
                    if (!this._redisplay && ((FacesMessage)this._next).isRendered()) continue;
                    return true;
                } while (this._globalMessagesIterator.hasNext());
            }
            if (this._componentMessagesIterator != null && this._componentMessagesIterator.hasNext()) {
                do {
                    this._next = this._componentMessagesIterator.next();
                    if (!this._redisplay && ((FacesMessage)this._next).isRendered()) continue;
                    return true;
                } while (this._componentMessagesIterator.hasNext());
            }
            if (this._clientIdsWithMessagesIterator.hasNext()) {
                do {
                    this._clientId = (String)this._clientIdsWithMessagesIterator.next();
                    this._componentMessagesIterator = this._facesContext.getMessages(this._clientId);
                    while (this._componentMessagesIterator.hasNext()) {
                        this._next = this._componentMessagesIterator.next();
                        if (!this._redisplay && ((FacesMessage)this._next).isRendered()) continue;
                        return true;
                    }
                } while (this._clientIdsWithMessagesIterator.hasNext());
            }
            this._next = null;
            return false;
        }

        public Object next() {
            if (this.hasNext()) {
                Object ret = this._next;
                this._next = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public String getClientId() {
            return this._clientId;
        }
    }
}

