/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.CommonAbstractCriteriaImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.FromImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;

public abstract class AbstractQueryImpl<T>
extends CommonAbstractCriteriaImpl<T>
implements AbstractQuery<T> {
    private static final long serialVersionUID = -5270020290752637882L;
    protected ResultType queryResult;
    protected boolean distinct;
    protected Predicate havingClause;
    protected List<jakarta.persistence.criteria.Expression<?>> groupBy;
    protected Set<Root<?>> roots;
    protected Expression baseExpression;

    public AbstractQueryImpl(Metamodel metamodel, ResultType queryResult, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        super(metamodel, queryBuilder, resultType);
        this.roots = new HashSet();
        this.queryResult = queryResult;
        this.baseExpression = new ExpressionBuilder();
    }

    AbstractQueryImpl(Metamodel metamodel, jakarta.persistence.criteria.Expression<Boolean> where, CriteriaBuilderImpl queryBuilder, Class<T> queryType, Set<ParameterExpression<?>> parameters, ResultType queryResult, boolean distinct, Predicate havingClause, List<jakarta.persistence.criteria.Expression<?>> groupBy, Set<Root<?>> roots, Expression baseExpression) {
        super(metamodel, where, queryBuilder, queryType, parameters);
        this.queryResult = queryResult;
        this.distinct = distinct;
        this.havingClause = havingClause;
        this.groupBy = groupBy;
        this.roots = roots;
        this.baseExpression = baseExpression;
    }

    public AbstractQuery<T> groupBy(List<jakarta.persistence.criteria.Expression<?>> grouping) {
        this.groupBy = grouping;
        return this;
    }

    public AbstractQuery<T> groupBy(jakarta.persistence.criteria.Expression<?> ... grouping) {
        this.groupBy = new ArrayList();
        Collections.addAll(this.groupBy, grouping);
        return this;
    }

    public AbstractQuery<T> having(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        Objects.requireNonNull(restriction, "Restriction expression is null");
        this.findRootAndParameters(restriction);
        this.havingClause = ((InternalExpression)restriction).isCompoundExpression() || ((InternalExpression)restriction).isPredicate() ? (Predicate)restriction : this.queryBuilder.isTrue(restriction);
        return this;
    }

    public AbstractQuery<T> having(Predicate ... restrictions) {
        return this.having(restrictions != null ? List.of(restrictions) : null);
    }

    public AbstractQuery<T> having(List<Predicate> restrictions) {
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.findRootAndParameters((jakarta.persistence.criteria.Expression<?>)predicate);
        this.havingClause = predicate;
        return this;
    }

    public abstract void addJoin(FromImpl<?, ?> var1);

    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    @Override
    protected Expression getBaseExpression() {
        return this.getBaseExpression(null);
    }

    protected Expression getBaseExpression(Root<?> root) {
        if (this.roots.isEmpty()) {
            this.baseExpression = new ExpressionBuilder();
        } else if (this.roots.size() == 1) {
            this.baseExpression = ((RootImpl)this.roots.iterator().next()).getCurrentNode();
        } else if (root != null) {
            for (Root<?> r : this.roots) {
                if (r != root) continue;
                this.baseExpression = ((RootImpl)r).getCurrentNode();
            }
        }
        return this.baseExpression;
    }

    public List<jakarta.persistence.criteria.Expression<?>> getGroupList() {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList();
        }
        return this.groupBy;
    }

    public Predicate getGroupRestriction() {
        return this.havingClause;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    @Override
    protected void integrateRoot(RootImpl<?> root) {
        this.roots.add(root);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    protected void findJoins(FromImpl<?, ?> root) {
        root.findJoins(this);
    }

    public <X> Root<X> from(EntityType<X> entity) {
        return this.internalFrom(entity);
    }

    public <X> Root<X> from(Class<X> entityClass) {
        return this.internalFrom(entityClass);
    }

    public AbstractQuery<T> where(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        return (AbstractQuery)super.where(restriction);
    }

    public AbstractQuery<T> where(Predicate ... restrictions) {
        return (AbstractQuery)super.where(restrictions);
    }

    public AbstractQuery<T> where(List<Predicate> restrictions) {
        return (AbstractQuery)super.where(restrictions);
    }

    protected static enum ResultType {
        UNKNOWN,
        OBJECT_ARRAY,
        PARTIAL,
        TUPLE,
        ENTITY,
        CONSTRUCTOR,
        OTHER;

    }
}

