/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.internal.OtlpDeclarativeConfigUtil;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    @Override
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    @Override
    public String getName() {
        return "otlp";
    }

    @Override
    public SpanExporter create(DeclarativeConfigProperties config) {
        String protocol = OtlpDeclarativeConfigUtil.getStructuredConfigOtlpProtocol(config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpDeclarativeConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

