/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.AOStream;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.AOValue;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerTransmitControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AOStreamIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;

public class RemoteConsumerTransmit
extends AbstractControlAdapter
implements SIMPRemoteConsumerTransmitControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(RemoteConsumerTransmit.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AOStream _aoStream;
    private MessageProcessor _messageProcessor;
    private AnycastOutputHandler _aoh;

    public RemoteConsumerTransmit(AOStream aoStream, AnycastOutputHandler aoh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerTransmit", (Object)new Object[]{aoStream, aoh});
        }
        this._aoStream = aoStream;
        this._messageProcessor = aoh.getMessageProcessor();
        this._aoh = aoh;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerTransmit");
        }
    }

    public SIMPIterator getTransmitMessageRequestIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageRequestIterator");
        }
        AOStreamIterator aoStreamIterator = new AOStreamIterator(this._aoStream, this._messageProcessor, this._aoh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageRequestIterator", (Object)aoStreamIterator);
        }
        return aoStreamIterator;
    }

    public boolean containsGuesses() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsGuesses");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsGuesses", (Object)Boolean.FALSE);
        }
        return false;
    }

    public int getCurrentMaxIndoubtMessages(int priority, int COS) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCurrentMaxIndoubtMessages", (Object)new Object[]{new Integer(priority), new Integer(COS)});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCurrentMaxIndoubtMessages");
        }
        return 0;
    }

    public void forceFlushAtSource() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtSource");
        }
        this._aoh.forceFlushAtSource(this._aoStream.getRemoteMEUuid(), this._aoStream.getGatheringTargetDestUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtSource");
        }
    }

    public void clearMessagesAtSource(IndoubtAction indoubtAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessagesAtSource", (Object)indoubtAction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
    }

    public DeliveryStreamType getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)DeliveryStreamType.ANYCAST_SOURCE);
        }
        return DeliveryStreamType.ANYCAST_SOURCE;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)this._aoStream.getID());
        }
        return this._aoStream.getID();
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", null);
        }
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._aoStream == null || this._aoStream.itemStream == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteConsumerTransmit.assertValidControllable", "1:252:1.44", this._aoStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfQueuedMessages() {
        int count = 0;
        NonLockingCursor cursor = null;
        try {
            cursor = this._aoStream.itemStream.newNonLockingItemCursor(null);
            cursor.allowUnavailableItems();
            AOValue item = (AOValue)cursor.next();
            while (item != null) {
                ++count;
                item = (AOValue)cursor.next();
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit.getNumberOfQueuedMessages", (String)"1:340:1.44", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit.getNumberOfQueuedMessages", "1:344:1.44", SIMPUtils.getStackTrace(e)});
            count = -1;
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfQueuedMessages", (Object)new Integer(count));
        }
        return count;
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String ID) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{ID});
        }
        long messageID = -1L;
        try {
            messageID = Long.parseLong(ID);
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit.getQueuedMessageByID", (String)"1:379:1.44", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)e);
            }
            throw new SIMPInvalidRuntimeIDException((Throwable)e);
        }
        SIMPMessage message = null;
        try {
            message = (SIMPMessage)this._aoStream.itemStream.findById(messageID);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit.getQueuedMessageByID", (String)"1:398:1.44", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)((Object)e));
            }
            throw new SIMPRuntimeOperationFailedException((Throwable)e);
        }
        if (message == null) {
            SIMPControllableNotFoundException e = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteConsumerTransmit.assertValidControllable", "1:413:1.44", this._aoStream}, null));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)message.getControlAdapter();
    }

    public SIMPIterator getQueuedMessageIterator() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> messages = new ArrayList<ControlAdapter>();
        NonLockingCursor cursor = null;
        try {
            cursor = this._aoStream.itemStream.newNonLockingItemCursor(null);
            cursor.allowUnavailableItems();
            AOValue item = (AOValue)cursor.next();
            while (item != null) {
                try {
                    ControlAdapter cAdapter = item.getControlAdapter();
                    if (cAdapter != null) {
                        messages.add(cAdapter);
                    }
                    item = (AOValue)cursor.next();
                }
                catch (NotInMessageStore ef) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)ef));
                }
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerTransmit.getQueuedMessageIterator", (String)"1:467:1.44", (Object)this);
            SIMPRuntimeOperationFailedException e1 = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerTransmit.getQueuedMessageIterator", "1:475:1.44", e, this._aoStream.streamId}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e1));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator", (Object)((Object)e1));
            }
            throw e1;
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(messages.iterator());
    }

    public long getNumberOfCompletedRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfCompletedRequests");
        }
        long completedRequests = this.getNumberOfRequestsReceived() - this.getNumberOfCurrentRequests();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfCompletedRequests", (Object)new Long(completedRequests));
        }
        return completedRequests;
    }

    public long getNumberOfRequestsReceived() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfRequestsReceived");
        }
        long returnValue = this._aoStream.getTotalRequestsReceived();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfRequestsReceived", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    public long getNumberOfCurrentRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfCurrentRequests");
        }
        long returnValue = this._aoStream.getNumberOfRequestsInState(1);
        returnValue += this._aoStream.getNumberOfRequestsInState(3);
        returnValue += this._aoStream.getNumberOfRequestsInState(6);
        returnValue += this._aoStream.getNumberOfRequestsInState(5);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfCurrentRequests", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    public SIBUuid12 getStreamID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        SIBUuid12 id = this._aoStream.streamId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)id);
        }
        return id;
    }

    public SIMPDeliveryTransmitControllable.StreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        AOStream.AOStreamState returnValue = this._aoStream.getStreamState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String returnString = this._aoStream.getRemoteMEUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)returnString);
        }
        return returnString;
    }

    public HealthState getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)2);
        }
        return new HealthStateTree();
    }

    public String getDestinationUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationUuid");
        }
        SIBUuid12 destUuid = this._aoStream.getGatheringTargetDestUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationUuid", (Object)destUuid);
        }
        return String.valueOf(destUuid);
    }

    public boolean isGathering() {
        boolean isGathering;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGathering");
        }
        boolean bl = isGathering = this._aoStream.getGatheringTargetDestUuid() != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGathering", (Object)isGathering);
        }
        return isGathering;
    }
}

