/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.monitor;

import com.ibm.websphere.monitor.jmx.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.http.monitor.HttpStatAttributes;
import io.openliberty.http.monitor.mbean.HttpServerStatsMXBean;
import java.time.Duration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HttpServerStats
extends Meter
implements HttpServerStatsMXBean {
    private final StatisticsMeter responseTime = new StatisticsMeter();
    private String requestMethod;
    private String httpRoute;
    private int responseStatus;
    private String errorType = null;
    private String scheme;
    private String serverName;
    private String networkProtocolName;
    private String networkProtocolVersion;
    private int serverPort;
    static final long serialVersionUID = 3164644571896643658L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public HttpServerStats() {
        this.responseTime.setDescription("Cumulative Response Time (NanoSeconds) for a HTTP connection");
        this.responseTime.setUnit("ns");
    }

    public HttpServerStats(HttpStatAttributes httpStatAttributes) {
        this.responseTime.setDescription("Cumulative Response Time (NanoSeconds) for a HTTP connection");
        this.responseTime.setUnit("ns");
        this.requestMethod = httpStatAttributes.getRequestMethod();
        this.httpRoute = httpStatAttributes.getHttpRoute();
        if (this.httpRoute == null) {
            this.httpRoute = "";
        }
        this.responseStatus = httpStatAttributes.getResponseStatus();
        this.scheme = httpStatAttributes.getScheme();
        this.networkProtocolName = httpStatAttributes.getNetworkProtocolName();
        this.networkProtocolVersion = httpStatAttributes.getNetworkProtocolVersion();
        this.serverName = httpStatAttributes.getServerName();
        this.serverPort = httpStatAttributes.getServerPort();
        this.errorType = httpStatAttributes.getErrorType();
        if (this.errorType == null) {
            this.errorType = "";
        }
    }

    public void updateDuration(long durationNanos) {
        this.responseTime.addDataPoint(durationNanos);
    }

    public void updateDuration(Duration duration) {
        this.responseTime.addDataPoint(duration.toNanos());
    }

    @Override
    public double getDuration() {
        return this.responseTime.getTotal();
    }

    @Override
    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Override
    public int getResponseStatus() {
        return this.responseStatus;
    }

    @Override
    public String getHttpRoute() {
        return this.httpRoute;
    }

    @Override
    public long getCount() {
        return this.responseTime.getCount();
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getNetworkProtocolName() {
        return this.networkProtocolName;
    }

    @Override
    public String getNetworkProtocolVersion() {
        return this.networkProtocolVersion;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public String getErrorType() {
        return this.errorType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.monitor.HttpServerStats", HttpServerStats.class, null, null);
    }
}

