/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.resources.IfixResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Resolver {
    private Collection<IfixResource> ifixResources;

    public Resolver(RepositoryConnectionList loginInfo) {
        try {
            this.ifixResources = loginInfo.getAllIfixes();
        }
        catch (RepositoryException e) {
            this.ifixResources = new ArrayList<IfixResource>(0);
        }
    }

    public List<IfixResource> resolveFixResources(Collection<String> fixes) {
        ArrayList<IfixResource> installAssets = new ArrayList<IfixResource>();
        for (String fix : fixes) {
            for (IfixResource ifixResource : this.ifixResources) {
                if (!ifixResource.getName().equalsIgnoreCase(fix) || installAssets.contains(ifixResource)) continue;
                installAssets.add(ifixResource);
            }
        }
        return installAssets;
    }
}

