/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationIndex;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class LinkIndex
extends AbstractDestinationIndex {
    private static final TraceComponent tc = SibTr.register(LinkIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap<String, Index.Entry> nameIndex;
    private HashMap<SIBUuid8, Index.Entry> mqLinkIndex;

    public LinkIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkIndex");
        }
        this.nameIndex = new HashMap(10);
        this.mqLinkIndex = new HashMap(10);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkIndex", (Object)this);
        }
    }

    @Override
    public synchronized Index.Entry put(DestinationHandler destinationHandler, AbstractDestinationIndex.AbstractDestinationType type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{destinationHandler, type});
        }
        Index.Entry entry = super.put(destinationHandler, type);
        this.nameIndex.put(destinationHandler.getName(), entry);
        Type linkType = (Type)type;
        if (linkType.mqLink.booleanValue()) {
            MQLinkHandler mqLink = (MQLinkHandler)destinationHandler;
            this.mqLinkIndex.put(mqLink.getMqLinkUuid(), entry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized DestinationHandler findByName(String name, IndexFilter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByName", (Object)new Object[]{name, filter});
        }
        DestinationHandler destinationHandler = null;
        Index.Entry entry = this.nameIndex.get(name);
        if (entry != null && (filter == null || filter.matches(entry.type))) {
            destinationHandler = (DestinationHandler)entry.data;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByName", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public synchronized DestinationHandler findByMQLinkUuid(SIBUuid8 uuid, IndexFilter filter) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByMQLinkUuid", (Object)new Object[]{uuid, filter});
        }
        DestinationHandler destinationHandler = null;
        Index.Entry entry = this.mqLinkIndex.get(uuid);
        if (entry != null && (filter == null || filter.matches(entry.type))) {
            destinationHandler = (DestinationHandler)entry.data;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByMQLinkUuid", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    @Override
    public synchronized void remove(DestinationHandler destinationHandler) {
        AbstractDestinationIndex.DestinationEntry destEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{destinationHandler});
        }
        super.remove(destinationHandler);
        if (destinationHandler.isMQLink()) {
            this.removeFromMQLinkIndex(destinationHandler);
        }
        if ((destEntry = (AbstractDestinationIndex.DestinationEntry)this.nameIndex.get(destinationHandler.getName())) != null && destEntry.data == destinationHandler) {
            this.nameIndex.remove(destinationHandler.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    @Override
    public synchronized void remove(Index.Entry entry) {
        AbstractDestinationIndex.DestinationEntry destEntry;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        super.remove(entry);
        DestinationHandler dh = (DestinationHandler)entry.data;
        if (dh.isMQLink()) {
            this.removeFromMQLinkIndex(dh);
        }
        if ((destEntry = (AbstractDestinationIndex.DestinationEntry)this.nameIndex.get(dh.getName())) == entry) {
            this.nameIndex.remove(dh.getName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    private void removeFromMQLinkIndex(DestinationHandler dh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeFromMQLinkIndex", (Object)dh);
        }
        MQLinkHandler mqLink = (MQLinkHandler)dh;
        this.mqLinkIndex.remove(mqLink.getMqLinkUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeFromMQLinkIndex");
        }
    }

    public synchronized void setLocalizationFlags(DestinationHandler destinationHandler, boolean local, boolean remote) {
        Type type = (Type)this.getType(destinationHandler);
        type.local = local;
        type.remote = remote;
        this.setType(destinationHandler, (Index.Type)type);
    }

    public static class Type
    extends AbstractDestinationIndex.AbstractDestinationType {
        public Boolean local = null;
        public Boolean mqLink = null;
        public Boolean remote = null;
    }
}

