/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MessageContextProxyClassLoader
extends ClassLoader {
    private ClassLoader applicationClassLoader;
    private ClassLoader bundleClassLoader;
    private final Class<?>[] classes;
    private boolean checkSystem;
    static final long serialVersionUID = -2245164571240917997L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MessageContextProxyClassLoader(ClassLoader parent, ClassLoader applicationClassLoader, ClassLoader bundleClassLoader) {
        super(parent);
        this.applicationClassLoader = applicationClassLoader;
        this.bundleClassLoader = bundleClassLoader;
        this.classes = null;
    }

    public MessageContextProxyClassLoader(ClassLoader parent, Class<?>[] cls) {
        super(parent);
        this.classes = cls;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.classes != null) {
            for (Class<?> c : this.classes) {
                if (!name.equals(c.getName())) continue;
                return c;
            }
        }
        ClassLoader[] loaders = new ClassLoader[2];
        if (name.equals("org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy")) {
            loaders[0] = this.bundleClassLoader;
            loaders[1] = this.applicationClassLoader;
        } else {
            loaders[0] = this.applicationClassLoader;
            loaders[1] = this.bundleClassLoader;
        }
        for (ClassLoader loader : loaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader", (String)"54", (Object)this, (Object[])new Object[]{name});
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader", (String)"56", (Object)this, (Object[])new Object[]{name});
            }
        }
        if (this.checkSystem) {
            try {
                return MessageContextProxyClassLoader.getSystemClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, (String)"org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader", (String)"63", (Object)this, (Object[])new Object[]{name});
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader", (String)"65", (Object)this, (Object[])new Object[]{name});
            }
        }
        throw new ClassNotFoundException(name);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxrs.utils.MessageContextProxyClassLoader", MessageContextProxyClassLoader.class, null, null);
    }
}

