/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.api.jms.ApiJmsConstants;
import com.ibm.websphere.sib.api.jms.JmsConnectionFactory;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsManagedConnectionFactoryImpl;
import com.ibm.ws.sib.api.jmsra.JmsJcaConnectionFactory;
import com.ibm.ws.sib.api.jmsra.JmsJcaManagedConnectionFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JmsConnectionFactoryImpl
extends JmsManagedConnectionFactoryImpl
implements JmsConnectionFactory {
    private static final long serialVersionUID = -869905873329896171L;
    private static TraceComponent tc = SibTr.register(JmsConnectionFactoryImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    JmsJcaManagedConnectionFactory jcaManagedConnectionFactory = null;

    JmsConnectionFactoryImpl(JmsJcaConnectionFactory jcaConnectionFactory, JmsJcaManagedConnectionFactory jcaManagedConnectionFactory) {
        super(jcaConnectionFactory);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsConnectionFactoryImpl", (Object)new Object[]{jcaConnectionFactory, jcaManagedConnectionFactory});
        }
        this.jcaManagedConnectionFactory = jcaManagedConnectionFactory;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsConnectionFactoryImpl");
        }
    }

    @Override
    public void setBusName(String busName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBusName", (Object)busName);
        }
        if (busName == null) {
            throw (InvalidDestinationException)JmsErrorUtils.newThrowable(InvalidDestinationException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"busName", null}, tc);
        }
        this.jcaManagedConnectionFactory.setBusName(busName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBusName");
        }
    }

    @Override
    public void setClientID(String clientID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setClientID", (Object)clientID);
        }
        if ("".equals(clientID)) {
            clientID = null;
        }
        this.jcaManagedConnectionFactory.setClientID(clientID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setClientID");
        }
    }

    @Override
    public void setNonPersistentMapping(String nonPersistentMapping) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setNonPersistentMapping", (Object)nonPersistentMapping);
        }
        if (nonPersistentMapping == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"nonPersistentMapping", null}, tc);
        }
        if (nonPersistentMapping.equals(ApiJmsConstants.MAPPING_BEST_EFFORT_NONPERSISTENT) || nonPersistentMapping.equals(ApiJmsConstants.MAPPING_EXPRESS_NONPERSISTENT) || nonPersistentMapping.equals(ApiJmsConstants.MAPPING_RELIABLE_NONPERSISTENT) || nonPersistentMapping.equals(ApiJmsConstants.MAPPING_RELIABLE_PERSISTENT) || nonPersistentMapping.equals(ApiJmsConstants.MAPPING_ASSURED_PERSISTENT) || nonPersistentMapping.equals(ApiJmsConstants.MAPPING_NONE)) {
            this.jcaManagedConnectionFactory.setNonPersistentMapping(nonPersistentMapping);
        } else if (nonPersistentMapping.equals("AsSIBDestination")) {
            this.jcaManagedConnectionFactory.setNonPersistentMapping(ApiJmsConstants.MAPPING_NONE);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"nonPersistentMapping", nonPersistentMapping}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setNonPersistentMapping");
        }
    }

    @Override
    public void setPersistentMapping(String persistentMapping) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPersistentMapping", (Object)persistentMapping);
        }
        if (persistentMapping == null) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"persistentMapping", null}, tc);
        }
        if (persistentMapping.equals(ApiJmsConstants.MAPPING_BEST_EFFORT_NONPERSISTENT) || persistentMapping.equals(ApiJmsConstants.MAPPING_EXPRESS_NONPERSISTENT) || persistentMapping.equals(ApiJmsConstants.MAPPING_RELIABLE_NONPERSISTENT) || persistentMapping.equals(ApiJmsConstants.MAPPING_RELIABLE_PERSISTENT) || persistentMapping.equals(ApiJmsConstants.MAPPING_ASSURED_PERSISTENT) || persistentMapping.equals(ApiJmsConstants.MAPPING_NONE)) {
            this.jcaManagedConnectionFactory.setPersistentMapping(persistentMapping);
        } else if (persistentMapping.equals("AsSIBDestination")) {
            this.jcaManagedConnectionFactory.setPersistentMapping(ApiJmsConstants.MAPPING_NONE);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"persistentMapping", persistentMapping}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPersistentMapping");
        }
    }

    @Override
    public void setPassword(String password) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setPassword", (Object)(password == null ? "null" : "non-null"));
        }
        this.jcaManagedConnectionFactory.setPassword(password);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setPassword");
        }
    }

    @Override
    public void setUserName(String userName) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setUserName", (Object)userName);
        }
        this.jcaManagedConnectionFactory.setUserName(userName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setUserName");
        }
    }

    @Override
    public void setReadAhead(String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReadAhead", (Object)value);
        }
        if (value == null || !"Default".equals(value) && !"AlwaysOn".equals(value) && !"AlwaysOff".equals(value)) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"readAhead", value}, tc);
        }
        this.jcaManagedConnectionFactory.setReadAhead(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReadAhead");
        }
    }

    @Override
    public void setDurableSubscriptionHome(String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDurableSubscriptionHome", (Object)value);
        }
        this.jcaManagedConnectionFactory.setDurableSubscriptionHome(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDurableSubscriptionHome");
        }
    }

    public Reference getReference() throws NamingException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getReference");
        }
        Reference reference = this.jcaConnectionFactory.getReference();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getReference", (Object)reference);
        }
        return reference;
    }

    public void setReference(Reference reference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setReference", (Object)reference);
        }
        this.jcaConnectionFactory.setReference(reference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setReference");
        }
    }

    @Override
    public void setConnectionProximity(String newConnectionProximity) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConnectionProximity", (Object)newConnectionProximity);
        }
        if (newConnectionProximity == null || "".equals(newConnectionProximity)) {
            this.jcaManagedConnectionFactory.setConnectionProximity("Bus");
        } else if ("Bus".equals(newConnectionProximity) || "Host".equals(newConnectionProximity) || "Cluster".equals(newConnectionProximity) || "Server".equals(newConnectionProximity)) {
            this.jcaManagedConnectionFactory.setConnectionProximity(newConnectionProximity);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"connectionProximity", newConnectionProximity}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConnectionProximity");
        }
    }

    @Override
    public void setProviderEndpoints(String newProviderEndpoints) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProviderEndpoints", (Object)newProviderEndpoints);
        }
        this.jcaManagedConnectionFactory.setRemoteServerAddress(newProviderEndpoints);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProviderEndpoints");
        }
    }

    @Override
    public void setTargetTransport(String newTargetTransport) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTargetTransport", (Object)newTargetTransport);
        }
        this.jcaManagedConnectionFactory.setTargetTransport(newTargetTransport);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTargetTransport");
        }
    }

    @Override
    public void setTargetTransportChain(String newTargetTransportChain) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTargetTransportChain", (Object)newTargetTransportChain);
        }
        this.jcaManagedConnectionFactory.setTargetTransportChain(newTargetTransportChain);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTargetTransportChain");
        }
    }

    @Override
    public void setTarget(String newTargetGroup) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTarget", (Object)newTargetGroup);
        }
        this.jcaManagedConnectionFactory.setTarget(newTargetGroup);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTarget");
        }
    }

    @Override
    public void setTargetType(String newTargetType) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTargetType", (Object)newTargetType);
        }
        if (newTargetType == null || "".equals(newTargetType)) {
            this.jcaManagedConnectionFactory.setTargetType("BusMember");
        } else if ("BusMember".equals(newTargetType) || "Custom".equals(newTargetType) || "ME".equals(newTargetType)) {
            this.jcaManagedConnectionFactory.setTargetType(newTargetType);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"remoteTargetType", newTargetType}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTargetType");
        }
    }

    @Override
    public void setTemporaryQueueNamePrefix(String prefix) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTemporaryQueueNamePrefix", (Object)prefix);
        }
        if (prefix != null && !prefix.equals("")) {
            this.jcaManagedConnectionFactory.setTemporaryQueueNamePrefix(prefix);
        } else {
            this.jcaManagedConnectionFactory.setTemporaryQueueNamePrefix(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTemporaryQueueNamePrefix");
        }
    }

    @Override
    public void setTemporaryTopicNamePrefix(String prefix) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTemporaryTopicNamePrefix", (Object)prefix);
        }
        if (prefix != null && !prefix.equals("")) {
            this.jcaManagedConnectionFactory.setTemporaryTopicNamePrefix(prefix);
        } else {
            this.jcaManagedConnectionFactory.setTemporaryTopicNamePrefix(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTemporaryTopicNamePrefix");
        }
    }

    @Override
    public void setShareDurableSubscriptions(String sharePolicy) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setShareDurableSubscriptions", (Object)sharePolicy);
        }
        if (sharePolicy == null || "".equals(sharePolicy)) {
            this.jcaManagedConnectionFactory.setShareDurableSubscriptions("NeverShared");
        } else if ("InCluster".equals(sharePolicy) || "AlwaysShared".equals(sharePolicy) || "NeverShared".equals(sharePolicy)) {
            this.jcaManagedConnectionFactory.setShareDurableSubscriptions(sharePolicy);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"shareDurableSubscriptions", sharePolicy}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setShareDurableSubscriptions");
        }
    }

    @Override
    public void setTargetSignificance(String value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTargetSignificance", (Object)value);
        }
        if (!"Preferred".equals(value) && !"Required".equals(value)) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"targetSignificance", value}, tc);
        }
        this.jcaManagedConnectionFactory.setTargetSignificance(value);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTargetSignificance");
        }
    }

    @Override
    public void setMulticastInterface(String mi) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMulticastInterface", (Object)mi);
        }
        this.jcaManagedConnectionFactory.setMulticastInterface(mi);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMulticastInterface");
        }
    }

    @Override
    public void setSubscriptionProtocol(String p) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSubscriptionProtocol", (Object)p);
        }
        if (!("Unicast".equals(p) || "Multicast".equals(p) || "UnicastAndMulticast".equals(p))) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"subscriptionProtocol", p}, tc);
        }
        this.jcaManagedConnectionFactory.setSubscriptionProtocol(p);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSubscriptionProtocol");
        }
    }

    @Override
    public void setProducerDoesNotModifyPayloadAfterSet(String propertyValue) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setProducerDoesNotModifyPayloadAfterSet", (Object)propertyValue);
        }
        if (propertyValue == null || "".equals(propertyValue)) {
            this.jcaManagedConnectionFactory.setProducerDoesNotModifyPayloadAfterSet("false");
        } else if (propertyValue.equalsIgnoreCase("false") || propertyValue.equalsIgnoreCase("true")) {
            this.jcaManagedConnectionFactory.setProducerDoesNotModifyPayloadAfterSet(propertyValue);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"producerDoesNotModifyPayloadAfterSet", propertyValue}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setProducerDoesNotModifyPayloadAfterSet");
        }
    }

    @Override
    public void setConsumerDoesNotModifyPayloadAfterGet(String propertyValue) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConsumerDoesNotModifyPayloadAfterGet", (Object)propertyValue);
        }
        if (propertyValue == null || "".equals(propertyValue)) {
            this.jcaManagedConnectionFactory.setConsumerDoesNotModifyPayloadAfterGet("false");
        } else if (propertyValue.equalsIgnoreCase("false") || propertyValue.equalsIgnoreCase("true")) {
            this.jcaManagedConnectionFactory.setConsumerDoesNotModifyPayloadAfterGet(propertyValue);
        } else {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0261", new Object[]{"consumerDoesNotModifyPayloadAfterGet", propertyValue}, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConsumerDoesNotModifyPayloadAfterGet");
        }
    }
}

