/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.srt;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.request.IRequest;
import com.ibm.websphere.servlet.response.IResponse;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.http.channel.inputstream.HttpInputStreamObserver;
import com.ibm.ws.session.utils.IDGeneratorImpl;
import com.ibm.ws.webcontainer.WebContainer;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.async.AsyncIllegalStateException;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import com.ibm.ws.webcontainer.osgi.collaborator.CollaboratorHelperImpl;
import com.ibm.ws.webcontainer.osgi.request.IRequestImpl;
import com.ibm.ws.webcontainer.servlet.RequestUtils;
import com.ibm.ws.webcontainer.session.SessionManagerConfigBase;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.ws.webcontainer.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.srt.SRTInputStream;
import com.ibm.ws.webcontainer.srt.SRTRequestContext;
import com.ibm.ws.webcontainer.srt.SRTServletRequestPart;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer.util.EmptyEnumeration;
import com.ibm.ws.webcontainer.util.UnsynchronizedStack;
import com.ibm.ws.webcontainer.webapp.WebApp;
import com.ibm.ws.webcontainer.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.ws.webcontainer.webapp.WebGroup;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.webcontainer.IPoolable;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.collaborator.IWebAppSecurityCollaborator;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletRequest;
import com.ibm.wsspi.webcontainer.servlet.ServletRequestExtended;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.IInputStreamObserver;
import com.ibm.wsspi.webcontainer.util.WSServletInputStream;
import com.ibm.wsspi.webcontainer.webapp.IWebAppDispatcherContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.fileupload.FileCountLimitExceededException;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class SRTServletRequest
implements HttpServletRequest,
IExtendedRequest,
IServletRequest,
IPrivateRequestAttributes,
IInputStreamObserver,
ServletRequestExtended,
HttpInputStreamObserver,
ISRTServletRequest {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.srt");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.srt.SRTServletRequest";
    protected static final TraceNLS nls = TraceNLS.getTraceNLS(SRTServletRequest.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    protected static final TraceNLS liberty_nls = TraceNLS.getTraceNLS(SRTServletRequest.class, (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static String CLIENT_ENCODING_OVERRIDE;
    private static String DEFAULT_CLIENT_ENCODING;
    private static String suppressHeadersInRequest;
    private static ArrayList suppressheadersList;
    private static final String JAVAX_NET_SSL_PEER_CERTS = "javax.net.ssl.peer_certificates";
    private static final String JAVAX_NET_SSL_CIPHER_SUITE = "javax.net.ssl.cipher_suite";
    private static final String JAVAX_SERVLET_REQUEST_X509CERTIFICATE = "jakarta.servlet.request.X509Certificate";
    private static final String DIRECT_CONNECTION_PEER_CERTS = "com.ibm.websphere.ssl.direct_connection_peer_certificates";
    private static final String DIRECT_CONNECTION_CIPHER_SUITE = "com.ibm.websphere.ssl.direct_connection_cipher_suite";
    private static final String IS_DIRECT_CONNECTION = "com.ibm.websphere.webcontainer.is_direct_connection";
    protected static final String INPUT_STREAM_CONTENT_TYPE = "ContentType";
    protected static final String INPUT_STREAM_CONTENT_DATA = "ContentData";
    protected static final String INPUT_STREAM_CONTENT_DATA_LENGTH = "ContentDataLength";
    private UnsynchronizedStack _paramStack = new UnsynchronizedStack();
    protected SRTConnectionContext _connContext;
    protected SRTRequestContext _requestContext = null;
    protected WebAppDispatcherContext _dispatchContext = null;
    protected SRTServletRequestHelper _srtRequestHelper;
    protected static final int LENGTH_INT = 4;
    protected static final int LENGTH_LONG = 8;
    protected static final int OFFSET_CONTENT_DATA_LENGTH = 0;
    protected static final int OFFSET_CONTENT_TYPE_LEN = 1;
    protected static final int OFFSET_CONTENT_TYPE_DATA = 2;
    protected static final int OFFSET_CONTENT_DATA = 3;
    protected boolean multiReadPropertyEnabled = false;
    protected boolean httpUpdatedwMultiReadValues = false;
    protected IRequest _request = null;
    protected WSServletInputStream _in;
    private boolean _runningCollaborators = false;
    protected String _setInputStreamContentType;
    protected long _setInputStreamContentLength;
    protected boolean _setInputDataStreamCalled;
    private SRTServletRequestThreadData threadData = null;
    private static final boolean enableSetCharacterEncodingAfterGetReader;
    private static boolean disableSetCharacterEncodingAfterParametersRead;
    private static boolean keySizeFromCipherMap;
    private boolean usedStartAsyncNoParameters = false;
    protected static final boolean SERVLET_PATH_FOR_DEFAULT_MAPPING;
    private static int MAX_PART_HEADER_SIZE;

    public SRTServletRequest(SRTConnectionContext context) {
        this._connContext = context;
        this._requestContext = this.createRequestContext();
        this._in = this.createInputStream();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "SRTServletRequest", "this->" + this + ": inputStream is of type --> " + (Object)((Object)this._in));
        }
        this.initRequestThreadData();
    }

    protected SRTRequestContext createRequestContext() {
        return new SRTRequestContext(this);
    }

    protected void initRequestThreadData() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.init(null);
    }

    protected SRTServletRequest() {
    }

    @Override
    public Object getPrivateAttribute(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPrivateAttribute", "this->" + this + ":  name --> " + name);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return null;
        }
        return this._srtRequestHelper._privateAttributes.get(name);
    }

    protected void checkRequestObjectInUse() {
        WebContainerRequestState reqState = WebContainerRequestState.getInstance(true);
        IExtendedRequest curThreadIExtendedReq = reqState.getCurrentThreadsIExtendedRequest();
        if (curThreadIExtendedReq != null && curThreadIExtendedReq != this) {
            try {
                throw new IllegalStateException("Wrong request object in use on Thread");
            }
            catch (IllegalStateException e) {
                logger.logp(Level.SEVERE, CLASS_NAME, "checkRequestObjectInUse", "ERROR: Wrong request object in use on Thread. Object Expected: " + curThreadIExtendedReq + ",  Found: " + this);
                logger.logp(Level.SEVERE, CLASS_NAME, "checkRequestObjectInUse", "Wrong request object in use on Thread. \n", e);
            }
        }
    }

    @Override
    public Enumeration getPrivateAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPrivateAttributeNames", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            return EmptyEnumeration.instance();
        }
        return this._srtRequestHelper._privateAttributes.keys();
    }

    @Override
    public void setPrivateAttribute(String name, Object value) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setPrivateAttribute", "this->" + this + ":  name --> " + name + " value --> " + value.toString());
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._privateAttributes == null) {
            this._srtRequestHelper._privateAttributes = new Hashtable();
        }
        this._srtRequestHelper._privateAttributes.put(name, value);
    }

    @Override
    public void removePrivateAttribute(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removePrivateAttribute", "this->" + this + ":  name --> " + name);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._privateAttributes != null) {
            this._srtRequestHelper._privateAttributes.remove(name);
        }
    }

    @Override
    public void initForNextRequest(IRequest req) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "initForNextRequest", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        try {
            if (req == null) {
                if (this.multiReadPropertyEnabled) {
                    if (this._in instanceof SRTInputStream) {
                        ((SRTInputStream)this._in).cleanupforMultiRead();
                    }
                    this.multiReadPropertyEnabled = false;
                    this.httpUpdatedwMultiReadValues = false;
                }
                this._in.init(null);
                return;
            }
            this._setInputStreamContentType = null;
            this._setInputStreamContentLength = -1L;
            this._setInputDataStreamCalled = false;
            this._request = req;
            this._srtRequestHelper = this.getRequestHelper();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "initForNextRequest", "this->" + this + " , _srtRequestHelper [" + this._srtRequestHelper + "]");
            }
            this.initRequestThreadData();
            this._in.init(this._request.getInputStream());
            if (this.getContentLength() > 0) {
                this._in.setContentLength(this.getContentLength());
            }
        }
        catch (IOException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.initForNextRequest", "828", this);
        }
    }

    protected SRTServletRequestHelper getRequestHelper() {
        return new SRTServletRequestHelper();
    }

    protected boolean getHelperGotReader() {
        return this._srtRequestHelper._gotReader;
    }

    protected void setHelperParameters(Map newParams) {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.setParameters(newParams);
    }

    public Object getAttribute(String arg0) {
        Object obj;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttribute", "this->" + this + ":  name --> " + arg0);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((obj = this._srtRequestHelper._attributes.get(arg0)) == null && this.getDispatchContext().isSecurityEnabledForApplication()) {
            if (arg0.equalsIgnoreCase(JAVAX_NET_SSL_PEER_CERTS) || arg0.equalsIgnoreCase(JAVAX_SERVLET_REQUEST_X509CERTIFICATE)) {
                obj = this.getPeerCertificates();
            } else if (arg0.equalsIgnoreCase(JAVAX_NET_SSL_CIPHER_SUITE)) {
                obj = this.getCipherSuite();
            } else if (arg0.equalsIgnoreCase(DIRECT_CONNECTION_PEER_CERTS)) {
                obj = this.getDirectConnectionPeerCertificates();
            } else if (arg0.equalsIgnoreCase(DIRECT_CONNECTION_CIPHER_SUITE)) {
                obj = this.getDirectConnectionCipherSuite();
            } else if (arg0.equalsIgnoreCase(IS_DIRECT_CONNECTION)) {
                obj = this.isDirectConnection();
            } else if (arg0.equals("jakarta.servlet.request.ssl_session_id")) {
                obj = this.getSSLSessionId();
            }
        }
        return obj;
    }

    public Enumeration getAttributeNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAttributeNames", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (WCCustomProperties.COPY_ATTRIBUTES_KEY_SET) {
            return new Enumeration(){
                private Iterator iter;
                {
                    this.iter = new ArrayList(SRTServletRequest.this._srtRequestHelper._attributes.keySet()).iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.iter.hasNext();
                }

                public Object nextElement() {
                    return this.iter.next();
                }
            };
        }
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.setCharacterEncoding(arg0, false);
    }

    protected void setCharacterEncoding(String arg0, boolean skipCheckCharsetSupported) throws UnsupportedEncodingException {
        boolean isSupported;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (!enableSetCharacterEncodingAfterGetReader && this._srtRequestHelper._gotReader) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "this->" + this + ":  call ignored, already got reader");
            }
            return;
        }
        if (disableSetCharacterEncodingAfterParametersRead && this._srtRequestHelper._parametersRead) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "this->" + this + ":  name --> " + arg0 + " is ignored, already parsed data");
            }
            return;
        }
        boolean bl = isSupported = skipCheckCharsetSupported ? skipCheckCharsetSupported : EncodingUtils.isCharsetSupported(arg0);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setCharacterEncoding", "this->" + this + ":  name --> " + arg0 + " isSupported --> " + String.valueOf(isSupported));
        }
        if (!isSupported) {
            String msg = nls.getFormattedMessage("unsupported.request.encoding.[{0}]", new Object[]{arg0}, "Unsupported encoding specified --> " + arg0);
            throw new UnsupportedEncodingException(msg);
        }
        this._srtRequestHelper._characterEncoding = arg0;
    }

    private boolean isHeaderinSuppressedHeadersList(String headername) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean suppressHeader = false;
        if (headername != null) {
            Iterator itList = suppressheadersList.iterator();
            while (itList.hasNext() && !suppressHeader) {
                String s = (String)itList.next();
                if (!headername.startsWith(s)) continue;
                suppressHeader = true;
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "isHeaderinSuppressedHeadersList", " suppressHeadersInRequest is set and headername --> " + headername + " begins with --> " + s);
            }
        }
        return suppressHeader;
    }

    public long getDateHeader(String name) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        long header = -1L;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getDateHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDateHeader", "this->" + this + ":  name --> " + name + " header --> " + String.valueOf(header));
        }
        return header;
    }

    public String getHeader(String name) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String header = null;
        if (!(suppressHeadersInRequest != null && this.isHeaderinSuppressedHeadersList(name) || this._request == null)) {
            header = this._request.getHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", "this->" + this + ":  name --> " + name + " header --> " + PasswordNullifier.nullifyParams((String)header));
        }
        return header;
    }

    @Override
    public String getHeader(HttpHeaderKeys headerKey) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String header = null;
        String name = headerKey.getName();
        if (!(suppressHeadersInRequest != null && this.isHeaderinSuppressedHeadersList(name) || this._request == null)) {
            String string = header = this._request instanceof IRequestImpl ? ((IRequestImpl)this._request).getHeader(headerKey) : this._request.getHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeader", "this->" + this + ":  headerKey --> " + name + " header --> " + PasswordNullifier.nullifyParams((String)header));
        }
        return header;
    }

    public String getHeaderDirect(String name) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String header = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderDirect", "this->" + this + ":  name --> " + name + " header --> " + header);
        }
        return header;
    }

    public Enumeration getHeaderNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaderNames", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (suppressHeadersInRequest == null) {
            return this._request.getHeaderNames();
        }
        ArrayList<String> alHeaderNames = new ArrayList<String>();
        Enumeration enumHeaderNames = this._request.getHeaderNames();
        while (enumHeaderNames.hasMoreElements()) {
            String headerNameParam = (String)enumHeaderNames.nextElement();
            if (this.isHeaderinSuppressedHeadersList(headerNameParam)) continue;
            alHeaderNames.add(headerNameParam);
        }
        return Collections.enumeration(alHeaderNames);
    }

    public int getIntHeader(String name) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        int header = -1;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getIntHeader(name);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIntHeader", "this->" + this + ":  name --> " + name + " header --> " + String.valueOf(header));
        }
        return header;
    }

    public Enumeration getHeaders(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getHeaders", "this->" + this + ":  name --> " + name);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        Enumeration header = null;
        if (suppressHeadersInRequest == null || !this.isHeaderinSuppressedHeadersList(name)) {
            header = this._request.getHeaders(name);
        }
        return header;
    }

    public String getMethod() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._method == null) {
            this._srtRequestHelper._method = this._request.getMethod();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getMethod", "this->" + this + ":  method --> " + this._srtRequestHelper._method);
        }
        return this._srtRequestHelper._method;
    }

    public int getContentLength() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        int contentLength = !this._setInputDataStreamCalled ? this._request.getContentLength() : (int)this._setInputStreamContentLength;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentLength", "this->" + this + ":  length --> " + String.valueOf(contentLength));
        }
        return contentLength;
    }

    public String getContentType() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String contentType = !this._setInputDataStreamCalled ? this._request.getContentType() : this._setInputStreamContentType;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContentType", "this->" + this + ":  type --> " + contentType);
        }
        return contentType;
    }

    public String getProtocol() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String protocol = this._request.getProtocol();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getProtocol", "this->" + this + ":  protocol --> " + protocol);
        }
        return protocol;
    }

    public String getScheme() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String scheme = this._request.getScheme();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getScheme", "this->" + this + ":  scheme --> " + scheme);
        }
        return scheme;
    }

    public int getServerPort() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        int port = this._request.getServerPort();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServerPort", "this->" + this + ":  port --> " + String.valueOf(port));
        }
        return port;
    }

    public String getRemoteAddr() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._request != null) {
            String addr = this._request.getRemoteAddr();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRemoteAddr", "this->" + this + ":  address --> " + addr);
            }
            return addr;
        }
        return null;
    }

    public String getRemoteHost() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String host = null;
        if (this._request != null) {
            host = this._request.getRemoteHost();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemoteHost", "this->" + this + ":  host --> " + host);
        }
        return host;
    }

    public void setAttribute(String arg0, Object arg1) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setAttribute", "this->" + this + ":  name --> [" + arg0 + "],  value --> [" + arg1 + "]");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (WCCustomProperties.REMOVE_ATTRIBUTE_FOR_NULL_OBJECT && arg1 == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setAttribute", "cannot set attribute with null value, remove the attribute -->" + arg0);
            }
            this.removeAttribute(arg0);
        } else {
            Object oldValue = this._srtRequestHelper._attributes.put(arg0, arg1);
            if (oldValue != null) {
                this.attributeReplaced(arg0, oldValue);
            } else {
                this.attributeAdded(arg0, arg1);
            }
        }
    }

    public void removeAttribute(String arg0) {
        Object oldValue;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeAttribute", "this->" + this + ":  name --> " + arg0);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((oldValue = this._srtRequestHelper._attributes.remove(arg0)) != null) {
            this.attributeRemoved(arg0, oldValue);
        }
    }

    public Locale getLocale() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.processLocales();
        Locale locale = this._srtRequestHelper._locales.size() > 0 ? this._srtRequestHelper._locales.get(0) : null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocale", "this->" + this + ":  locale --> " + (locale != null ? locale.toString() : ""));
        }
        return locale;
    }

    public Enumeration getLocales() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.processLocales();
        return new Enumeration(){
            Iterator iter;
            {
                this.iter = SRTServletRequest.this._srtRequestHelper._locales.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
        };
    }

    public boolean isSecure() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean secure = this._request.isSSL();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isSecure", "this->" + this + ":  value --> " + String.valueOf(secure));
        }
        return secure;
    }

    @Override
    public String getCipherSuite() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String cipherSuite = this._request.getCipherSuite();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCipherSuite", "this->" + this + ":  value --> " + cipherSuite);
        }
        return cipherSuite;
    }

    public String getDirectConnectionCipherSuite() {
        String cipherSuite;
        block5: {
            if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
                this.checkRequestObjectInUse();
            }
            Class<?> requestClass = this._request.getClass();
            cipherSuite = null;
            if (this.checkAssignableFromIRequestImpl(requestClass)) {
                try {
                    Method method = requestClass.getMethod("getConnectionCipherSuite", null);
                    cipherSuite = (String)method.invoke((Object)this._request, null);
                }
                catch (Exception e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.getDirectConnectionCipherSuite", "587", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block5;
                    logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionCipherSuite", "failed to retrieve direction connection cipher suite", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionCipherSuite", "this->" + this + ":  value --> " + cipherSuite);
        }
        return cipherSuite;
    }

    public X509Certificate[] getPeerCertificates() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": ");
        }
        Object[] certs = this._request.getPeerCertificates();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPeerCertificates", "this->" + this + ": certificates", certs);
        }
        return certs;
    }

    public X509Certificate[] getDirectConnectionPeerCertificates() {
        X509Certificate[] certs;
        block6: {
            if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
                this.checkRequestObjectInUse();
            }
            Class<?> requestClass = this._request.getClass();
            certs = null;
            if (this.checkAssignableFromIRequestImpl(requestClass)) {
                try {
                    Method method = requestClass.getMethod("getConnectionPeerCertificates", null);
                    certs = (X509Certificate[])method.invoke((Object)this._request, null);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionPeerCertificates", "this->" + this + ":  certs value --> " + certs);
                    }
                }
                catch (Exception e) {
                    FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.getDirectConnectionPeerCertificates", "635", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block6;
                    logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionPeerCertificates", "failed to retrieve direction connection cipher suite", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDirectConnectionPeerCertificates", "this->" + this + ":  value --> " + certs);
        }
        return certs;
    }

    private boolean checkAssignableFromIRequestImpl(Class<? extends IRequest> requestClass) {
        Class<IRequestImpl> ir = IRequestImpl.class;
        boolean check = ir.isAssignableFrom(requestClass);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "checkAssignableFromIRequestImpl", "this->" + this + ":  request class --> " + requestClass + " ,ir class --> " + ir + " isAssignableFrom -->" + check);
        }
        return check;
    }

    private Boolean isDirectConnection() {
        Boolean direct;
        block5: {
            if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
                this.checkRequestObjectInUse();
            }
            direct = Boolean.valueOf("false");
            Class<?> requestClass = this._request.getClass();
            if (this.checkAssignableFromIRequestImpl(requestClass)) {
                try {
                    Method method = requestClass.getMethod("checkForDirectConnection", null);
                    direct = (Boolean)method.invoke((Object)this._request, null);
                }
                catch (Exception e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block5;
                    logger.logp(Level.FINE, CLASS_NAME, "isDirectConnection", "failed to retrieve direct connection check", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isDirectConnection", "return -> " + direct);
        }
        return direct;
    }

    public void setRequest(IRequest _request) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRequest", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._request = _request;
    }

    @Override
    public void attributeAdded(String key, Object newVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeAdded", "this->" + this + ":  key --> " + key + " value --> " + newVal);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((webapp = this.getDispatchContext().getWebApp()) != null) {
            webapp.notifyServletRequestAttrAdded(this, key, newVal);
        }
    }

    @Override
    public void attributeRemoved(String key, Object oldVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeRemoved", "this->" + this + ":  key --> " + key + " value --> " + oldVal);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((webapp = this.getDispatchContext().getWebApp()) != null) {
            webapp.notifyServletRequestAttrRemoved(this, key, oldVal);
        }
    }

    @Override
    public void attributeReplaced(String key, Object oldVal) {
        WebApp webapp;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "attributeReplaced", "this->" + this + ":  key --> " + key + " value --> " + oldVal);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((webapp = this.getDispatchContext().getWebApp()) != null) {
            webapp.notifyServletRequestAttrReplaced(this, key, oldVal);
        }
    }

    protected void setLocales(Iterator iter) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setLocales", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        while (iter.hasNext()) {
            this._srtRequestHelper._locales.add(iter.next());
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "this->" + this + ": gotReader = " + this._srtRequestHelper._gotReader);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this.multiReadPropertyEnabled && this._srtRequestHelper._InputStreamClosed) {
            ((SRTInputStream)this._in).restart();
        }
        if (this._srtRequestHelper._gotReader) {
            throw new IllegalStateException(liberty_nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._srtRequestHelper._gotInputStream = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStream", "stream->" + (Object)((Object)this._in) + ": gotReader = " + this._srtRequestHelper._gotReader);
        }
        return this._in;
    }

    @Override
    public IRequest getIRequest() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getIRequest", "this->" + this + ": ");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._request;
    }

    public synchronized BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReader", "this->" + this + ": gotInputStream = " + this._srtRequestHelper._gotInputStream);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this.multiReadPropertyEnabled && this._srtRequestHelper._InputStreamClosed) {
            ((SRTInputStream)this._in).restart();
        }
        if (this._srtRequestHelper._gotInputStream) {
            throw new IllegalStateException(liberty_nls.getString("InputStream.already.obtained", "Input Stream already obtained"));
        }
        if (this._srtRequestHelper._reader == null) {
            this._srtRequestHelper._reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this._in), this.getReaderEncoding()));
        }
        this._srtRequestHelper._gotReader = true;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReader", "this->" + this + ": reader = " + this._srtRequestHelper._reader);
        }
        return this._srtRequestHelper._reader;
    }

    protected void releaseInputStream() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._gotInputStream) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "releaseInputStream()", "");
            }
            this._srtRequestHelper._gotInputStream = false;
        }
    }

    protected void releaseReader() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._gotReader) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "releaseReader()", "");
            }
            this._srtRequestHelper._gotReader = false;
            this._srtRequestHelper._reader = null;
        }
    }

    @Override
    public void alertOpen() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertOpen()", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper._InputStreamClosed = false;
    }

    @Override
    public void alertClose() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertClose()", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper._InputStreamClosed = true;
    }

    protected SRTConnectionContext getConnectionContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getConnectionContext", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._connContext;
    }

    @Override
    public IWebAppDispatcherContext getWebAppDispatcherContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getWebAppDispatcherContext", " " + this);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        IWebAppDispatcherContext dc = null;
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        dc = localThreadData.getDispatchContext();
        if (dc == null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getWebAppDispatcherContext", " return _dispatchContext " + this._dispatchContext);
            }
            dc = this._dispatchContext;
        }
        return dc;
    }

    @Override
    public void setWebAppDispatcherContext(IWebAppDispatcherContext ctx) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setWebAppDispatcherContext", " old context [" + this.getDispatchContext() + "] new context [" + ctx + "]");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.setDispatchContext(ctx);
        this._dispatchContext = (WebAppDispatcherContext)ctx;
        this.resetPathElements();
    }

    @Override
    public void resetPathElements() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "resetPathElements", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.setRequestURI(null);
        localThreadData.setPathInfo(null);
    }

    public String getLocalAddr() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String addr = null;
        if (this._request != null) {
            addr = this._request.getLocalAddr();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalAddr", " address --> " + addr);
        }
        return addr;
    }

    public String getLocalName() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String name = this._request.getLocalName();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalName", " name --> " + name);
        }
        return name;
    }

    public int getLocalPort() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        int port = 0;
        if (this._request != null) {
            port = this._request.getLocalPort();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocalPort", " port --> " + String.valueOf(port));
        }
        return port;
    }

    public int getRemotePort() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        int port = 0;
        if (this._request != null) {
            port = this._request.getRemotePort();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemotePort", " port --> " + String.valueOf(port));
        }
        return port;
    }

    @Override
    public IExtendedResponse getResponse() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._connContext.getResponse();
    }

    @Override
    public void setResponse(IExtendedResponse extResp) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._connContext.setResponse(extResp);
    }

    @Override
    public void start() {
    }

    protected void copyFrom(SRTServletRequest original) throws CloneNotSupportedException {
        if (original._requestContext != null) {
            this._requestContext = (SRTRequestContext)original._requestContext.clone(this);
        }
        if (original.getDispatchContext() != null) {
            this.setWebAppDispatcherContext((WebAppDispatcherContext)original.getDispatchContext().clone(this, this._requestContext));
        }
        if (original._connContext != null) {
            this._connContext = (SRTConnectionContext)original._connContext.clone(this, this._dispatchContext);
        }
        if (original._srtRequestHelper != null) {
            this._srtRequestHelper = (SRTServletRequestHelper)original._srtRequestHelper.clone();
        }
        if (original._paramStack != null) {
            this._paramStack = (UnsynchronizedStack)original._paramStack.clone();
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequest clonedSRTServletRequest = (SRTServletRequest)super.clone();
        clonedSRTServletRequest.copyFrom(this);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "clone", " exit original -->" + this + " cloned -->" + clonedSRTServletRequest);
        }
        return clonedSRTServletRequest;
    }

    public String getAuthType() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String authType = null;
        authType = this.getDispatchContext().isSecurityEnabledForApplication() ? (String)this.getPrivateAttribute("AUTH_TYPE") : this._request.getAuthType();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAuthType", " authType --> " + authType);
        }
        if (authType != null) {
            if (authType.equals("BASIC")) {
                return "BASIC";
            }
            if (authType.equals("CLIENT_CERT")) {
                return "CLIENT_CERT";
            }
            if (authType.equals("DIGEST")) {
                return "DIGEST";
            }
            if (authType.equals("FORM")) {
                return "FORM";
            }
        }
        return authType;
    }

    public String getCharacterEncoding() {
        String _encoding;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._characterEncoding != null) {
            return this._srtRequestHelper._characterEncoding;
        }
        String type = this.getContentType();
        int index = -1;
        if (type != null) {
            index = type.indexOf("charset=");
        }
        if ((_encoding = SRTServletRequest.getEncodingFromContentType(type, index)) != null) {
            try {
                this.setCharacterEncoding(_encoding);
            }
            catch (UnsupportedEncodingException e) {
                logger.logp(Level.INFO, CLASS_NAME, "getCharacterEncoding", "Unable to set request character encoding based upon request header ", e);
            }
        }
        return _encoding;
    }

    public static String getEncodingFromContentType(String type, int index) {
        int semicolonIndex;
        int endIndex;
        int startIndex;
        String _encoding = null;
        if (index > -1 && startIndex <= (endIndex = (semicolonIndex = type.indexOf(59, (startIndex = index + 8) + 1)) == -1 ? type.length() - 1 : semicolonIndex - 1)) {
            boolean endsWithQoute;
            boolean startsWithQoute = type.charAt(startIndex) == '\"' || type.charAt(startIndex) == '\'';
            boolean bl = endsWithQoute = type.charAt(endIndex) == '\"' || type.charAt(endIndex) == '\'';
            _encoding = startsWithQoute && endsWithQoute ? type.substring(startIndex + 1, endIndex) : (semicolonIndex == -1 ? type.substring(startIndex) : type.substring(startIndex, semicolonIndex));
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEncodingFromContentType", "type->" + type + ", encoding --> " + _encoding);
        }
        return _encoding;
    }

    @Override
    public String getReaderEncoding() {
        return this.getReaderEncoding(false);
    }

    public String getReaderEncoding(boolean ignoreInvalid) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._readerEncoding != null && !ignoreInvalid) {
            return this._srtRequestHelper._readerEncoding;
        }
        if (this._srtRequestHelper._readerEncodingInvalidIgnored != null && ignoreInvalid) {
            return this._srtRequestHelper._readerEncodingInvalidIgnored;
        }
        String encoding = CLIENT_ENCODING_OVERRIDE;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "client encoding override --> " + encoding);
        }
        Boolean invalidIgnored = false;
        if (encoding == null) {
            encoding = this.getCharacterEncoding();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "content-type header --> " + encoding);
            }
            if (encoding != null && ignoreInvalid && !EncodingUtils.isCharsetSupported(encoding)) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "content-type header encoding is invalid, so ignore it.");
                }
                encoding = null;
                invalidIgnored = true;
            }
        }
        WebAppConfiguration webAppCfg = this.getDispatchContext().getWebApp().getConfiguration();
        if (encoding == null && webAppCfg.isAutoRequestEncoding()) {
            Locale _locale;
            String acceptLanguage = this.getHeader(HttpHeaderKeys.HDR_ACCEPT_LANGUAGE);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "accept-language --> " + acceptLanguage);
            }
            if (acceptLanguage != null && !acceptLanguage.equals("*") && (encoding = webAppCfg.getLocaleEncoding(_locale = this.getLocale())) == null) {
                encoding = EncodingUtils.getEncodingFromLocale(_locale);
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "encoding from locale --> " + encoding);
                }
            }
        }
        if (encoding == null) {
            encoding = DEFAULT_CLIENT_ENCODING;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "default client encoding -->" + encoding);
            }
        }
        if (encoding == null) {
            encoding = "ISO-8859-1";
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", "default encoding --> " + encoding);
            }
        }
        String returnEncoding = EncodingUtils.getJvmConverter(encoding);
        if (!invalidIgnored.booleanValue()) {
            this._srtRequestHelper._readerEncoding = returnEncoding;
        }
        if (ignoreInvalid) {
            this._srtRequestHelper._readerEncodingInvalidIgnored = returnEncoding;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getReaderEncoding", " encoding  converted --> " + returnEncoding);
        }
        return returnEncoding;
    }

    public Cookie[] getCookies() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookies", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (!this._srtRequestHelper._cookiesParsed) {
            this._srtRequestHelper._cookies = this._request.getCookies();
            this._srtRequestHelper._cookiesParsed = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            this.displayCookies(this._srtRequestHelper._cookies);
        }
        return this._srtRequestHelper._cookies;
    }

    @Override
    public void addParameter(String name, String[] values) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        Hashtable<String, String[]> aParam = new Hashtable<String, String[]>(3);
        aParam.put(name, values);
        this.mergeQueryParams(aParam);
    }

    @Override
    public void setMethod(String method) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper._method = method;
    }

    @Override
    public void setInputStreamData(HashMap inStreamInfo) throws IOException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._gotReader) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "attempt to setInputStreamData after it has been read");
            }
            throw new IllegalStateException(liberty_nls.getString("Reader.already.obtained", "Reader already obtained"));
        }
        this._setInputDataStreamCalled = true;
        if (inStreamInfo != null) {
            Integer contentLength = (Integer)inStreamInfo.get(INPUT_STREAM_CONTENT_DATA_LENGTH);
            if (contentLength == null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No content length in passed map. Throw IOException");
                }
                throw new IllegalStateException();
            }
            this._setInputStreamContentLength = contentLength.intValue();
            this._setInputStreamContentType = (String)inStreamInfo.get(INPUT_STREAM_CONTENT_TYPE);
            byte[] inStreamContentData = (byte[])inStreamInfo.get(INPUT_STREAM_CONTENT_DATA);
            if (inStreamContentData != null) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "SetInputStreamData Content Type = " + this._setInputStreamContentType + ", contentLength = " + this._setInputStreamContentLength + ", data length = " + inStreamContentData.length + " : this = " + this);
                }
                ByteArrayInputStream inDataInputStream = new ByteArrayInputStream(inStreamContentData);
                try {
                    this._in.init(inDataInputStream);
                    if (inStreamContentData.length > 0) {
                        this._in.setContentLength(inStreamContentData.length);
                    }
                    SRTServletRequestThreadData localThreadData = this.verifyThreadData();
                    localThreadData.setParameters(null);
                }
                catch (IOException exc) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "Exception caught : " + exc);
                    }
                    throw exc;
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setInputStreamData", "No map passed as input");
            }
            throw new IllegalArgumentException();
        }
    }

    @Override
    public HashMap getInputStreamData() throws IOException {
        return this.getInputStreamData(-1L);
    }

    @Override
    public HashMap getInputStreamData(long maxAllowedLength) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getInputStreamData");
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "[" + this + "]");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        ServletInputStream in = this.getInputStream();
        HashMap<String, Object> inStreamInfo = new HashMap<String, Object>();
        if (this.getContentType() != null) {
            inStreamInfo.put(INPUT_STREAM_CONTENT_TYPE, new String(this.getContentType()));
        } else {
            inStreamInfo.put(INPUT_STREAM_CONTENT_TYPE, null);
        }
        int offset = 0;
        int inputLen = 0;
        int len = this.getContentLength();
        inStreamInfo.put(INPUT_STREAM_CONTENT_DATA_LENGTH, new Integer(len));
        if (len > 0 && maxAllowedLength > 0L && (long)len <= maxAllowedLength) {
            byte[] postedBytes = new byte[len];
            do {
                if ((inputLen = in.read(postedBytes, offset, len - offset)) > 0) continue;
                String msg = nls.getString("post.body.contains.less.bytes.than.specified", "post body contains less bytes than specified by content-length");
                throw new IOException(msg);
            } while (len - (offset += inputLen) > 0);
            inStreamInfo.put(INPUT_STREAM_CONTENT_DATA, postedBytes);
        } else {
            inStreamInfo.put(INPUT_STREAM_CONTENT_DATA, null);
        }
        if (in != null) {
            this.releaseInputStream();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getInputStreamData", "ContentType = " + this.getContentType() + ", data length = " + len);
            logger.exiting(CLASS_NAME, "getInputStreamData");
        }
        return inStreamInfo;
    }

    public void setRawParameters(Hashtable params) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRawParameters", "");
        }
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.setParameters(params);
    }

    public Hashtable getRawParameters() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRawParameters", "");
        }
        this.parseParameters();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        return (Hashtable)localThreadData.getParameters();
    }

    public String getParameter(String name) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameter", " name --> " + name);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.parseParameters();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        String[] values = (String[])localThreadData.getParameters().get(name);
        String value = null;
        if (values != null && values.length > 0) {
            value = values[0];
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameter", " value --> " + name);
        }
        return value;
    }

    public Enumeration getParameterNames() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterNames", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.parseParameters();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        return ((Hashtable)localThreadData.getParameters()).keys();
    }

    public String[] getParameterValues(String name) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.parseParameters();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        String[] values = (String[])localThreadData.getParameters().get(name);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterValues", " name --> " + name);
        }
        if (WCCustomProperties.PRESERVE_REQUEST_PARAMETER_VALUES) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getParameterValues", " returning a clone of parameter values");
            }
            return values == null ? null : (String[])values.clone();
        }
        return values;
    }

    @Override
    public String getPathInfo() {
        String path;
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (localThreadData.getPathInfo() == null) {
            String aPathInfo;
            WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)localThreadData.getDispatchContext();
            if (dispatchContext == null) {
                dispatchContext = this._dispatchContext;
            }
            if ((aPathInfo = dispatchContext.getPathInfo()) == null) {
                return null;
            }
            localThreadData.setPathInfo(WebGroup.stripURL(aPathInfo, false));
        }
        if ((path = localThreadData.getPathInfo()).equals("")) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getPathInfo", " path is \"\", returning null");
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathInfo", " path --> [" + path + "]");
        }
        return path;
    }

    public String getServletPath() {
        String path;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((path = this.getDispatchContext().getServletPath()) != null && (SERVLET_PATH_FOR_DEFAULT_MAPPING || WCCustomProperties.REMOVE_TRAILING_SERVLET_PATH_SLASH)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getServletPath", "stripping path -> " + path);
            }
            path = WebGroup.stripURL(path, false);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServletPath", "path --> " + path);
        }
        return path;
    }

    public String getPathTranslated() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String path = this.getDispatchContext().getPathTranslated();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPathTranslated", " --> path " + path);
        }
        return path;
    }

    @Override
    public String getQueryString() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (localThreadData.getQueryString() == null && !localThreadData.isQSSetExplicit() && this._request != null) {
            localThreadData.setQueryString(this._request.getQueryString());
        }
        String queryString = null;
        if (localThreadData != null) {
            queryString = localThreadData.getQueryString();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getQueryString", " queryString --> " + PasswordNullifier.nullifyParams((String)queryString));
        }
        return queryString;
    }

    @Override
    public void setQueryString(String qs) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setQueryString", " queryString --> " + qs);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.setQueryString(qs);
    }

    public String getRealPath(String path) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String realPath = this.getDispatchContext().getRealPath(path);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRealPath", "path -->  " + path + " realPath --> " + realPath);
        }
        return realPath;
    }

    public String getRemoteUser() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String remoteUser = null;
        Principal principal = this.getUserPrincipal();
        if (principal == null) {
            if (this._request != null) {
                remoteUser = this._request.getRemoteUser();
            }
        } else {
            remoteUser = principal.getName();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getRemoteUser", "(security enabled)");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRemoteUser", "user=" + remoteUser);
        }
        return remoteUser;
    }

    public String getRequestedSessionId() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String id = this.getDispatchContext().getRequestedSessionId();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestedSessionId", "id --> " + id);
        }
        return id;
    }

    @Override
    public String getRequestURI() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (localThreadData != null && localThreadData.getRequestURI() == null) {
            String aURI = this.getEncodedRequestURI();
            if (aURI == null) {
                return null;
            }
            localThreadData.setRequestURI(WebGroup.stripURL(aURI));
        }
        String uri = null;
        if (localThreadData != null) {
            uri = localThreadData.getRequestURI();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestURI", " uri --> " + uri);
        }
        return uri;
    }

    public String getServerName() {
        String sName;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((sName = this._request.getServerName()) == null || sName.length() == 0) {
            try {
                sName = InetAddress.getLocalHost().getHostName();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getServerName", "using InetAddress --> " + sName);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (sName.charAt(0) != '[' && sName.indexOf(58) != -1) {
            sName = "[" + sName + "]";
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getServerName", "serverName --> " + sName);
        }
        return sName;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSession", "create " + String.valueOf(create) + ", this -> " + this);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._requestContext.getSession(create, this.getDispatchContext().getWebApp());
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean idFromCookie = this.getDispatchContext().isRequestedSessionIdFromCookie();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdFromCookie", " " + String.valueOf(idFromCookie));
        }
        return idFromCookie;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean idFromURL = this.getDispatchContext().isRequestedSessionIdFromURL();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdFromURL", " " + String.valueOf(idFromURL));
        }
        return idFromURL;
    }

    public boolean isRequestedSessionIdValid() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean sessionInvalid = this._requestContext.isRequestedSessionIdValid(this.getDispatchContext().getWebApp());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isRequestedSessionIdValid", " " + String.valueOf(sessionInvalid));
        }
        return sessionInvalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void parseParameters() {
        String method;
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (localThreadData.getParameters() != null) {
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "set _parametersRead");
        }
        this._srtRequestHelper._parametersRead = true;
        try {
            localThreadData.setParameters(new Hashtable());
            String ct = this.getContentType();
            if (ct != null) {
                ct = ct.toLowerCase();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Content type -->" + ct);
                }
                if (ct.startsWith("java-internal")) {
                    String[] values = new String[]{ct};
                    localThreadData.getParameters().put(new String("Application specific data. Content-type "), values);
                    return;
                }
            }
        }
        catch (Exception npe) {
            FFDCWrapper.processException(npe, "com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", "667", this);
            logger.logp(Level.INFO, CLASS_NAME, "parseParameters", "Exception thrown during parsing of parameters", npe.toString());
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Content type is not java-internal");
        }
        if ((method = this.getMethod()).equalsIgnoreCase("post")) {
            block47: {
                String contentType = this.getContentType();
                if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
                    if (this.multiReadPropertyEnabled && this._srtRequestHelper._InputStreamClosed) {
                        ((SRTInputStream)this._in).restart();
                    }
                    if (!this._srtRequestHelper._gotInputStream && !this._srtRequestHelper._gotReader) {
                        try {
                            localThreadData.setParameters(this.parsePostData());
                        }
                        catch (IOException io) {
                            FFDCWrapper.processException(io, "com.ibm.ws.webcontainer.srt.SRTServletRequest.parseParameters", "765", this);
                            logger.logp(Level.SEVERE, CLASS_NAME, "parseParameters", "Error.Parsing.Parameters", io);
                        }
                        finally {
                            this.releaseInputStream();
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "ignoring post data gotReader=" + this._srtRequestHelper._gotReader + ", gotInputStream = " + this._srtRequestHelper._gotInputStream);
                    }
                    if (localThreadData.getParameters() != null) {
                        this.parseQueryStringList();
                    }
                }
                if (contentType != null && contentType.startsWith("multipart/form-data") && localThreadData.getParameters() != null) {
                    this.parseQueryStringList();
                    try {
                        this.prepareMultipart();
                        StringBuffer value = new StringBuffer("");
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "multipart size: " + this._srtRequestHelper.multipartPartsHashMap.size());
                        }
                        for (String partName : this._srtRequestHelper.multipartPartsHashMap.keySet()) {
                            ArrayList<Part> plist = this._srtRequestHelper.multipartPartsHashMap.get(partName);
                            if (plist == null) continue;
                            for (Part p : plist) {
                                BufferedReader reader;
                                InputStreamReader streamReader;
                                value.setLength(0);
                                if (!((SRTServletRequestPart)p).isFormField()) continue;
                                InputStream partInputStream = p.getInputStream();
                                if (WCCustomProperties.PARSE_PARTS_PARAMETERS_USING_REQUEST_ENCODING) {
                                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Parsing multipart form fields using request encoding");
                                    }
                                    streamReader = new InputStreamReader(partInputStream, this.getReaderEncoding());
                                    reader = new BufferedReader(streamReader);
                                } else {
                                    streamReader = new InputStreamReader(partInputStream);
                                    reader = new BufferedReader(streamReader);
                                }
                                String line = null;
                                try {
                                    if (!WCCustomProperties.KEEP_SEPARATOR_IN_MULTIPART_FORM_FIELDS) {
                                        while ((line = reader.readLine()) != null) {
                                            value.append(line);
                                        }
                                    } else {
                                        int read = -1;
                                        int size = (int)p.getSize();
                                        char[] buffer = new char[size];
                                        read = streamReader.read(buffer, 0, size);
                                        value.append(buffer, 0, read);
                                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                                            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Parsing multipart form field keeping line separators, partName-> " + partName + ", partSize-> " + size + ", read-> " + read);
                                        }
                                    }
                                }
                                finally {
                                    partInputStream.close();
                                    reader.close();
                                    streamReader.close();
                                }
                                if (localThreadData.getParameters().containsKey(partName)) {
                                    String[] oldValues = (String[])localThreadData.getParameters().get(partName);
                                    String[] valArray = new String[oldValues.length + 1];
                                    System.arraycopy(oldValues, 0, valArray, 0, oldValues.length);
                                    valArray[oldValues.length] = value.toString();
                                    localThreadData.getParameters().put(partName, valArray);
                                    continue;
                                }
                                String[] values = new String[]{value.toString()};
                                localThreadData.getParameters().put(partName, values);
                            }
                        }
                    }
                    catch (UnsupportedOperationException uoe) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Error parsing parameters, maybe no MutliPartConfig defined in servlet. ", uoe);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseParameters", "Error.Parsing.Parameters", iae);
                        throw iae;
                    }
                    catch (Exception e) {
                        if (WCCustomProperties.LOG_MULTIPART_EXCEPTIONS_ON_PARSEPARAMETER) {
                            logger.logp(Level.SEVERE, CLASS_NAME, "parseParameters", "Error.Parsing.Parameters", e);
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block47;
                        logger.logp(Level.FINE, CLASS_NAME, "parseParameters", "Error.Parsing.Parameters", e);
                    }
                }
            }
            if (localThreadData.getParameters() == null || localThreadData.getParameters().isEmpty()) {
                this.parseQueryStringList();
            }
        } else {
            this.parseQueryStringList();
        }
        if (localThreadData.getParameters() == null) {
            localThreadData.setParameters(new Hashtable());
        }
    }

    protected Hashtable parsePostData() throws IOException {
        if (this.getContentLength() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "parsePostData", "parsing post data based upon content length");
            }
            return RequestUtils.parsePostData(this.getContentLength(), this.getInputStream(), this.getReaderEncoding(), this.multiReadPropertyEnabled);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parsePostData", "parsing post data based upon input stream (possibly chunked)");
        }
        return RequestUtils.parsePostData(this.getInputStream(), this.getReaderEncoding(), this.multiReadPropertyEnabled);
    }

    private void parseQueryStringList() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "parseQueryStringList", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        Hashtable tmpQueryParams = null;
        LinkedList queryStringList = localThreadData.getQueryStringList();
        if (queryStringList == null || queryStringList.isEmpty()) {
            String queryString = this.getQueryString();
            if (queryString != null && (queryString.indexOf(61) != -1 || WCCustomProperties.ALLOW_QUERY_PARAM_WITH_NO_EQUAL)) {
                if (localThreadData.getParameters() == null || localThreadData.getParameters().isEmpty()) {
                    localThreadData.setParameters(RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding(true)));
                } else {
                    tmpQueryParams = RequestUtils.parseQueryString(this.getQueryString(), this.getReaderEncoding(true));
                    this.mergeQueryParams(tmpQueryParams);
                }
            }
        } else {
            Iterator i = queryStringList.iterator();
            QSListItem qsListItem = null;
            while (i.hasNext()) {
                qsListItem = (QSListItem)i.next();
                String queryString = qsListItem._qs;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "parseQueryStringList", "queryString --> " + queryString);
                }
                if (qsListItem._qsHashtable != null) {
                    this.mergeQueryParams(qsListItem._qsHashtable);
                    continue;
                }
                if (queryString == null || queryString.indexOf(61) == -1 && !WCCustomProperties.ALLOW_QUERY_PARAM_WITH_NO_EQUAL) continue;
                if (localThreadData.getParameters() == null || localThreadData.getParameters().isEmpty()) {
                    qsListItem._qsHashtable = RequestUtils.parseQueryString(queryString, this.getReaderEncoding());
                    localThreadData.setParameters(qsListItem._qsHashtable);
                    qsListItem._qs = null;
                    continue;
                }
                qsListItem._qsHashtable = tmpQueryParams = RequestUtils.parseQueryString(queryString, this.getReaderEncoding());
                qsListItem._qs = null;
                this.mergeQueryParams(tmpQueryParams);
            }
        }
    }

    private void mergeQueryParams(Hashtable tmpQueryParams) {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (tmpQueryParams != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "tmpQueryParams.size() " + tmpQueryParams.size());
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "tmpQueryParams " + tmpQueryParams);
            }
            Enumeration enumeration = tmpQueryParams.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                if (localThreadData.getParameters() != null && localThreadData.getParameters().containsKey(key)) {
                    int i;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "_paramaters contains key " + key);
                    }
                    String[] postVals = (String[])localThreadData.getParameters().get(key);
                    String[] queryVals = (String[])tmpQueryParams.get(key);
                    String[] newVals = new String[postVals.length + queryVals.length];
                    int newValsIndex = 0;
                    for (i = 0; i < queryVals.length; ++i) {
                        newVals[newValsIndex++] = queryVals[i];
                    }
                    for (i = 0; i < postVals.length; ++i) {
                        newVals[newValsIndex++] = postVals[i];
                    }
                    localThreadData.getParameters().put(key, newVals);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "put key " + key + " into _parameters.");
                    continue;
                }
                if (localThreadData.getParameters() == null) {
                    localThreadData.setParameters(new Hashtable());
                }
                localThreadData.getParameters().put(key, tmpQueryParams.get(key));
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "mergeQueryParams", "put key " + key + " into _parameters. ");
            }
        }
    }

    private void removeQueryParams(Hashtable tmpQueryParams) {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (tmpQueryParams != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "tmpQueryParams.size() " + tmpQueryParams.size());
                logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "tmpQueryParams " + tmpQueryParams);
            }
            Enumeration enumeration = tmpQueryParams.keys();
            while (enumeration.hasMoreElements()) {
                String[] queryVals;
                String[] postVals;
                Object key = enumeration.nextElement();
                if (!localThreadData.getParameters().containsKey(key)) continue;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "_paramaters contains key " + key);
                }
                if ((postVals = (String[])localThreadData.getParameters().get(key)).length - (queryVals = (String[])tmpQueryParams.get(key)).length > 0) {
                    String[] newVals = new String[postVals.length - queryVals.length];
                    int newValsIndex = 0;
                    for (int i = queryVals.length; i < postVals.length; ++i) {
                        newVals[newValsIndex++] = postVals[i];
                    }
                    localThreadData.getParameters().put(key, newVals);
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "removeQueryParams", "put key " + key + " into _parameters.");
                    continue;
                }
                localThreadData.getParameters().remove(key);
            }
        }
    }

    @Override
    public void finish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "finish");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        try {
            int length = this.getContentLength();
            if (length > 0) {
                this._in.close();
            } else {
                this._in.finish();
            }
        }
        catch (IOException e) {
            FFDCWrapper.processException(e, "com.ibm.ws.webcontainer.srt.SRTServletRequest.finish", "875", this);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "finish", "Error occurred while finishing request", e);
            }
        }
        finally {
            this.cleanupFromFinish();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASS_NAME, "finish");
            }
        }
    }

    protected void cleanupFromFinish() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "cleanupFromFinish this [" + this + "] , nulling out _srtRequestHelper [" + this._srtRequestHelper + "]");
        }
        this._srtRequestHelper = null;
        this._request.clearHeaders();
        this._request = null;
        this._requestContext.finish();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        localThreadData.init(null);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "cleanupFromFinish");
        }
    }

    protected void processLocales() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "processLocales", "entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper._localesProcessed) {
            return;
        }
        if (this._srtRequestHelper._locales == null) {
            this._srtRequestHelper._locales = new LinkedList();
        }
        this.setLocales(EncodingUtils.getLocales(this).iterator());
        this._srtRequestHelper._localesProcessed = true;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestDispatcher", " path --> " + path);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this.getDispatchContext().getRequestDispatcher(path);
    }

    public String getContextPath() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String path = this.getDispatchContext().getContextPath();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getContextPath", " path --> " + path);
        }
        return path;
    }

    public boolean isUserInRole(String role) {
        IWebAppSecurityCollaborator webAppSec;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        boolean userInRole = (webAppSec = CollaboratorHelperImpl.getCurrentSecurityCollaborator()) != null ? webAppSec.isUserInRole(role, this) : false;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isUserInRole", " role --> " + role + " result --> " + String.valueOf(userInRole));
        }
        return userInRole;
    }

    public Principal getUserPrincipal() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        IWebAppSecurityCollaborator webAppSec = null;
        WebAppDispatcherContext dispatchContext = this.getDispatchContext();
        WebApp webApp = null;
        webAppSec = dispatchContext != null && (webApp = dispatchContext.getWebApp()) != null ? CollaboratorHelperImpl.getCurrentSecurityCollaborator(webApp) : CollaboratorHelperImpl.getCurrentSecurityCollaborator();
        if (webAppSec != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getUserPrincipal", "calling getUserPrincipal on " + webAppSec.getClass().getName());
            }
            return webAppSec.getUserPrincipal();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUserPrincipal", "returning null");
        }
        return null;
    }

    @Override
    public void pushParameterStack() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "pushParameterStack", "entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (localThreadData.getParameters() != null) {
            this._paramStack.push(((Hashtable)localThreadData.getParameters()).clone());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && localThreadData.getParameters() != null) {
            this.debugParams(localThreadData.getParameters());
        }
    }

    public void popParameterStack() {
        SRTServletRequestThreadData localThreadData;
        block5: {
            localThreadData = this.verifyThreadData();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "popParameterStack", "entry");
            }
            if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
                this.checkRequestObjectInUse();
            }
            try {
                localThreadData.setParameters((Hashtable)this._paramStack.pop());
            }
            catch (EmptyStackException empty) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block5;
                logger.logp(Level.FINE, CLASS_NAME, "popParameterStack", "Unable to remove item from stack", empty);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE) && localThreadData.getParameters() != null) {
            this.debugParams(localThreadData.getParameters());
        }
    }

    private void debugParams(Map parameters) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "debugParams", "entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (parameters != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "debugParams", "Only displaying value retrieved by request.getParameter(). More parameters may exist for parameter name");
            }
            for (String paramName : parameters.keySet()) {
                if (this.isSecure() || paramName.toUpperCase().indexOf("PASSWORD") > -1) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "debugParams", "paramName --> " + paramName + " paramValue [**********]");
                    continue;
                }
                String paramValue = this.getParameter(paramName);
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "debugParams", "paramName --> " + paramName + " paramValue --> " + paramValue);
            }
        }
    }

    @Override
    public void removeQSFromList() {
        LinkedList queryStringList;
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "removeQSFromList", "entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((queryStringList = localThreadData.getQueryStringList()) != null && !queryStringList.isEmpty()) {
            Map _tmpParameters = localThreadData.getParameters();
            this.popParameterStack();
            if (localThreadData.getParameters() == null && _tmpParameters != null) {
                localThreadData.setParameters(_tmpParameters);
                Hashtable tmpQueryParams = ((QSListItem)queryStringList.getLast())._qsHashtable;
                if (tmpQueryParams == null) {
                    tmpQueryParams = RequestUtils.parseQueryString(((QSListItem)queryStringList.getLast())._qs, this.getReaderEncoding(true));
                }
                this.removeQueryParams(tmpQueryParams);
            }
            queryStringList.removeLast();
        } else {
            this.popParameterStack();
        }
    }

    @Override
    public void aggregateQueryStringParams(String additionalQueryString, boolean setQS) {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "entry qs --> " + additionalQueryString + " set --> " + String.valueOf(setQS));
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        QSListItem tmpQS = null;
        if (localThreadData.getParameters() == null) {
            LinkedList<QSListItem> queryStringList;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "The paramater stack is currently null");
            }
            if ((queryStringList = localThreadData.getQueryStringList()) == null || queryStringList.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "The queryStringList is empty");
                }
                if (queryStringList == null) {
                    queryStringList = new LinkedList<QSListItem>();
                }
                if (this.getQueryString() != null) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "aggregateQueryStringParams", "getQueryString will be added first in the QSList wih value->" + this.getQueryString());
                    }
                    tmpQS = new QSListItem(this.getQueryString(), null);
                    queryStringList.add(tmpQS);
                }
                localThreadData.setQueryStringList(queryStringList);
            }
            if (additionalQueryString != null) {
                tmpQS = new QSListItem(additionalQueryString, null);
                queryStringList.add(tmpQS);
            }
        }
        if (setQS) {
            this.setQueryString(additionalQueryString);
        }
        if (localThreadData.getParameters() != null && additionalQueryString != null) {
            Hashtable parameters = RequestUtils.parseQueryString(additionalQueryString, this.getReaderEncoding(true));
            Enumeration e = parameters.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String[] newVals = (String[])parameters.get(key);
                if (localThreadData.getParameters().containsKey(key)) {
                    int i;
                    String[] oldVals = (String[])localThreadData.getParameters().get(key);
                    Vector<String> v = new Vector<String>();
                    for (i = 0; i < newVals.length; ++i) {
                        v.add(newVals[i]);
                    }
                    for (i = 0; i < oldVals.length; ++i) {
                        v.add(oldVals[i]);
                    }
                    String[] valArray = new String[v.size()];
                    v.toArray(valArray);
                    localThreadData.getParameters().put(key, valArray);
                    continue;
                }
                localThreadData.getParameters().put(key, newVals);
            }
        }
    }

    public Map getParameterMap() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParameterMap", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.parseParameters();
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        return localThreadData.getParameters();
    }

    public StringBuffer getRequestURL() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        StringBuffer fullURL = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        fullURL.append(scheme);
        fullURL.append("://");
        fullURL.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            fullURL.append(':');
            fullURL.append(this.getServerPort());
        }
        fullURL.append(this.getEncodedRequestURI());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestURL", "url --> " + fullURL);
        }
        return fullURL;
    }

    @Override
    public byte[] getSSLId() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        byte[] id = this._request.getSSLSessionID();
        return id;
    }

    private String getSSLSessionId() {
        byte[] id = this.getSSLId();
        String value = null;
        if (id != null) {
            value = IDGeneratorImpl.convertSessionIdBytesToSessionId((byte[])id, (int)SessionManagerConfigBase.getSessionIDLength());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSSLSessionId", "id -->" + value);
        }
        return value;
    }

    @Override
    public byte[] getCookieValueAsBytes(String cookieName) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        byte[] cookieValue = this._request.getCookieValue(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCookieValueAsBytes", " name --> " + cookieName + " value --> " + (cookieValue != null ? new String(cookieValue) : ""));
        }
        return cookieValue;
    }

    @Override
    public List getAllCookieValues(String cookieName) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        List cookieValues = this._request.getAllCookieValues(cookieName);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getAllCookieValues", " name --> " + cookieName + " values --> " + cookieValues);
        }
        return cookieValues;
    }

    @Override
    public String getUpdatedSessionId() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String id = this._srtRequestHelper._updatedSessionId;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getUpdatedSessionId", " id --> " + id);
        }
        return id;
    }

    @Override
    public void setSessionId(String id) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSessionId", " id --> " + id);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper._updatedSessionId = id;
    }

    @Override
    public Object getSessionAffinityContext() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        Object sac = this._srtRequestHelper._sessionAffinityContext;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSessionAffinityContext", " sac --> " + sac);
        }
        return sac;
    }

    @Override
    public void setSessionAffinityContext(Object sac) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSessionAffinityContext", " sac --> " + sac);
        }
        this._srtRequestHelper._sessionAffinityContext = sac;
    }

    @Override
    public String getEncodedRequestURI() {
        WebAppDispatcherContext dispatchContext;
        String uri;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        String string = uri = (dispatchContext = this.getDispatchContext()) == null ? this._request.getRequestURI() : dispatchContext.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getEncodedRequestURI", " uri --> " + uri);
        }
        return uri;
    }

    @Override
    public SRTRequestContext getRequestContext() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRequestContext", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._requestContext;
    }

    @Override
    public boolean getRunningCollaborators() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getRunningCollaborators", " value --> " + String.valueOf(this._runningCollaborators));
        }
        return this._runningCollaborators;
    }

    @Override
    public void setRunningCollaborators(boolean runningCollaborators) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setRunningCollaborators", " value --> " + String.valueOf(this._runningCollaborators));
        }
        this._runningCollaborators = runningCollaborators;
    }

    @Override
    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._requestContext.destroy();
        this._requestContext = null;
        this._connContext = null;
        this._dispatchContext = null;
        this._srtRequestHelper = null;
        this._paramStack = null;
        this._in = null;
        this._setInputStreamContentType = null;
        this._setInputStreamContentLength = -1L;
        this._setInputDataStreamCalled = false;
        this.usedStartAsyncNoParameters = false;
        if (this._request instanceof IPoolable) {
            ((IPoolable)((Object)this._request)).destroy();
        }
        this._request = null;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "destroy", " exit");
        }
    }

    protected WSServletInputStream createInputStream() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "createInputStream", " entry");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return new SRTInputStream();
    }

    @Override
    public void removeHeader(String header) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._request.removeHeader(header);
    }

    @Override
    public jakarta.servlet.AsyncContext getAsyncContext() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper.asyncContext == null) {
            throw new IllegalStateException();
        }
        return this._srtRequestHelper.asyncContext;
    }

    @Override
    public void closeResponseOutput() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "closeResponseOutput");
        }
        IResponse iResponse = this.getResponse().getIResponse();
        this.getResponse().closeResponseOutput(true);
        WebContainerRequestState reqState = WebContainerRequestState.getInstance(true);
        if (!reqState.isCompleted()) {
            iResponse.releaseChannel();
            WebContainerRequestState.getInstance(true).setCompleted(true);
        }
        this.finishAndDestroyConnectionContext();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "closeResponseOutput");
        }
    }

    @Override
    public void finishAndDestroyConnectionContext() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._connContext.finishConnection();
        this._connContext.destroy();
    }

    @Override
    public void setDispatcherType(DispatcherType dispatcherType) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setDispatcherType", "dispatcherType->" + dispatcherType);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper.dispatcherType = dispatcherType;
    }

    public DispatcherType getDispatcherType() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDispatcherType", "this ->" + this);
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper.dispatcherType == DispatcherType.ERROR) {
            return this._srtRequestHelper.dispatcherType;
        }
        if (this.getDispatchContext() != null) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getDispatcherType", "from _dispatchContext");
            }
            return this.getDispatchContext().getDispatcherType();
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getDispatcherType", "from _srtRequestHelper");
        }
        return this._srtRequestHelper.dispatcherType;
    }

    public ServletContext getServletContext() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this.getDispatchContext().getWebApp().getFacade();
    }

    private void addNoAsyncSupportedResources(String noAsyncResource) {
        if (this._srtRequestHelper.resourcesNotSupportAsync == null) {
            this._srtRequestHelper.resourcesNotSupportAsync = Collections.synchronizedList(new ArrayList());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "addNoAsyncSupportedResourceList", "resource " + noAsyncResource + " does not support async, this->" + this);
        }
        this._srtRequestHelper.resourcesNotSupportAsync.add(noAsyncResource);
    }

    private List<String> getNoAsyncSupportedResourcesList() {
        return this._srtRequestHelper.resourcesNotSupportAsync;
    }

    public boolean isAsyncStarted() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isAsyncStarted", "value = " + this._srtRequestHelper.asyncStarted + ", this->" + this);
        }
        return this._srtRequestHelper.asyncStarted;
    }

    public boolean isAsyncSupported() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        return this._srtRequestHelper.asyncSupported;
    }

    @Override
    public void setAsyncSupported(boolean asyncSupported) {
        String resource;
        WebContainerRequestState reqState;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setAsyncSupported", " asyncSupported -> " + asyncSupported);
        }
        if (!asyncSupported && (reqState = WebContainerRequestState.getInstance(false)) != null && (resource = (String)reqState.getAttribute("resourceNotSupportAsync")) != null) {
            this.addNoAsyncSupportedResources(resource);
            reqState.removeAttribute("resourceNotSupportAsync");
        }
        this._srtRequestHelper.asyncSupported = asyncSupported;
    }

    public jakarta.servlet.AsyncContext startAsync() {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        IExtendedResponse iExtendedResponse = this.getResponse();
        this.usedStartAsyncNoParameters = true;
        return this.startAsync(this, iExtendedResponse);
    }

    public jakarta.servlet.AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        WebContainerRequestState reqState;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((reqState = WebContainerRequestState.getInstance(true)).isCompleted() || this._srtRequestHelper.asyncContext != null && this._srtRequestHelper.asyncContext.isCompletePending()) {
            throw new AsyncIllegalStateException(nls.getString("trying.to.do.startAsync.after.a.complete"));
        }
        if (reqState.getCurrentThreadsIExtendedRequest() != this) {
            throw new AsyncIllegalStateException(nls.getString("not.called.from.within.the.context.of.a.dispatch.for.this.request"));
        }
        if (reqState.isAsyncMode()) {
            throw new AsyncIllegalStateException(nls.getString("cannot.call.startAsync.multiple.times.within.same.dispatch"));
        }
        if (!this.isAsyncSupported()) {
            List<String> resourcesList = this.getNoAsyncSupportedResourcesList();
            if (resourcesList != null && !resourcesList.isEmpty()) {
                StringBuilder noAsyncSupportedResources = new StringBuilder();
                for (String s : resourcesList) {
                    noAsyncSupportedResources.append(s + " ");
                }
                logger.logp(Level.SEVERE, CLASS_NAME, "startAsync", "resource.does.not.support.async", noAsyncSupportedResources.toString());
            }
            throw new AsyncIllegalStateException(nls.getString("request.does.not.support.async.servlet.processing"));
        }
        if (this._srtRequestHelper.asyncContext != null) {
            this._srtRequestHelper.asyncContext.initialize();
        } else {
            this._srtRequestHelper.asyncContext = WebContainer.getWebContainer().getAsyncContextFactory().getAsyncContext(this, this.getResponse(), this.getWebAppDispatcherContext());
        }
        this._srtRequestHelper.asyncContext.setRequestAndResponse(servletRequest, servletResponse);
        if (WCCustomProperties.SET_ASYNC_DISPATCH_REQUEST_URI && !this.usedStartAsyncNoParameters && servletRequest instanceof HttpServletRequest) {
            ((AsyncContextImpl)this._srtRequestHelper.asyncContext).setDispatchURI(((HttpServletRequest)servletRequest).getRequestURI());
        }
        this._request.startAsync();
        this.setAsyncStarted(true);
        reqState.setAsyncMode(true);
        reqState.setAsyncContext(this._srtRequestHelper.asyncContext);
        this.usedStartAsyncNoParameters = false;
        return this._srtRequestHelper.asyncContext;
    }

    public boolean authenticate(HttpServletResponse arg0) throws ServletException, IOException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        WebApp webApp = this.getDispatchContext().getWebApp();
        return webApp.getCollaboratorHelper().getSecurityCollaborator().authenticate(this, arg0);
    }

    public Part getPart(String arg0) throws ServletException, IOException {
        ArrayList<Part> values;
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.prepareMultipart();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getPart", "--> [" + arg0 + " ]");
        }
        if ((values = this._srtRequestHelper.multipartPartsHashMap.get(arg0)) != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public Collection<Part> getParts() throws ServletException, IOException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this.prepareMultipart();
        Collection<ArrayList<Part>> coll = this._srtRequestHelper.multipartPartsHashMap.values();
        ArrayList<Part> parts = new ArrayList<Part>();
        for (ArrayList<Part> p : coll) {
            parts.addAll(p);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getParts", "size -->" + parts.size());
        }
        return parts;
    }

    protected void prepareMultipart() throws ServletException, IOException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (!this._srtRequestHelper.multipartRequestInputStreamRead) {
            if (this._srtRequestHelper.multipartPartsHashMap == null) {
                this._srtRequestHelper.multipartPartsHashMap = new LinkedHashMap();
            }
            if (this.getContentType() != null && this.getContentType().startsWith("multipart/form-data")) {
                int contentLength = this.getContentLength();
                IServletConfig multiPartServletConfig = this.getDispatchContext().getCurrentServletReference().getServletConfig();
                MultipartConfigElement mce = multiPartServletConfig.getMultipartConfig();
                if (mce == null) {
                    throw new UnsupportedOperationException(nls.getString("multipart.no.multipart.config"));
                }
                this.parseMultipart(multiPartServletConfig, mce.getFileSizeThreshold(), mce.getLocation(), mce.getMaxFileSize(), mce.getMaxRequestSize());
                this._srtRequestHelper.multipartRequestInputStreamRead = true;
            } else {
                throw new ServletException(nls.getString("multipart.request.not.multipart"));
            }
        }
    }

    private void parseMultipart(IServletConfig multiPartServletConfig, int fileThreshold, String location, long maxFileSize, long maxRequestSize) throws IOException {
        int maxFileCount;
        File uploadFile;
        boolean isTraceOn;
        boolean bl = isTraceOn = TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE);
        if (isTraceOn) {
            logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", " " + multiPartServletConfig.getServletName() + " [" + fileThreshold + ", " + location + ", " + maxFileSize + " , " + maxRequestSize + "]");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if ((uploadFile = multiPartServletConfig.getMultipartBaseLocation()) == null) {
            WebApp webapp = this.getDispatchContext().getWebApp();
            File tmpLocation = (File)webapp.getAttribute("jakarta.servlet.context.tempdir");
            if (location == null || location.length() == 0) {
                uploadFile = tmpLocation;
            } else if (System.getSecurityManager() != null) {
                final String finalLocation = location;
                final File finalTmpLocation = tmpLocation;
                uploadFile = AccessController.doPrivileged(new PrivilegedAction<File>(){

                    @Override
                    public File run() {
                        File innerUploadFile = new File(finalLocation);
                        if (!innerUploadFile.isAbsolute() && !(innerUploadFile = new File(finalTmpLocation, finalLocation)).exists()) {
                            innerUploadFile.mkdirs();
                        }
                        return innerUploadFile;
                    }
                });
            } else {
                uploadFile = new File(location);
                if (!uploadFile.isAbsolute() && !(uploadFile = new File(tmpLocation, location)).exists()) {
                    uploadFile.mkdirs();
                }
            }
            if (isTraceOn) {
                logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "uploadFile location --> " + uploadFile.getAbsolutePath());
            }
            multiPartServletConfig.setMultipartBaseLocation(uploadFile);
        }
        DiskFileItemFactory fact = new DiskFileItemFactory(fileThreshold, uploadFile);
        ServletFileUpload sfu = new ServletFileUpload((FileItemFactory)fact);
        sfu.setFileSizeMax(maxFileSize);
        if (WCCustomProperties.USE_MAXREQUESTSIZE_FOR_MULTIPART) {
            if (isTraceOn) {
                logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "usemaxrequestsizeformultipart property set");
            }
            sfu.setSizeMax(maxRequestSize);
        }
        int n = maxFileCount = (maxFileCount = WCCustomProperties.MAX_FILE_COUNT) < 0 ? -1 : maxFileCount;
        if (isTraceOn) {
            logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "maxFileCount set to [" + maxFileCount + "]");
        }
        sfu.setFileCountMax((long)maxFileCount);
        int maxPartHeaderSize = MAX_PART_HEADER_SIZE;
        maxPartHeaderSize = maxPartHeaderSize < 0 ? -1 : maxPartHeaderSize;
        sfu.setPartHeaderSizeMax(maxPartHeaderSize);
        if (isTraceOn) {
            logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "maxPartHeaderSize set to [" + sfu.getPartHeaderSizeMax() + "]");
        }
        List list = null;
        try {
            if (this._srtRequestHelper.multipartException != null) {
                if (this._srtRequestHelper.multipartISEException) {
                    throw (IllegalStateException)this._srtRequestHelper.multipartException;
                }
                throw (IOException)this._srtRequestHelper.multipartException;
            }
            if (System.getSecurityManager() != null) {
                final ServletFileUpload finalSFU = sfu;
                final SRTServletRequest finalThis = this;
                try {
                    list = AccessController.doPrivileged(new PrivilegedExceptionAction<List>(){

                        @Override
                        public List run() throws FileUploadException {
                            List innerList = finalSFU.parseRequest((HttpServletRequest)finalThis);
                            return innerList;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            } else {
                list = sfu.parseRequest((HttpServletRequest)this);
            }
            if (list != null) {
                int maxParamPerRequest;
                if (isTraceOn) {
                    logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "part size after parsing request body --> " + list.size());
                }
                if ((maxParamPerRequest = WCCustomProperties.MAX_PARAM_PER_REQUEST) != -1 && maxParamPerRequest < list.size()) {
                    if (isTraceOn) {
                        logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "part size is greater than max param per request [" + maxParamPerRequest + "] ; throw ISE Exceeding.maximum.parameters");
                    }
                    throw new IllegalArgumentException(MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, maxParamPerRequest));
                }
                int totalPartSize = 0;
                int dupSize = 0;
                HashSet<Integer> key_hset = new HashSet<Integer>();
                ArrayList<Object> partValues = null;
                for (Object fileItem : list) {
                    Part p = this.morphIntoPart((DiskFileItem)fileItem);
                    boolean multipartPartsMapcontainsKey = this._srtRequestHelper.multipartPartsHashMap.containsKey(p.getName());
                    if (!multipartPartsMapcontainsKey && !key_hset.add(p.getName().hashCode())) {
                        ++dupSize;
                        if (isTraceOn) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "duplicate hashCode generated by part --> " + p.getName());
                        }
                        if (dupSize > WCCustomProperties.MAX_DUPLICATE_HASHKEY_PARAMS) {
                            throw new IllegalArgumentException(MessageFormat.format(nls.getString("Exceeding.maximum.hash.collisions"), WCCustomProperties.MAX_DUPLICATE_HASHKEY_PARAMS));
                        }
                    }
                    if (maxParamPerRequest == -1 || totalPartSize < maxParamPerRequest) {
                        if (multipartPartsMapcontainsKey) {
                            partValues = this._srtRequestHelper.multipartPartsHashMap.get(p.getName());
                            partValues.add(p);
                        } else {
                            partValues = new ArrayList<Part>();
                            partValues.add(0, p);
                        }
                        this._srtRequestHelper.multipartPartsHashMap.put(p.getName(), partValues);
                        ++totalPartSize;
                        continue;
                    }
                    throw new IllegalArgumentException(MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, totalPartSize));
                }
            }
        }
        catch (FileCountLimitExceededException maxFileCountException) {
            this._srtRequestHelper.multipartException = new IllegalStateException(MessageFormat.format(nls.getString("multipart.file.count.max.exceeded"), maxFileCount));
            this._srtRequestHelper.multipartISEException = true;
            throw (IllegalStateException)this._srtRequestHelper.multipartException;
        }
        catch (FileUploadBase.FileSizeLimitExceededException fileSizeException) {
            if (isTraceOn) {
                logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "FileSizeLimitExceededException [" + (Object)((Object)fileSizeException) + "]");
            }
            this._srtRequestHelper.multipartException = new IllegalStateException(nls.getString("multipart.file.size.too.big"));
            this._srtRequestHelper.multipartISEException = true;
            throw (IllegalStateException)this._srtRequestHelper.multipartException;
        }
        catch (FileUploadBase.SizeLimitExceededException sizeException) {
            if (isTraceOn) {
                logger.logp(Level.FINE, CLASS_NAME, "parseMultipart", "SizeLimitExceededException [" + (Object)((Object)sizeException) + "]");
            }
            this._srtRequestHelper.multipartException = new IllegalStateException(nls.getString("multipart.request.size.too.big"));
            this._srtRequestHelper.multipartISEException = true;
            throw (IllegalStateException)this._srtRequestHelper.multipartException;
        }
        catch (FileUploadException e) {
            this._srtRequestHelper.multipartException = new IOException(nls.getString("multipart.file.upload.exception"), e);
            throw (IOException)this._srtRequestHelper.multipartException;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("", e);
        }
    }

    protected Part morphIntoPart(DiskFileItem commonsFile) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        SRTServletRequestPart p = new SRTServletRequestPart(commonsFile);
        return p;
    }

    public void login(String username, String password) throws ServletException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        WebApp webApp = this.getDispatchContext().getWebApp();
        try {
            webApp.getCollaboratorHelper().getSecurityCollaborator().login(this, (HttpServletResponse)this.getResponse(), username, password);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            ServletException se = new ServletException((Throwable)e);
            throw se;
        }
    }

    public void logout() throws ServletException {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        WebApp webApp = this.getDispatchContext().getWebApp();
        webApp.getCollaboratorHelper().getSecurityCollaborator().logout(this, (HttpServletResponse)this.getResponse());
    }

    @Override
    public void setAsyncStarted(boolean b) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setAsyncStarted", "value = " + b + ", this->" + this);
        }
        this._srtRequestHelper.asyncStarted = b;
    }

    @Override
    public void setSSLAttributesInRequest(HttpServletRequest httpServletReq, String cs) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSSLAttributesInRequest", "this->" + this + ":  ,httpServletReq->" + httpServletReq);
        }
        String cipherSuite = null;
        cipherSuite = cs;
        if (cipherSuite != null) {
            httpServletReq.setAttribute("jakarta.servlet.request.cipher_suite", (Object)cipherSuite);
            Integer keySize = null;
            if (keySizeFromCipherMap) {
                keySize = WebContainer.getWebContainer().getKeySizefromCipherMap(cipherSuite);
                if (keySize == null) {
                    if (cipherSuite.contains("_AES_256_")) {
                        keySize = 256;
                    } else if (cipherSuite.contains("_3DES_")) {
                        keySize = 168;
                    } else if (cipherSuite.contains("_AES_128_") || cipherSuite.contains("_RC4_128_")) {
                        keySize = 128;
                    } else if (cipherSuite.contains("_DES_")) {
                        keySize = 56;
                    } else if (cipherSuite.contains("_RC4_40_") || cipherSuite.contains("_DES40_")) {
                        keySize = 40;
                    } else if (cipherSuite.contains("_NULL_")) {
                        keySize = 0;
                    }
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setSSLAttributesInRequest", " check for the size in properties file");
                }
                keySize = com.ibm.wsspi.webcontainer.WebContainer.getWebContainer().getKeySize(cipherSuite);
            }
            if (keySize != null) {
                httpServletReq.setAttribute("jakarta.servlet.request.key_size", (Object)keySize);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSSLAttributesInRequest", "no SSL Attributes to set");
        }
    }

    protected WebAppDispatcherContext getDispatchContext() {
        SRTServletRequestThreadData localThreadData = this.verifyThreadData();
        WebAppDispatcherContext dc = (WebAppDispatcherContext)localThreadData.getDispatchContext();
        if (dc == null) {
            dc = this._dispatchContext;
        }
        return dc;
    }

    @Override
    public Throwable getCurrentException() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCurrentException", "_dispatchContext : " + this.getDispatchContext());
        }
        if (this.getDispatchContext() == null) {
            return null;
        }
        return this.getDispatchContext().getCurrentException();
    }

    @Override
    public byte[][] serializeInputStreamData(Map isd) throws IOException, IllegalStateException {
        this.validateInputStreamData(isd);
        String type = (String)isd.get(INPUT_STREAM_CONTENT_TYPE);
        Integer length = (Integer)isd.get(INPUT_STREAM_CONTENT_DATA_LENGTH);
        byte[] data = (byte[])isd.get(INPUT_STREAM_CONTENT_DATA);
        int arraySize = 3;
        if (data != null) {
            ++arraySize;
        }
        byte[][] output = new byte[arraySize][];
        output[0] = this.longToBytes(length.intValue());
        if (type != null) {
            output[1] = this.intToBytes(type.length());
            output[2] = type.getBytes(StandardCharsets.UTF_8);
        } else {
            output[1] = this.intToBytes(0);
            output[2] = new byte[1];
        }
        if (data != null) {
            output[3] = data;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            String message = "total : " + this.sizeInputStreamData(isd) + " number of items : " + output.length;
            logger.logp(Level.FINE, CLASS_NAME, "serializeInputStreamData", message);
        }
        return output;
    }

    @Override
    public HashMap deserializeInputStreamData(byte[][] input) throws IllegalStateException {
        if (input == null || input.length < 2) {
            if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "deseriallizeInputStreamData", "The input data is null or fewer items than the expected. ");
            }
            throw new IllegalStateException("Invalid data.");
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        long length = this.bytesToLong(input[0]);
        output.put(INPUT_STREAM_CONTENT_DATA_LENGTH, (int)(length & 0xFFFFL));
        int typeLen = this.bytesToInt(input[1]);
        if (typeLen > 0) {
            output.put(INPUT_STREAM_CONTENT_TYPE, new String(input[2], StandardCharsets.UTF_8));
        } else {
            output.put(INPUT_STREAM_CONTENT_TYPE, null);
        }
        int items = input.length;
        if (length > 0L && items > 3) {
            output.put(INPUT_STREAM_CONTENT_DATA, input[3]);
        } else {
            output.put(INPUT_STREAM_CONTENT_DATA, null);
        }
        return output;
    }

    @Override
    public long sizeInputStreamData(Map isd) throws IllegalStateException {
        this.validateInputStreamData(isd);
        long size = 12L;
        String type = (String)isd.get(INPUT_STREAM_CONTENT_TYPE);
        size = type != null ? (size += (long)type.getBytes(StandardCharsets.UTF_8).length) : ++size;
        byte[] data = (byte[])isd.get(INPUT_STREAM_CONTENT_DATA);
        if (data != null) {
            size += (long)data.length;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "sizeInputStreamData", Long.toString(size));
        }
        return size;
    }

    protected void validateInputStreamData(Map isd) throws IllegalStateException {
        String message = null;
        if (isd != null) {
            if (isd.size() <= 3) {
                boolean type = isd.containsKey(INPUT_STREAM_CONTENT_TYPE);
                boolean length = isd.containsKey(INPUT_STREAM_CONTENT_DATA_LENGTH);
                boolean data = isd.containsKey(INPUT_STREAM_CONTENT_DATA);
                if (type && length && data) {
                    return;
                }
                message = "One of required values of InputStreamData is missing. type : " + type + " length : " + length + " data : " + data;
            } else {
                message = "InputStreamData contains an unrecognized item.";
            }
        } else {
            message = "InputStreamData is null.";
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "validateInputStreamData", message);
        }
        throw new IllegalStateException(message);
    }

    protected byte[] intToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return result;
    }

    protected int bytesToInt(byte[] b) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value <<= 8;
            value += b[i] & 0xFF;
        }
        return value;
    }

    protected byte[] longToBytes(long l) {
        byte[] value = new byte[8];
        for (int i = 7; i >= 0; --i) {
            value[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return value;
    }

    protected long bytesToLong(byte[] b) {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value <<= 8;
            value += (long)(b[i] & 0xFF);
        }
        return value;
    }

    public void alertISOpen() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertISOpen()", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        this._srtRequestHelper._InputStreamClosed = false;
        this.releaseInputStream();
        this.releaseReader();
    }

    public void alertISClose() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "alertISClose()", "");
        }
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (this._srtRequestHelper != null) {
            this._srtRequestHelper._InputStreamClosed = true;
        }
    }

    @Override
    public void setValuesIfMultiReadofPostdataEnabled() {
        if (!this.httpUpdatedwMultiReadValues) {
            WebApp webapp = this.getDispatchContext().getWebApp();
            if (webapp != null) {
                this.multiReadPropertyEnabled = webapp.getConfiguration().isEnablemultireadofpostdata();
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "setValuesIfMultiReadofPostdataEnabled", "this._in->" + (Object)((Object)this._in) + ": multiReadPropertyEnabled is " + this.multiReadPropertyEnabled);
                }
                if (this.multiReadPropertyEnabled && this._in instanceof SRTInputStream) {
                    ((SRTInputStream)this._in).setupforMultiRead(true);
                    ((SRTInputStream)this._in).setISObserver(this);
                }
                this.httpUpdatedwMultiReadValues = true;
            } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "setValuesIfMultiReadofPostdataEnabled", "this->" + this + ": webapp is " + webapp);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setValuesIfMultiReadofPostdataEnabled", "this->" + this + ": channelUpdated -> " + this.httpUpdatedwMultiReadValues);
        }
    }

    protected String getSrtHelperCharEncoding() {
        return this._srtRequestHelper._characterEncoding;
    }

    protected String getSrtRequestId() {
        return this._srtRequestHelper._requestID;
    }

    protected void setSrtRequestId(String id) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSrtRequestId", "this [" + this + "] , requestID [" + id + "]");
        }
        this._srtRequestHelper._requestID = id;
    }

    protected Object getSrtServletConnection() {
        return this._srtRequestHelper._servletConnection;
    }

    protected void setSrtServletConnection(Object conn) {
        if (WCCustomProperties.CHECK_REQUEST_OBJECT_IN_USE) {
            this.checkRequestObjectInUse();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setSrtServletConnection", "this [" + this + "] , servlet connection [" + conn + "]");
        }
        this._srtRequestHelper._servletConnection = conn;
    }

    private SRTServletRequestThreadData verifyThreadData() {
        SRTServletRequestThreadData localThreadData = this.threadData;
        if (localThreadData == null || localThreadData.thread != Thread.currentThread()) {
            this.threadData = localThreadData = SRTServletRequestThreadData.getInstance();
        }
        return localThreadData;
    }

    protected void displayCookies(Cookie[] cookie) {
        if (cookie == null) {
            return;
        }
        for (int i = 0; i < cookie.length; ++i) {
            logger.logp(Level.FINE, CLASS_NAME, "displayCookies", " " + cookie[i]);
        }
    }

    static {
        suppressHeadersInRequest = null;
        suppressheadersList = null;
        CLIENT_ENCODING_OVERRIDE = System.getProperty("client.encoding.override");
        DEFAULT_CLIENT_ENCODING = System.getProperty("default.client.encoding");
        suppressHeadersInRequest = WCCustomProperties.SUPPRESS_HEADERS_IN_REQUEST;
        if (suppressHeadersInRequest != null) {
            String delimiter = ",";
            suppressheadersList = new ArrayList();
            StringTokenizer st = new StringTokenizer(suppressHeadersInRequest, delimiter);
            while (st.hasMoreTokens()) {
                suppressheadersList.add(st.nextToken().trim());
            }
        }
        enableSetCharacterEncodingAfterGetReader = Boolean.valueOf(com.ibm.wsspi.webcontainer.WebContainer.getWebContainerProperties().getProperty("enablesetcharacterencodingaftergetreader"));
        disableSetCharacterEncodingAfterParametersRead = WCCustomProperties.DISABLE_SET_CHARACTER_ENCODING_AFTER_PARAMETERS_READ;
        keySizeFromCipherMap = Boolean.valueOf(com.ibm.wsspi.webcontainer.WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.keysizefromciphermap", "true"));
        SERVLET_PATH_FOR_DEFAULT_MAPPING = Boolean.valueOf(WCCustomProperties.SERVLET_PATH_FOR_DEFAULT_MAPPING);
        MAX_PART_HEADER_SIZE = WCCustomProperties.MAX_PART_HEADER_SIZE;
    }

    private class SRTServletRequestHelper
    implements Cloneable {
        Hashtable _privateAttributes = null;
        Map _attributes = new HashMap();
        boolean _cookiesParsed = false;
        String _updatedSessionId;
        Object _sessionAffinityContext;
        Cookie[] _cookies;
        boolean _localesProcessed = false;
        String _readerEncoding = null;
        String _readerEncodingInvalidIgnored = null;
        String _characterEncoding = null;
        boolean _gotReader = false;
        boolean _gotInputStream = false;
        boolean _InputStreamClosed = false;
        String _method = null;
        boolean _parametersRead = false;
        DispatcherType dispatcherType = DispatcherType.REQUEST;
        String _requestID = null;
        Object _servletConnection = null;
        BufferedReader _reader = null;
        LinkedList _locales = null;
        boolean asyncSupported = true;
        AsyncContext asyncContext;
        boolean multipartRequestInputStreamRead = false;
        Exception multipartException = null;
        boolean multipartISEException = false;
        LinkedHashMap<String, ArrayList<Part>> multipartPartsHashMap = null;
        boolean asyncStarted = false;
        List<String> resourcesNotSupportAsync = null;

        private SRTServletRequestHelper() {
        }

        protected Object clone() throws CloneNotSupportedException {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, SRTServletRequest.CLASS_NAME, "clone", "SRTRequestHelper.clone entry");
            }
            SRTServletRequestHelper _clonedHelper = null;
            _clonedHelper = (SRTServletRequestHelper)super.clone();
            if (this._privateAttributes != null) {
                _clonedHelper._privateAttributes = (Hashtable)this._privateAttributes.clone();
            }
            if (this._attributes != null) {
                _clonedHelper._attributes = (HashMap)((HashMap)this._attributes).clone();
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, SRTServletRequest.CLASS_NAME, "clone", "SRTRequestHelper.clone original -->" + this + " cloned -->" + _clonedHelper);
            }
            return _clonedHelper;
        }
    }

    class QSListItem {
        String _qs = null;
        Hashtable _qsHashtable = null;

        QSListItem(String qs, Hashtable qsHashtable) {
            this._qs = qs;
            this._qsHashtable = qsHashtable;
        }
    }
}

