/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.FFDCClassAdapter;
import com.ibm.ws.ras.instrument.internal.bci.InstrumentationException;
import com.ibm.ws.ras.instrument.internal.introspect.FFDCIgnoreAnnotationVisitor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class FFDCMethodAdapter
extends AbstractRasMethodAdapter<FFDCClassAdapter> {
    public static final Type FFDC_FILTER_TYPE = Type.getObjectType((String)"com/ibm/ws/ffdc/FFDCFilter");
    private final String descriptor;
    private Set<Type> ignoredExceptionTypes = null;
    private Set<Type> visitedIgnoredExceptionTypes = null;
    private String unresolvedCompilationErrors;
    FFDCIgnoreAnnotationVisitor ignoreAnnotationVisitor;

    public FFDCMethodAdapter(FFDCClassAdapter classAdapter, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(classAdapter, false, visitor, access, methodName, descriptor, signature, exceptions);
        this.descriptor = descriptor;
        if (this.getMethodInfo() != null) {
            this.ignoredExceptionTypes = this.getMethodInfo().getFFDCIgnoreExceptions();
        }
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(desc, visible);
        if (FFDCIgnoreAnnotationVisitor.FFDC_IGNORE_TYPE.getDescriptor().equals(desc)) {
            this.ignoreAnnotationVisitor = new FFDCIgnoreAnnotationVisitor(av);
            av = this.ignoreAnnotationVisitor;
        }
        return av;
    }

    @Override
    protected boolean isMethodInstrumentedByThisAdapter() {
        return super.isMethodInstrumentedByThisAdapter() || ((FFDCClassAdapter)this.getClassAdapter()).isClassInstrumentedByThisAdapter();
    }

    @Override
    public void initializeTraceObjectField() {
    }

    @Override
    public boolean onMethodEntry() {
        return false;
    }

    @Override
    public boolean onMethodReturn() {
        return false;
    }

    @Override
    public void visitLdcInsn(Object constant) {
        String string;
        if (constant instanceof String && (string = (String)constant).startsWith("Unresolved compilation problem")) {
            this.unresolvedCompilationErrors = string;
        }
        super.visitLdcInsn(constant);
    }

    private Set<Type> getIgnoredExceptionTypes() {
        if (this.ignoredExceptionTypes != null) {
            return this.ignoredExceptionTypes;
        }
        if (this.ignoreAnnotationVisitor != null) {
            return this.ignoreAnnotationVisitor.getIgnoredExceptionTypes();
        }
        return Collections.emptySet();
    }

    private boolean isExceptionTypeIgnored(Type exceptionType) {
        return this.getIgnoredExceptionTypes().contains(exceptionType);
    }

    @Override
    public boolean onExceptionHandlerEntry(Type exceptionType, int var) {
        if (this.isExceptionTypeIgnored(exceptionType)) {
            if (this.visitedIgnoredExceptionTypes == null) {
                this.visitedIgnoredExceptionTypes = new LinkedHashSet<Type>();
            }
            this.visitedIgnoredExceptionTypes.add(exceptionType);
        } else if (!this.isMethodInstrumentedByThisAdapter()) {
            this.insertFFDC(var);
            return true;
        }
        return false;
    }

    @Override
    public boolean onThrowInstruction() {
        if (((FFDCClassAdapter)this.getClassAdapter()).isCallFFDCOnThrow()) {
            this.insertFFDC(-1);
            return true;
        }
        return false;
    }

    private void insertFFDC(int var) {
        if (var == -1) {
            this.visitInsn(89);
        } else {
            this.visitVarInsn(25, var);
        }
        this.visitLoadClassName();
        this.visitLdcInsn(Integer.toString(this.getLineNumber()));
        if (!this.isStatic()) {
            this.visitVarInsn(25, 0);
        } else {
            this.visitInsn(1);
        }
        this.createTraceArrayForParameters();
        this.visitMethodInsn(184, FFDC_FILTER_TYPE.getInternalName(), "processException", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Throwable.class), Type.getType(String.class), Type.getType(String.class), Type.getType(Object.class), Type.getType(Object[].class)}), false);
    }

    public void visitEnd() {
        super.visitEnd();
        Set<Type> expected = this.getIgnoredExceptionTypes();
        if (expected != null) {
            Set<Object> actual = this.visitedIgnoredExceptionTypes;
            if (actual == null) {
                actual = Collections.emptySet();
            }
            LinkedHashSet<Type> unnecessary = new LinkedHashSet<Type>(expected);
            unnecessary.removeAll(actual);
            if (!unnecessary.isEmpty()) {
                if (this.unresolvedCompilationErrors != null) {
                    throw new InstrumentationException("[Eclipse] " + this.unresolvedCompilationErrors + "If you haven't changed this class, consider cleaning and rebuilding.\nIf that doesn't help, investigate why Eclipse fails to compile the class.");
                }
                throw new InstrumentationException("unnecessary @FFDCIgnore specified on " + this.getMethodName() + this.descriptor + " for " + unnecessary);
            }
        }
    }
}

