/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASIdentityToken;
import com.ibm.ws.transport.iiop.security.util.Util;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CSI.IdentityToken;
import org.omg.IOP.Codec;

@TraceOptions(traceGroup="CSIv2", messageBundle="com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages")
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientSASITTX509CertChain
implements CSSSASIdentityToken {
    private final String oid;
    private final String domain;
    private final String realm;
    private static TraceComponent tc = Tr.register(ClientSASITTX509CertChain.class, (String)"CSIv2", (String)"com.ibm.ws.security.csiv2.server.internal.resources.CSIv2ServerContainerMessages");
    static final long serialVersionUID = -6170584282866501480L;

    public ClientSASITTX509CertChain(String oid, Class principalClass, String domain, String realm) {
        this.oid = oid == null ? "oid:2.23.130.1.1.1".substring(4) : oid;
        this.domain = domain;
        this.realm = realm;
    }

    public ClientSASITTX509CertChain(String oid, String domain) {
        this.oid = oid == null ? "oid:2.23.130.1.1.1".substring(4) : oid;
        this.domain = domain;
        this.realm = domain;
    }

    /*
     * WARNING - void declaration
     */
    public IdentityToken encodeIdentityToken(Codec codec) {
        IdentityToken token = null;
        SubjectManager subjectManager = new SubjectManager();
        Subject subject = subjectManager.getInvocationSubject();
        if (subject == null) {
            subject = subjectManager.getCallerSubject();
        }
        SubjectHelper subjectHelper = new SubjectHelper();
        WSCredential wsCredential = subjectHelper.getWSCredential(subject);
        try {
            String identityTypeValue = (String)wsCredential.get("wssecurity.identity_name");
            boolean isITTCert = "ClientCertificate".equalsIgnoreCase(identityTypeValue);
            X509Certificate[] certificateChain = (X509Certificate[])wsCredential.get("wssecurity.identity_value");
            if (!isITTCert || certificateChain == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Certificate is not available to continue with Identity Assertion. identityTypeValue=" + identityTypeValue), (Object[])new Object[0]);
                }
                String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_CLIENT_ASSERTION_CERTIFICATE_INVALID", (Object[])new Object[0]);
                throw new Exception(messageFromBundle);
            }
            token = new IdentityToken();
            byte[] encodedCertificateChain = Util.encodeCertChain((Codec)codec, (X509Certificate[])certificateChain);
            token.certificate_chain(encodedCertificateChain);
        }
        catch (Exception identityTypeValue) {
            void e;
            FFDCFilter.processException((Throwable)identityTypeValue, (String)"com.ibm.ws.security.csiv2.server.config.css.ClientSASITTX509CertChain", (String)"114", (Object)this, (Object[])new Object[]{codec});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The client cannot create the ITTX509CertChain identity assertion token. The exception message is: " + e.getMessage()), (Object[])new Object[0]);
            }
            String messageFromBundle = Tr.formatMessage((TraceComponent)tc, (String)"CSIv2_CLIENT_ASSERTION_CANNOT_ENCODE_CC", (Object[])new Object[]{e.getMessage()});
            throw new NO_PERMISSION(messageFromBundle, 1229066386, CompletionStatus.COMPLETED_NO);
        }
        return token;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("ClientSASITTX509CertChain: [\n");
        buf.append(moreSpaces).append("oid: ").append(this.oid).append("\n");
        buf.append(moreSpaces).append("domain: ").append(this.domain).append("\n");
        buf.append(moreSpaces).append("realm: ").append(this.realm).append("\n");
        buf.append(spaces).append("]\n");
    }

    public int getType() {
        return 4;
    }
}

