/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Set;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PUnitEMBuilder
extends EntityManagerBuilder {
    private static final TraceComponent tc = Tr.register(PUnitEMBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final EntityManagerFactory emf;
    static final long serialVersionUID = -3988171077751568975L;

    public PUnitEMBuilder(DataProvider provider, ClassLoader repositoryClassLoader, Set<Class<?>> repositoryInterfaces, EntityManagerFactory emf, String persistenceUnitRef, ComponentMetaData metadata, Set<Class<?>> entityTypes) throws Exception {
        super(provider, repositoryClassLoader, repositoryInterfaces, persistenceUnitRef);
        this.emf = emf;
        this.collectEntityInfo(entityTypes, null);
    }

    @Override
    @Trivial
    public EntityManager createEntityManager() {
        EntityManager em = this.emf.createEntityManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("createEntityManager: " + String.valueOf(em)), (Object[])new Object[0]);
        }
        return em;
    }

    @Override
    @FFDCIgnore(value={PersistenceException.class})
    public DataSource getDataSource(Method repoMethod, Class<?> repoInterface) {
        try {
            return (DataSource)this.emf.unwrap(DataSource.class);
        }
        catch (PersistenceException x) {
            try {
                EntityManager em = this.emf.createEntityManager();
                return (DataSource)em.unwrap(DataSource.class);
            }
            catch (PersistenceException xx) {
                throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1063.unsupported.resource", repoMethod.getName(), repoInterface.getName(), repoMethod.getReturnType().getName(), DataSource.class.getName());
            }
        }
    }

    @Override
    @Trivial
    public void introspect(PrintWriter writer, String indent) {
        super.introspect(writer, indent);
        writer.println(indent + "  EntityManagerFactory: " + String.valueOf(this.emf));
    }

    @Trivial
    public String toString() {
        return new StringBuilder(27 + this.dataStore.length()).append("PUnitEMBuilder@").append(Integer.toHexString(this.hashCode())).append(":").append(this.dataStore).toString();
    }
}

