/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.checkpoint.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerReadyStatus;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.TimestampUtils;
import io.openliberty.checkpoint.internal.CheckpointTransformer;
import io.openliberty.checkpoint.internal.criu.CheckpointFailedException;
import io.openliberty.checkpoint.internal.criu.ExecuteCRIU;
import io.openliberty.checkpoint.internal.openj9.J9CRIUSupport;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.condition.Condition;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(property={"service.ranking:Integer=-10000"}, immediate=true)
public class CheckpointImpl
implements ServerReadyStatus {
    private static final String INSTANTON_ENABLED_HEADER = "WLP-InstantOn-Enabled";
    private static final String CHECKPOINT_STUB_CRIU = "io.openliberty.checkpoint.stub.criu";
    private static final String CHECKPOINT_CRIU_UNPRIVILEGED = "io.openliberty.checkpoint.criu.unprivileged";
    private static final String CHECKPOINT_ALLOWED_FEATURES = "io.openliberty.checkpoint.allowed.features";
    private static final String CHECKPOINT_FORCE_FAIL_TYPE = "io.openliberty.checkpoint.fail.type";
    private static final String CHECKPOINT_ALLOWED_FEATURES_ALL = "ALL_FEATURES";
    static final String CHECKPOINT_PAUSE_RESTORE = "io.openliberty.checkpoint.pause.restore";
    private static final String DIR_CHECKPOINT = "checkpoint/";
    private static final String FILE_RESTORE_MARKER = "checkpoint/.restoreMarker";
    private static final String FILE_RESTORE_FAILED_MARKER = "checkpoint/.restoreFailedMarker";
    private static final String FILE_ENV_PROPERTIES = "checkpoint/.env.properties";
    private static final String DIR_CHECKPOINT_IMAGE = "checkpoint/image/";
    private static final String CHECKPOINT_LOG_FILE = "checkpoint.log";
    private static final TraceComponent tc = Tr.register(CheckpointImpl.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
    private final Set<String> allowedFeatures;
    private final ComponentContext cc;
    private final CheckpointPhase checkpointAt;
    private final WsLocationAdmin locAdmin;
    private final AtomicBoolean checkpointCalled = new AtomicBoolean(false);
    private final ServiceRegistration<ClassFileTransformer> transformerReg;
    private final AtomicBoolean jvmRestore = new AtomicBoolean(false);
    private final ExecuteCRIU criu;
    private final long pauseRestore;
    private final CheckpointFailedException forceFail;
    private final List<CheckpointHookService> hooksMultiThreaded = Collections.synchronizedList(new ArrayList());
    private final List<CheckpointHookService> hooksSingleThreaded = Collections.synchronizedList(new ArrayList());
    private final Field checkpointPhaseRestored;
    private final Method checkpointPhaseblockAddHooks;
    private static volatile CheckpointImpl INSTANCE = null;
    static final long serialVersionUID = 2417318242443658985L;

    @Activate
    public CheckpointImpl(ComponentContext cc, @Reference WsLocationAdmin locAdmin, @Reference(target="(!(io.openliberty.checkpoint=INACTIVE))") CheckpointPhase phase) {
        this(cc, null, locAdmin, phase);
    }

    /*
     * WARNING - void declaration
     */
    CheckpointImpl(ComponentContext cc, ExecuteCRIU criu, WsLocationAdmin locAdmin, CheckpointPhase phase) {
        this.cc = cc;
        this.allowedFeatures = CheckpointImpl.getAllowedFeatures(cc);
        this.criu = Boolean.valueOf(cc.getBundleContext().getProperty(CHECKPOINT_STUB_CRIU)) != false ? new ExecuteCRIU(){
            static final long serialVersionUID = -8758089940751541600L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void dump(Runnable prepare, Runnable restore, File imageDir, String logFileName, File workDir, File envProps, boolean unprivileged) throws CheckpointFailedException {
                prepare.run();
                restore.run();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointImpl$1", 1.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
            }
        } : (criu == null ? J9CRIUSupport.create(this) : criu);
        this.locAdmin = locAdmin;
        this.checkpointAt = phase;
        this.pauseRestore = this.getPauseTime(cc.getBundleContext().getProperty(CHECKPOINT_PAUSE_RESTORE));
        this.forceFail = this.getForceFailCheckpointCode(cc.getBundleContext().getProperty(CHECKPOINT_FORCE_FAIL_TYPE));
        try {
            this.checkpointPhaseblockAddHooks = CheckpointPhase.class.getDeclaredMethod("blockAddHooks", new Class[0]);
            this.checkpointPhaseblockAddHooks.setAccessible(true);
            this.checkpointPhaseRestored = CheckpointPhase.class.getDeclaredField("restored");
            this.checkpointPhaseRestored.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            void e;
            FFDCFilter.processException((Throwable)reflectiveOperationException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"199", (Object)this, (Object[])new Object[]{cc, criu, locAdmin, phase});
            throw new RuntimeException((Throwable)e);
        }
        INSTANCE = this;
        this.transformerReg = this.checkpointAt == CheckpointPhase.BEFORE_APP_START ? cc.getBundleContext().registerService(ClassFileTransformer.class, (Object)new CheckpointTransformer(), FrameworkUtil.asDictionary(Collections.singletonMap("io.openliberty.classloading.system.transformer", true))) : null;
    }

    @Reference(service=CheckpointHook.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, unbind="removeHook")
    void addHook(CheckpointHook hook, ServiceReference<CheckpointHook> hookRef) {
        CheckpointHookService hookService = new CheckpointHookService(hook, hookRef);
        boolean isMultiThreaded = this.isMultiThreaded(hookRef);
        CheckpointImpl.debug(tc, () -> "Adding " + (isMultiThreaded ? "multi-threaded" : "single-threaded") + "hook: " + hookService);
        if (isMultiThreaded) {
            this.hooksMultiThreaded.add(hookService);
        } else {
            this.hooksSingleThreaded.add(hookService);
        }
    }

    void removeHook(ServiceReference<CheckpointHook> hookRef) {
        boolean isMultiThreaded = this.isMultiThreaded(hookRef);
        CheckpointImpl.debug(tc, () -> "Removing " + (isMultiThreaded ? "multi-threaded" : "single-threaded") + "hook: " + hookRef);
        if (isMultiThreaded) {
            this.hooksMultiThreaded.removeIf(h -> h.isHookReference(hookRef));
        } else {
            this.hooksSingleThreaded.removeIf(h -> h.isHookReference(hookRef));
        }
    }

    private boolean isMultiThreaded(ServiceReference<CheckpointHook> hookRef) {
        Object multiThreaded = hookRef.getProperty("io.openliberty.checkpoint.hook.multi.threaded");
        return Boolean.TRUE.equals(multiThreaded);
    }

    private CheckpointFailedException getForceFailCheckpointCode(String property) {
        if (property == null) {
            return null;
        }
        CheckpointFailedException.Type type = CheckpointFailedException.Type.valueOf(property);
        return new CheckpointFailedException(type, "TESTING FAILURE", null);
    }

    private long getPauseTime(String pauseRestoreTime) {
        if (pauseRestoreTime == null) {
            return 0L;
        }
        try {
            long result = Long.parseLong(pauseRestoreTime);
            return result < 0L ? 0L : result;
        }
        catch (NumberFormatException result) {
            FFDCFilter.processException((Throwable)result, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"261", (Object)this, (Object[])new Object[]{pauseRestoreTime});
            return 0L;
        }
    }

    private static Set<String> getAllowedFeatures(ComponentContext cc) {
        String allowedProp = cc.getBundleContext().getProperty(CHECKPOINT_ALLOWED_FEATURES);
        if (allowedProp == null) {
            return Collections.emptySet();
        }
        String[] allowedFeatures = allowedProp.split(",");
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(allowedFeatures)));
    }

    @Deactivate
    void deactivate() {
        if (INSTANCE == this) {
            INSTANCE = null;
        }
    }

    public void check() {
        CheckpointImpl.debug(tc, () -> "Initiating checkpoint from server ready event.");
        this.checkpointOrExitOnFailure();
    }

    @FFDCIgnore(value={CheckpointFailedException.class})
    void checkpointOrExitOnFailure() {
        try {
            this.checkpoint();
        }
        catch (CheckpointFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"checkpointOrExitOnFailure", (Object)this);
            if (e.isRestore()) {
                this.createRestoreFailedMarker(e);
            }
            Tr.error((TraceComponent)tc, (String)e.getErrorMsgKey(), (Object[])new Object[]{e.getMessage()});
            new Thread(() -> System.exit(e.getErrorCode()), e.isRestore() ? "Restore failed, exiting..." : "Checkpoint failed, exiting...").start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IllegalStateException.class, Throwable.class, CheckpointFailedException.class})
    void checkpoint() throws CheckpointFailedException {
        String phaseName;
        CheckpointImpl.debug(tc, () -> "Checkpoint for : " + this.checkpointAt);
        if (this.checkpointCalledAlready()) {
            CheckpointImpl.debug(tc, () -> "Trying to checkpoint a second time" + this.checkpointAt);
            return;
        }
        if (this.transformerReg != null) {
            try {
                this.transformerReg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.checkSupportedFeatures();
        try {
            this.checkpointPhaseblockAddHooks.invoke((Object)this.checkpointAt, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"342", (Object)this, (Object[])new Object[0]);
            throw new CheckpointFailedException(this.getUnknownType(), "Failed to call blockAddHooks.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"344", (Object)this, (Object[])new Object[0]);
            throw new CheckpointFailedException(this.getUnknownType(), "Failed to call blockAddHooks.", e.getTargetException());
        }
        List<CheckpointHookService> multiThreadRestoreHooks = this.getHooks(this.hooksMultiThreaded);
        List<CheckpointHookService> singleThreadRestoreHooks = this.getHooks(this.hooksSingleThreaded);
        ArrayList<CheckpointHookService> multiThreadPrepareHooks = new ArrayList<CheckpointHookService>(multiThreadRestoreHooks);
        Collections.reverse(multiThreadPrepareHooks);
        ArrayList<CheckpointHookService> singleThreadPrepareHooks = new ArrayList<CheckpointHookService>(singleThreadRestoreHooks);
        Collections.reverse(singleThreadPrepareHooks);
        CheckpointImpl.debug(tc, () -> "Multi-threaded prepare order: " + multiThreadPrepareHooks);
        CheckpointImpl.debug(tc, () -> "Single-threaded prepare order: " + singleThreadPrepareHooks);
        CheckpointImpl.debug(tc, () -> "Multi-threaded restore order: " + multiThreadRestoreHooks);
        CheckpointImpl.debug(tc, () -> "Single-threaded restore order: " + singleThreadRestoreHooks);
        switch (this.checkpointAt) {
            case AFTER_APP_START: {
                phaseName = "afterAppStart";
                break;
            }
            case BEFORE_APP_START: {
                phaseName = "beforeAppStart";
                break;
            }
            default: {
                phaseName = this.checkpointAt.name();
            }
        }
        Tr.audit((TraceComponent)tc, (String)"CHECKPOINT_DUMP_INITIATED_CWWKC0451", (Object[])new Object[]{phaseName});
        if (this.forceFail != null && !this.forceFail.isRestore()) {
            throw (CheckpointFailedException)this.forceFail.fillInStackTrace();
        }
        try {
            this.prepare(multiThreadPrepareHooks);
            try {
                this.criu.checkpointSupported();
            }
            catch (CheckpointFailedException cpfe) {
                CheckpointImpl.debug(tc, () -> "ExecuteCRIU service does not support checkpoint: " + cpfe.getMessage());
                throw cpfe;
            }
            boolean unprivileged = Boolean.valueOf(this.cc.getBundleContext().getProperty(CHECKPOINT_CRIU_UNPRIVILEGED));
            File imageDir = this.getImageDir();
            CheckpointImpl.debug(tc, () -> "criu attempt dump to '" + imageDir + "' and exit process.");
            this.criu.dump(() -> this.prepare(singleThreadPrepareHooks), () -> this.restore(singleThreadRestoreHooks), imageDir, CHECKPOINT_LOG_FILE, this.getLogsCheckpoint(), this.getEnvProperties(), unprivileged);
            CheckpointImpl.debug(tc, () -> "criu dumped to " + imageDir + ", now in recovered process.");
            if (this.forceFail != null && this.forceFail.isRestore()) {
                throw (CheckpointFailedException)this.forceFail.fillInStackTrace();
            }
            if (this.pauseRestore > 0L) {
                try {
                    Thread.sleep(this.pauseRestore);
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"409", (Object)this, (Object[])new Object[0]);
                    Thread.currentThread().isInterrupted();
                }
            }
            this.restore(multiThreadRestoreHooks);
        }
        catch (Throwable e) {
            CheckpointFailedException rethrow = e instanceof CheckpointFailedException ? (CheckpointFailedException)e : new CheckpointFailedException(this.getUnknownType(), Tr.formatMessage((TraceComponent)tc, (String)"UKNOWN_FAILURE_CWWKC0455E", (Object[])new Object[]{e.getMessage()}), e);
            if (!rethrow.isRestore()) {
                this.callHooksOnFailure(singleThreadRestoreHooks, multiThreadRestoreHooks);
            }
            throw rethrow;
        }
        this.registerRunningCondition();
        Tr.audit((TraceComponent)tc, (String)"CHECKPOINT_RESTORE_CWWKC0452I", (Object[])new Object[]{TimestampUtils.getElapsedTime()});
        this.createRestoreMarker();
    }

    private void callHooksOnFailure(List<CheckpointHookService> singleThreadRestoreHooks, List<CheckpointHookService> multiThreadRestoreHooks) {
        this.callHooks("checkpointFailed", singleThreadRestoreHooks, CheckpointHook::checkpointFailed, null);
        this.callHooks("checkpointFailed", multiThreadRestoreHooks, CheckpointHook::checkpointFailed, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void checkSupportedFeatures() {
        if (this.allowedFeatures.contains(CHECKPOINT_ALLOWED_FEATURES_ALL)) {
            return;
        }
        BundleContext context = this.cc.getBundleContext();
        if (context == null) {
            return;
        }
        try {
            ServiceReference[] features = context.getServiceReferences("com.ibm.wsspi.kernel.feature.LibertyFeature", null);
            if (features != null) {
                ArrayList<Object> unsupported = new ArrayList<Object>(0);
                for (ServiceReference feature : features) {
                    Object featureName = feature.getProperty("ibm.featureName");
                    LibertyFeature libertyFeature = (LibertyFeature)context.getService(feature);
                    if (libertyFeature == null) continue;
                    try {
                        ManifestElement[] instantonEnabled = ManifestElement.parseHeader((String)INSTANTON_ENABLED_HEADER, (String)libertyFeature.getHeader(INSTANTON_ENABLED_HEADER));
                        if (this.isInstantOnFeature(instantonEnabled, featureName)) continue;
                        unsupported.add(featureName);
                    }
                    catch (BundleException instantonEnabled) {
                        FFDCFilter.processException((Throwable)instantonEnabled, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"466", (Object)this, (Object[])new Object[0]);
                        unsupported.add(featureName);
                    }
                    finally {
                        context.ungetService(feature);
                    }
                }
                if (!unsupported.isEmpty()) {
                    throw new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_PREPARE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"CHECKPOINT_FAILED_UNSUPPORTED_FEATURE_CWWKC0456E", (Object[])new Object[]{unsupported}), null);
                }
            }
        }
        catch (InvalidSyntaxException features) {
            void e;
            FFDCFilter.processException((Throwable)features, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"479", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
    }

    private boolean isInstantOnFeature(ManifestElement[] instantonEnabledHeader, Object featureName) {
        if (this.allowedFeatures.contains(featureName)) {
            return true;
        }
        if (instantonEnabledHeader != null && instantonEnabledHeader.length > 0 && Boolean.parseBoolean(instantonEnabledHeader[0].getValue())) {
            String type = instantonEnabledHeader[0].getDirective("type");
            if ("beta".equals(type)) {
                return ProductInfo.getBetaEdition();
            }
            return true;
        }
        return false;
    }

    public CheckpointFailedException.Type getUnknownType() {
        return this.getEnvProperties().exists() ? CheckpointFailedException.Type.UNKNOWN_RESTORE : CheckpointFailedException.Type.UNKNOWN_CHECKPOINT;
    }

    public String getMessage(String msgKey, Object ... args) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])args);
    }

    private void registerRunningCondition() {
        BundleContext bc = this.cc.getBundleContext();
        Hashtable<String, String> conditionProps = new Hashtable<String, String>();
        conditionProps.put("osgi.condition.id", "io.openliberty.process.running");
        conditionProps.put("io.openliberty.checkpoint", (String)this.checkpointAt);
        bc.registerService(Condition.class, (Object)Condition.INSTANCE, conditionProps);
    }

    private File getImageDir() {
        File imageDir = this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/image/").asFile();
        imageDir.mkdirs();
        return imageDir;
    }

    private File getLogsCheckpoint() {
        WsResource logsCheckpoint = this.locAdmin.resolveResource("${server.logs.dir}/checkpoint/");
        logsCheckpoint.create();
        return logsCheckpoint.asFile();
    }

    private void createRestoreMarker() {
        this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.restoreMarker").create();
    }

    private void createRestoreFailedMarker(CheckpointFailedException e) {
        WsResource failedMarker = this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.restoreFailedMarker");
        try {
            PrintStream ps = new PrintStream(failedMarker.putStream());
            try {
                ps.print(String.valueOf(e.getErrorCode()));
                ps.close();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"541", (Object)this, (Object[])new Object[]{e});
                try {
                    ps.close();
                }
                catch (Throwable throwable2) {
                    FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"541", (Object)this, (Object[])new Object[]{e});
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"543", (Object)this, (Object[])new Object[]{e});
        }
    }

    private File getEnvProperties() {
        return this.locAdmin.resolveResource("${server.workarea.dir}/checkpoint/.env.properties").asFile();
    }

    List<CheckpointHookService> getHooks(List<CheckpointHookService> hookServices) {
        if (hookServices.isEmpty()) {
            CheckpointImpl.debug(tc, () -> "No checkpoint hooks.");
            return Collections.emptyList();
        }
        ArrayList<CheckpointHookService> sortedHooks = new ArrayList<CheckpointHookService>(hookServices.size());
        hookServices.forEach(h -> sortedHooks.add((CheckpointHookService)h));
        Collections.sort(sortedHooks);
        return sortedHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @FFDCIgnore(value={Throwable.class})
    private void callHooks(String operation, List<CheckpointHookService> checkpointHooks, Consumer<CheckpointHook> perform, Function<Throwable, CheckpointFailedException> failed) throws CheckpointFailedException {
        for (CheckpointHookService checkpointHookService : checkpointHooks) {
            try {
                CheckpointImpl.debug(tc, () -> "Calling " + operation + " operation on hook: " + checkpointHookService);
                perform.accept(checkpointHookService.hook);
            }
            catch (Throwable abortCause) {
                CheckpointImpl.debug(tc, () -> operation + " failed on hook: " + checkpointHookService);
                if (failed == null) continue;
                throw failed.apply(abortCause);
            }
            finally {
                CheckpointImpl.debug(tc, () -> "Finished " + operation + " operation on hook: " + checkpointHookService);
            }
        }
    }

    @Trivial
    private void prepare(List<CheckpointHookService> checkpointHooks) throws CheckpointFailedException {
        CheckpointImpl.debug(tc, () -> "Calling prepare hooks on this list: " + checkpointHooks);
        this.callHooks("prepare", checkpointHooks, CheckpointHook::prepare, CheckpointImpl::failedPrepare);
    }

    private static CheckpointFailedException failedPrepare(Throwable cause) {
        return new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_PREPARE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"CHECKPOINT_FAILED_PREPARE_EXCEPTION_CWWKC0457E", (Object[])new Object[]{cause.getMessage()}), cause);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private void restore(List<CheckpointHookService> checkpointHooks) throws CheckpointFailedException {
        if (this.jvmRestore.compareAndSet(false, true)) {
            try {
                this.checkpointPhaseRestored.set(this.checkpointAt, Boolean.TRUE);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.checkpoint.internal.CheckpointImpl", (String)"606", (Object)this, (Object[])new Object[]{checkpointHooks});
                throw new CheckpointFailedException(this.getUnknownType(), "Failed to set restored flag on CheckpointPhase", (Throwable)e);
            }
        }
        CheckpointImpl.debug(tc, () -> "Calling restore hooks on this list: " + checkpointHooks);
        this.callHooks("restore", checkpointHooks, CheckpointHook::restore, CheckpointImpl::failedRestore);
    }

    private static CheckpointFailedException failedRestore(Throwable cause) {
        return new CheckpointFailedException(CheckpointFailedException.Type.LIBERTY_RESTORE_FAILED, Tr.formatMessage((TraceComponent)tc, (String)"RESTORE_FAILED_RESTORE_EXCEPTION_CWWKC0458E", (Object[])new Object[]{cause.getMessage()}), cause);
    }

    boolean checkpointCalledAlready() {
        return !this.checkpointCalled.compareAndSet(false, true);
    }

    void resetCheckpointCalled() {
        this.checkpointCalled.set(false);
    }

    public static void beforeAppStartCheckpoint() {
        CheckpointImpl current = INSTANCE;
        CheckpointImpl.debug(tc, () -> "Initiating checkpoint from beforeAppStart: " + current);
        if (current != null && current.checkpointAt == CheckpointPhase.BEFORE_APP_START) {
            current.checkpointOrExitOnFailure();
        }
    }

    @Trivial
    static void debug(TraceComponent trace, Supplier<String> message) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            Tr.debug((TraceComponent)trace, (String)message.get(), (Object[])new Object[0]);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class CheckpointHookService
    implements Comparable<CheckpointHookService> {
        final CheckpointHook hook;
        private final ServiceReference<CheckpointHook> hookRef;
        private final boolean isCracHooks;
        static final long serialVersionUID = -6718156205070584840L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public CheckpointHookService(CheckpointHook hook, ServiceReference<CheckpointHook> hookRef) {
            this.hook = hook;
            this.hookRef = hookRef;
            this.isCracHooks = this.isCracHooks(hookRef);
        }

        @Override
        @Trivial
        public int compareTo(CheckpointHookService o) {
            if (this.isCracHooks == o.isCracHooks) {
                return this.hookRef.compareTo(o.hookRef);
            }
            return this.isCracHooks ? 1 : -1;
        }

        boolean isCracHooks(ServiceReference<CheckpointHook> hookRef) {
            Boolean isCracHooks = (Boolean)hookRef.getProperty("io.openliberty.crac.hooks");
            if (isCracHooks != null && isCracHooks.booleanValue()) {
                CheckpointImpl.debug(tc, () -> "Found CRaC hook:" + hookRef);
                return true;
            }
            return false;
        }

        @Trivial
        boolean isHookReference(ServiceReference<CheckpointHook> oHookRef) {
            return this.hookRef.getProperty("service.id").equals(oHookRef.getProperty("service.id"));
        }

        @Trivial
        public String toString() {
            return this.hook.toString() + ": " + this.hookRef.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.checkpoint.internal.CheckpointImpl$CheckpointHookService", CheckpointHookService.class, (String)"checkpoint", (String)"io.openliberty.checkpoint.resources.CheckpointMessages");
        }
    }
}

