/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.channelfw.base;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;

public abstract class InboundApplicationLink
implements ConnectionLink {
    private static final TraceComponent tc = Tr.register(InboundApplicationLink.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private ConnectionLink linkOnDeviceSide = null;
    private ConnectionReadyCallback linkOnApplicationSide = null;
    protected VirtualConnection vc = null;

    @Override
    public VirtualConnection getVirtualConnection() {
        return this.vc;
    }

    @Override
    public void setDeviceLink(ConnectionLink next) {
        this.linkOnDeviceSide = next;
    }

    @Override
    public void setApplicationCallback(ConnectionReadyCallback next) {
        this.linkOnApplicationSide = next;
    }

    @Override
    public ConnectionLink getDeviceLink() {
        return this.linkOnDeviceSide;
    }

    @Override
    public ConnectionReadyCallback getApplicationCallback() {
        return this.linkOnApplicationSide;
    }

    protected void destroy() {
        this.vc = null;
        this.linkOnApplicationSide = null;
        this.linkOnDeviceSide = null;
    }

    public void init(VirtualConnection connection) {
        this.vc = connection;
    }

    @Override
    public void close(VirtualConnection conn, Exception e) {
        ConnectionLink deviceLink = this.getDeviceLink();
        if (deviceLink != null) {
            deviceLink.close(conn, e);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Questionable/redundant call to close, vc=" + conn.hashCode()), (Object[])new Object[0]);
        }
    }

    @Override
    public final Object getChannelAccessor() {
        throw new IllegalStateException("Not implemented and should not be used");
    }
}

