/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.netty.NettyHeaderUtils;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RemoteIpHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final TraceComponent tc = Tr.register(RemoteIpHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final String FOR = "for";
    private static final String BY = "by";
    private static final String PROTO = "proto";
    private static final String HOST = "host";
    private static final String FORWARDED_HEADER = "Forwarded";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_BY = "X-Forwarded-By";
    static final char COLON = ':';
    Pattern proxies;
    Boolean useInAccessLog;
    String forwardedProto;
    String forwardedHost;
    String forwardedPort;
    List<String> forwardedFor = new ArrayList<String>();
    List<String> forwardedBy = new ArrayList<String>();
    boolean noErrors;
    static final long serialVersionUID = -6755769350585674122L;

    public RemoteIpHandler() {
        super(false);
    }

    public RemoteIpHandler(HttpChannelConfig httpConfig) {
        Objects.requireNonNull(httpConfig);
        this.proxies = httpConfig.getForwardedProxiesRegex();
        this.useInAccessLog = httpConfig.useForwardingHeadersInAccessLog();
        this.noErrors = Boolean.TRUE;
    }

    protected void channelRead0(ChannelHandlerContext context, FullHttpRequest request) throws Exception {
        String forwardedHeader = request.headers().get(FORWARDED_HEADER);
        this.forwardedFor = new ArrayList<String>();
        this.forwardedBy = new ArrayList<String>();
        if (!Objects.isNull(forwardedHeader)) {
            this.parseForwarded(request);
        } else {
            this.parseXForwarded(request);
        }
        if (this.noErrors) {
            context.channel().attr(NettyHttpConstants.FORWARDED_HOST_KEY).set((Object)this.forwardedHost);
            context.channel().attr(NettyHttpConstants.FORWARDED_PORT_KEY).set((Object)this.forwardedPort);
            context.channel().attr(NettyHttpConstants.FORWARDED_PROTO_KEY).set((Object)this.forwardedProto);
            context.channel().attr(NettyHttpConstants.FORWARDED_BY_KEY).set((Object)this.forwardedBy.toArray(new String[this.forwardedBy.size()]));
            context.channel().attr(NettyHttpConstants.FORWARDED_FOR_KEY).set((Object)this.forwardedFor.toArray(new String[this.forwardedFor.size()]));
            Tr.debug((TraceComponent)tc, (String)"channelRead0", (Object[])new Object[]{this});
        }
        context.fireChannelRead(ReferenceCountUtil.retain((Object)request, (int)1));
    }

    private void setErrorState() {
        this.forwardedBy = null;
        this.forwardedFor = null;
        this.forwardedHost = null;
        this.forwardedPort = null;
        this.forwardedProto = null;
        this.noErrors = Boolean.FALSE;
    }

    public void resetState() {
        this.forwardedBy = null;
        this.forwardedFor = null;
        this.forwardedHost = null;
        this.forwardedPort = null;
        this.forwardedProto = null;
        this.noErrors = Boolean.TRUE;
    }

    private void parseForwarded(FullHttpRequest request) {
        List values = request.headers().getAll(FORWARDED_HEADER);
        if (Objects.nonNull(values) && !values.isEmpty()) {
            values.forEach(this::processForwardedHeader);
        }
    }

    @ManualTrace
    private void processForwardedHeader(String value) {
        String[] parameters = value.split(";");
        String[] nodes = null;
        String node = null;
        String nodeName = null;
        String nodeExtract = null;
        for (String param : parameters) {
            for (String split : nodes = param.split(",")) {
                node = split.toLowerCase().replaceAll("\\s", "");
                try {
                    nodeName = node.substring(0, node.indexOf("="));
                    nodeExtract = node.substring(node.indexOf("=") + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    FFDCFilter.processException((Throwable)indexOutOfBoundsException, (String)"com.ibm.ws.http.netty.pipeline.RemoteIpHandler", (String)"169", (Object)((Object)this), (Object[])new Object[]{value});
                    this.setErrorState();
                    return;
                }
                switch (nodeName) {
                    case "for": {
                        this.processForwardedAddress(nodeExtract, ListType.FOR);
                        break;
                    }
                    case "by": {
                        this.processForwardedAddress(nodeExtract, ListType.BY);
                        break;
                    }
                    case "proto": {
                        String string = this.forwardedProto = this.isValidProto(nodeExtract) ? nodeExtract : null;
                        if (!Objects.isNull(this.forwardedProto)) break;
                        this.setErrorState();
                        return;
                    }
                    case "host": {
                        String string = this.forwardedHost = this.isValidHost(nodeExtract) ? nodeExtract : null;
                        if (!Objects.isNull(this.forwardedHost)) break;
                        this.setErrorState();
                        return;
                    }
                    default: {
                        this.setErrorState();
                    }
                }
                if (this.noErrors) continue;
                return;
            }
        }
        Tr.exit((TraceComponent)tc, (String)"processForwardedHeader");
    }

    private void processForwardedAddress(String address, ListType type) {
        List<String> list = null;
        if (type == ListType.BY) {
            list = this.forwardedBy;
        }
        if (type == ListType.FOR) {
            list = this.forwardedFor;
        }
        String extract = address.replaceAll("\"", "").trim();
        String nodeName = null;
        int openBracket = extract.indexOf("[");
        int closedBracket = extract.indexOf("]");
        if (openBracket > -1) {
            if (openBracket != 0 || closedBracket <= -1) {
                this.setErrorState();
                return;
            }
            nodeName = extract.substring(openBracket + 1, closedBracket);
            if (type == ListType.FOR && list.isEmpty() && extract.contains("]:")) {
                try {
                    this.forwardedPort = extract.substring(closedBracket + 2);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    FFDCFilter.processException((Throwable)indexOutOfBoundsException, (String)"com.ibm.ws.http.netty.pipeline.RemoteIpHandler", (String)"241", (Object)((Object)this), (Object[])new Object[]{address, type});
                    this.setErrorState();
                    return;
                }
            }
        } else if (extract.contains(":")) {
            int index = extract.indexOf(":");
            nodeName = extract.substring(0, index);
            if (type == ListType.FOR && list.isEmpty()) {
                try {
                    this.forwardedPort = extract.substring(index + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    FFDCFilter.processException((Throwable)indexOutOfBoundsException, (String)"com.ibm.ws.http.netty.pipeline.RemoteIpHandler", (String)"255", (Object)((Object)this), (Object[])new Object[]{address, type});
                    this.setErrorState();
                    return;
                }
            }
        } else {
            nodeName = extract;
        }
        Tr.debug((TraceComponent)tc, (String)("Forwarded address [" + nodeName + "] being tracked in " + type.toString() + " list."), (Object[])new Object[0]);
        list.add(nodeName);
    }

    private void parseXForwarded(FullHttpRequest request) {
        HttpHeaders headers = request.headers();
        List value = headers.getAll(X_FORWARDED_FOR);
        if (Objects.nonNull(value)) {
            value.forEach(this::processXForwardedFor);
        }
        if (Objects.nonNull(value = headers.getAll(X_FORWARDED_BY))) {
            value.forEach(this::processXForwardedBy);
        }
        this.forwardedProto = NettyHeaderUtils.getLast(headers, HttpHeaderKeys.HDR_X_FORWARDED_PROTO.getName());
        this.forwardedHost = NettyHeaderUtils.getLast(headers, HttpHeaderKeys.HDR_X_FORWARDED_HOST.getName());
        this.forwardedPort = NettyHeaderUtils.getLast(headers, HttpHeaderKeys.HDR_X_FORWARDED_PORT.getName());
        this.validateValues();
    }

    @ManualTrace
    private void validateValues() {
        Tr.entry((TraceComponent)tc, (String)"validateValues", (Object[])new Object[0]);
        this.forwardedProto = this.isValidProto(this.forwardedProto) ? this.forwardedProto : null;
        this.forwardedHost = this.isValidHost(this.forwardedHost) ? this.forwardedHost : null;
        Tr.exit((TraceComponent)tc, (String)"validateValues");
    }

    private void processXForwardedAddress(String header, ListType type) {
        String[] addresses;
        for (String address : addresses = header.split(",")) {
            if (type == ListType.BY) {
                this.forwardedBy.add(address.trim());
                continue;
            }
            this.forwardedFor.add(address.trim());
        }
    }

    private void processXForwardedBy(String header) {
        this.processXForwardedAddress(header, ListType.BY);
    }

    private void processXForwardedFor(String header) {
        this.processXForwardedAddress(header, ListType.FOR);
    }

    private boolean isValidHost(String forwardedHost) {
        boolean valid = Boolean.FALSE;
        if (this.noErrors && Objects.nonNull(forwardedHost)) {
            valid = Boolean.TRUE;
            int openBracket = forwardedHost.indexOf("[");
            int closedBracket = forwardedHost.indexOf("]");
            if (openBracket > -1 && (openBracket != 0 || closedBracket <= -1)) {
                valid = Boolean.FALSE;
            }
        }
        return valid;
    }

    @ManualTrace
    private boolean isValidProto(String forwardedProto) {
        Tr.entry((TraceComponent)tc, (String)"validateProto", (Object[])new Object[]{forwardedProto});
        boolean valid = Boolean.FALSE;
        if (this.noErrors && Objects.nonNull(forwardedProto)) {
            valid = Boolean.TRUE;
            char[] a = forwardedProto.toCharArray();
            char c = a[0];
            boolean bl = valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
            if (valid) {
                for (int i = 1; i < a.length; ++i) {
                    c = a[i];
                    boolean bl2 = valid = c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.';
                    if (!valid) break;
                }
            }
        }
        Tr.debug((TraceComponent)tc, (String)("ValidateProto value is valid: " + valid), (Object[])new Object[0]);
        Tr.exit((TraceComponent)tc, (String)"validateProto");
        return valid;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(HOST).append(':').append(this.forwardedHost).append("\n");
        builder.append("port").append(':').append(this.forwardedPort).append("\n");
        builder.append(PROTO).append(':').append(this.forwardedProto).append("\n");
        return builder.toString();
    }

    private static enum ListType {
        FOR,
        BY;

    }
}

