/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer31.async;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webcontainer.srt.SRTServletRequestThreadData;
import com.ibm.ws.webcontainer31.async.ThreadContextManager;
import com.ibm.ws.webcontainer31.osgi.response.WCOutputStream31;
import com.ibm.wsspi.channelfw.InterChannelCallback;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.ee7.HttpOutputStreamEE7;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import jakarta.servlet.WriteListener;
import java.io.IOException;

public class AsyncWriteCallback
implements InterChannelCallback {
    private static final TraceComponent tc = Tr.register(AsyncWriteCallback.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer31.resources.Messages");
    private WriteListener _wl;
    private WCOutputStream31 _out;
    private HttpOutputStreamEE7 _hout = null;
    private ThreadContextManager tcm;
    private SRTServletRequestThreadData _requestDataAsyncWriteCallbackThread;

    public AsyncWriteCallback(WriteListener wl, WCOutputStream31 out, HttpOutputStreamEE7 hout, ThreadContextManager tcm) {
        this._wl = wl;
        this._out = out;
        this._hout = hout;
        this.tcm = tcm;
        this._requestDataAsyncWriteCallbackThread = SRTServletRequestThreadData.getInstance();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AsyncWriteCallback created, " + this._wl + ", hout --> " + this._hout + " ,current thread -->" + Thread.currentThread().getName()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete callback called , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
        }
        HttpOutputStreamEE7 httpOutputStreamEE7 = this._hout;
        synchronized (httpOutputStreamEE7) {
            if (null == vc) {
                return;
            }
            if (this._hout.getExceptionDuringOnWP()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("earlier exception happened, onError was called , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
                }
                this._hout.setExceptionDuringOnWP(false);
                return;
            }
            WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
            reqState.init();
            try {
                this._hout.writeRemainingToBuffers();
            }
            catch (Exception ex) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception during writeRemainingToBuffers : " + ex), (Object[])new Object[0]);
                }
                this.error(vc, ex);
                return;
            }
            if (this._hout.get_internalReady() && this._hout.write_crlf_pending) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ready to write CRLF bytes  , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
                }
                try {
                    reqState.setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
                    reqState.setAttribute("com.ibm.ws.webcontainer.CRLFWriteinPorgress", (Object)true);
                    this._out.writeCRLFIfNeeded();
                }
                catch (IOException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception during write CRLF bytes: " + e), (Object[])new Object[0]);
                    }
                    this._hout.write_crlf_pending = false;
                    this.error(vc, e);
                    return;
                }
            }
            if (!this._hout.get_internalReady()) return;
            Object e = this._hout._writeReadyLockObj;
            synchronized (e) {
                WebContainerRequestState.getInstance((boolean)true).setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
                this._hout.setWriteReady(true);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , status_not_ready_checked -->" + this._hout.status_not_ready_checked), (Object[])new Object[0]);
            }
            if (this._hout.status_not_ready_checked) {
                try {
                    this._hout.status_not_ready_checked = false;
                    SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncWriteCallbackThread);
                    this.tcm.pushContextData();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , call onWritePossible."), (Object[])new Object[0]);
                    }
                    this._wl.onWritePossible();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
                    Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , returned from onWritePossible."), (Object[])new Object[0]);
                }
                catch (Exception ex) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Exception during onWritePossible : " + ex), (Object[])new Object[0]);
                    }
                    this.error(vc, ex);
                }
                finally {
                    this.tcm.popContextData();
                }
            } else {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) return;
                Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , onWritePossible will be skipped as isReady has not been checked since write has gone async"), (Object[])new Object[0]);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error callback called , WriteListener enabled: " + this._wl), (Object[])new Object[0]);
        }
        WebContainerRequestState reqState = WebContainerRequestState.getInstance((boolean)true);
        reqState.init();
        Object object = this._hout._writeReadyLockObj;
        synchronized (object) {
            this._hout.set_internalReady(true);
            this._hout.setWriteReady(true);
            reqState.setAttribute("com.ibm.ws.webcontainer.AllowWriteFromE", (Object)true);
            reqState.setAttribute("com.ibm.ws.webcontainer.WriteAllowedonThisThread", (Object)true);
        }
        SRTServletRequestThreadData.getInstance().init(this._requestDataAsyncWriteCallbackThread);
        this.tcm.pushContextData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , calling user's onError : " + vc), (Object[])new Object[0]);
        }
        try {
            object = this._hout;
            synchronized (object) {
                this._wl.onError(t);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("WriteListener enabled: " + this._wl + " , returned from user's onError : " + vc), (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            Tr.error((TraceComponent)tc, (String)"writeListener.onError.failed", (Object[])new Object[]{this._wl, e.toString()});
        }
        finally {
            this.tcm.popContextData();
            reqState.removeAttribute("com.ibm.ws.webcontainer.AllowWriteFromE");
        }
    }
}

