/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.async;

import com.ibm.ws.webcontainer.async.AsyncListenerEntry;
import com.ibm.ws.webcontainer.async.AsyncListenerEnum;
import com.ibm.ws.webcontainer.async.AsyncServletReentrantLock;
import com.ibm.ws.webcontainer.async.ListenerHelper;
import com.ibm.wsspi.webcontainer.servlet.AsyncContext;
import java.util.List;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TimedObject {
    private static Logger logger = Logger.getLogger("com.ibm.ws.webcontainer.async");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.async.TimedObject";
    private TimerTask task;
    private AsyncContext asyncContext;
    boolean invokedErrorHandling = false;
    private AsyncServletReentrantLock asyncServletReentrantLock;

    public TimedObject(AsyncContext asyncContext, List<AsyncListenerEntry> asyncListenerEntryList) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "<init>", "this->" + this + ", asyncContext->" + asyncContext);
        }
        this.asyncContext = asyncContext;
        this.asyncServletReentrantLock = asyncContext.getErrorHandlingLock();
    }

    public TimerTask getTimerTask() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "getTimerTask");
            logger.exiting(CLASS_NAME, "getTimerTask");
        }
        if (this.task == null) {
            this.task = new EntryTimer();
        }
        return this.task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelTimer() {
        boolean ret = true;
        AsyncContext asyncContext = this.asyncContext;
        synchronized (asyncContext) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.entering(CLASS_NAME, "cancelTimer");
                logger.logp(Level.FINEST, CLASS_NAME, "cancelTimer", "this->" + this + ", timer task->" + this.task + ", invokedErrorHandling->" + this.invokedErrorHandling);
            }
            if (this.task != null) {
                ret = this.task.cancel();
                this.task = null;
            } else {
                ret = !this.invokedErrorHandling;
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            Object[] obj = new Object[]{this.task, ret};
            logger.exiting(CLASS_NAME, "cancelTimer", obj);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExpiredEntry() {
        if (logger.isLoggable(Level.FINEST)) {
            logger.entering(CLASS_NAME, "processExpiredEntry");
            logger.logp(Level.FINEST, CLASS_NAME, "processExpiredEntry", "this->" + this + ", asyncContext->" + this.asyncContext);
        }
        AsyncContext asyncContext = this.asyncContext;
        synchronized (asyncContext) {
            if (this.task != null) {
                this.invokedErrorHandling = true;
                this.task = null;
            }
        }
        if (this.invokedErrorHandling) {
            ListenerHelper.invokeAsyncErrorHandling(this.asyncContext, null, null, AsyncListenerEnum.TIMEOUT, ListenerHelper.ExecuteNextRunnable.TRUE, ListenerHelper.CheckDispatching.TRUE, this.asyncServletReentrantLock);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.exiting(CLASS_NAME, "processExpiredEntry");
        }
    }

    protected class EntryTimer
    extends TimerTask {
        protected EntryTimer() {
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.entering(TimedObject.CLASS_NAME, "run");
            }
            TimedObject.this.processExpiredEntry();
            if (logger.isLoggable(Level.FINEST)) {
                logger.exiting(TimedObject.CLASS_NAME, "run");
            }
        }
    }
}

