/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.concurrent.atomic.AtomicReferenceArray;

class MessageEventListeners
extends AtomicReferenceArray<MessageEventListener> {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(MessageEventListeners.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final long serialVersionUID = 1L;
    int event;

    MessageEventListeners(int event, int maximumEventListeners) {
        super(maximumEventListeners);
        this.event = event;
    }

    void add(MessageEventListener messageEventListener) throws SIErrorException {
        try {
            int index = 0;
            while (!this.compareAndSet(index, null, messageEventListener)) {
                ++index;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String source = "com.ibm.ws.sib.processor.impl.store.items.MessageEventListeners.add";
            String probeId = "1:53:1.250.1.40";
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{source, probeId, this.event}, null));
            FFDCFilter.processException((Throwable)e, (String)source, (String)probeId, (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{source, probeId, this.event});
            throw e;
        }
    }

    void remove(MessageEventListener messageEventListener) {
        for (int index = 0; index < this.length() && !this.compareAndSet(index, messageEventListener, null); ++index) {
        }
    }

    void messageEventOccurred(SIMPMessage simpMessage, Transaction transaction) throws SIRollbackException, SIConnectionLostException, SIErrorException, SIIncorrectCallException, SIResourceException {
        MessageEventListener messageEventListener;
        int index;
        for (index = 0; index < this.length(); ++index) {
            messageEventListener = (MessageEventListener)this.get(index);
            if (messageEventListener == null || messageEventListener instanceof ConsumerDispatcher) continue;
            messageEventListener.messageEventOccurred(this.event, simpMessage, (TransactionCommon)transaction);
        }
        for (index = 0; index < this.length(); ++index) {
            messageEventListener = (MessageEventListener)this.get(index);
            if (messageEventListener == null || !(messageEventListener instanceof ConsumerDispatcher)) continue;
            messageEventListener.messageEventOccurred(this.event, simpMessage, (TransactionCommon)transaction);
        }
    }

    void reset() {
        for (int index = 0; index < this.length(); ++index) {
            this.set(index, null);
        }
    }
}

