/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.BrowserSessionImpl;
import com.ibm.ws.sib.processor.impl.JSConsumerSet;
import com.ibm.ws.sib.processor.impl.JSLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.LocalQPConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.OrderingContextImpl;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.JSConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.JSKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractConsumerManager {
    private static final TraceComponent tc = SibTr.register(AbstractConsumerManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    protected LinkedList<BrowserSessionImpl> _browsers = new LinkedList();
    protected BaseDestinationHandler _baseDestHandler;
    protected MessageProcessor _messageProcessor;
    boolean closing = false;
    private SIBUuid8 _cmUuid = null;
    private HashMap<OrderingContextImpl, JSKeyGroup> keyGroups = new HashMap();

    public AbstractConsumerManager(BaseDestinationHandler bdh) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AbstractConsumerManager", (Object)bdh);
        }
        this._baseDestHandler = bdh;
        this._messageProcessor = bdh.getMessageProcessor();
        this._cmUuid = new SIBUuid8();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AbstractConsumerManager", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachBrowser(BrowserSessionImpl browserSession) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"attachBrowser", (Object)browserSession);
        }
        LinkedList<BrowserSessionImpl> linkedList = this._browsers;
        synchronized (linkedList) {
            if (browserSession.getNamedDestination().isToBeDeleted() || browserSession.getNamedDestination().isDeleted()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"attachBrowser", (Object)"SINotPossibleInCurrentConfigurationException");
                }
                throw new SINotPossibleInCurrentConfigurationException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_32", new Object[]{this._baseDestHandler.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            this._browsers.add(browserSession);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"attachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachBrowser(BrowserSessionImpl browserSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"detachBrowser", (Object)browserSession);
        }
        LinkedList<BrowserSessionImpl> linkedList = this._browsers;
        synchronized (linkedList) {
            if (!this.closing) {
                this._browsers.remove(browserSession);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"detachBrowser");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeBrowsersDestinationDeleted(DestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"closeBrowsersDestinationDeleted", (Object)destinationHandler);
        }
        LinkedList<BrowserSessionImpl> linkedList = this._browsers;
        synchronized (linkedList) {
            Iterator i = this._browsers.iterator();
            this.closing = true;
            while (i.hasNext()) {
                boolean closedOk = ((BrowserSessionImpl)i.next())._closeBrowserDestinationDeleted(destinationHandler);
                if (!closedOk) continue;
                i.remove();
            }
            this.closing = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"closeBrowsersDestinationDeleted");
        }
    }

    public MessageProcessor getMessageProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor", (Object)this._messageProcessor);
        }
        return this._messageProcessor;
    }

    public BaseDestinationHandler getDestination() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestination");
            SibTr.exit((TraceComponent)tc, (String)"getDestination", (Object)this._baseDestHandler);
        }
        return this._baseDestHandler;
    }

    public SIBUuid8 getUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)this._cmUuid);
        }
        return this._cmUuid;
    }

    public void setCurrentTransaction(SIMPMessage msg, boolean isInDoubtOnRemoteConsumer) {
    }

    public void setCurrentTransaction(TransactionCommon transaction, JSLockedMessageEnumeration lme) {
    }

    public long newReadyConsumer(JSConsumerKey key, boolean specific) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerKeyGroup joinKeyGroup(ConsumerKey consumerKey, OrderingContextImpl orderingGroup) throws SIResourceException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"joinKeyGroup", (Object)new Object[]{consumerKey, orderingGroup});
        }
        JSKeyGroup keyGroup = null;
        OrderingContextImpl orderingContextImpl = orderingGroup;
        synchronized (orderingContextImpl) {
            Object object = this._baseDestHandler.getReadyConsumerPointLock();
            synchronized (object) {
                keyGroup = this.keyGroups.get(orderingGroup);
                if (keyGroup == null) {
                    JSConsumerSet consumerSet = null;
                    if (consumerKey instanceof ConsumableKey && (keyGroup = this.createConsumerKeyGroup(consumerSet = ((ConsumableKey)consumerKey).getConsumerSet())) != null) {
                        this.keyGroups.put(orderingGroup, keyGroup);
                    }
                }
            }
            if (keyGroup != null) {
                ((ConsumableKey)consumerKey).joinKeyGroup(keyGroup);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"joinKeyGroup", (Object)keyGroup);
        }
        return keyGroup;
    }

    protected abstract JSKeyGroup createConsumerKeyGroup(JSConsumerSet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyGroup(LocalQPConsumerKeyGroup keyGroup) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeKeyGroup", (Object)keyGroup);
        }
        Object object = this._baseDestHandler.getReadyConsumerPointLock();
        synchronized (object) {
            Iterator<OrderingContextImpl> keys = this.keyGroups.keySet().iterator();
            while (keys.hasNext()) {
                OrderingContextImpl key = keys.next();
                if (!this.keyGroups.get(key).equals(keyGroup)) continue;
                keys.remove();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeKeyGroup");
        }
    }

    public void removeReadyConsumer(JSConsumerKey key, boolean specific) {
    }

    public void setReadyForUse() {
    }
}

