/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.matchspace.impl;

import com.ibm.ws.sib.matchspace.Conjunction;
import com.ibm.ws.sib.matchspace.EvalCache;
import com.ibm.ws.sib.matchspace.Identifier;
import com.ibm.ws.sib.matchspace.Literal;
import com.ibm.ws.sib.matchspace.MatchSpace;
import com.ibm.ws.sib.matchspace.MatchingException;
import com.ibm.ws.sib.matchspace.Operator;
import com.ibm.ws.sib.matchspace.Selector;
import com.ibm.ws.sib.matchspace.SimpleTest;
import com.ibm.ws.sib.matchspace.impl.EvalCacheImpl;
import com.ibm.ws.sib.matchspace.impl.MatchSpaceImpl;
import com.ibm.ws.sib.matchspace.impl.Matching;
import com.ibm.ws.sib.matchspace.selector.impl.ConjunctionImpl;
import com.ibm.ws.sib.matchspace.selector.impl.EvaluatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.ExtensionOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.IdentifierImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LikeOperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.LiteralImpl;
import com.ibm.ws.sib.matchspace.selector.impl.MQSITopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.selector.impl.MatchParserImpl;
import com.ibm.ws.sib.matchspace.selector.impl.MinimalResolver;
import com.ibm.ws.sib.matchspace.selector.impl.OperatorImpl;
import com.ibm.ws.sib.matchspace.selector.impl.Pattern;
import com.ibm.ws.sib.matchspace.selector.impl.PositionAssignerImpl;
import com.ibm.ws.sib.matchspace.selector.impl.TopicPattern;
import com.ibm.ws.sib.matchspace.selector.impl.TransformerImpl;
import com.ibm.ws.sib.matchspace.selector.impl.XPathTopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.tools.Evaluator;
import com.ibm.ws.sib.matchspace.tools.MatchParser;
import com.ibm.ws.sib.matchspace.tools.PositionAssigner;
import com.ibm.ws.sib.matchspace.tools.Resolver;
import com.ibm.ws.sib.matchspace.tools.TopicSyntaxChecker;
import com.ibm.ws.sib.matchspace.utils.FFDC;
import com.ibm.ws.sib.matchspace.utils.Trace;
import com.ibm.ws.sib.matchspace.utils.TraceUtils;

public class MatchingImpl
extends Matching {
    private static final Class cclass = MatchingImpl.class;
    private static Trace tc = TraceUtils.getTrace(MatchingImpl.class, (String)"SIBMatchSpace");

    public MatchingImpl() {
        eval = null;
        transformer = new TransformerImpl();
        Class<?> evaluatorClass = null;
        try {
            evaluatorClass = Class.forName("com.ibm.ws.sib.matchspace.selector.impl.XPath10EvaluatorImpl");
            eval = (Evaluator)evaluatorClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug(cclass, "No XPath10 Evaluator class found", (Object)e);
            }
            eval = new EvaluatorImpl();
        }
        catch (Exception ex) {
            if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                tc.debug(cclass, "Error when locating XPath10 Evaluator class", (Object)ex);
            }
            eval = new EvaluatorImpl();
        }
    }

    @Override
    public MatchSpace createMatchSpace(Identifier rootId, boolean enableCacheing) {
        MatchSpaceImpl matchSpace = new MatchSpaceImpl(rootId, enableCacheing);
        return matchSpace;
    }

    @Override
    public EvalCache createEvalCache() {
        EvalCacheImpl evalCache = new EvalCacheImpl();
        return evalCache;
    }

    @Override
    public MatchParser primeMatchParser(MatchParser parser, String selector, int selectorDomain) throws MatchingException {
        MatchParser parserimpl = null;
        switch (selectorDomain) {
            case 0: {
                parserimpl = MatchParserImpl.prime(parser, selector, false);
                break;
            }
            case 1: {
                parserimpl = MatchParserImpl.prime(parser, selector, true);
                break;
            }
            case 2: {
                if (parser == null) {
                    Class<?> parserClass = null;
                    try {
                        parserClass = Class.forName("com.ibm.ws.sib.matchspace.selector.impl.XPath10ParserImpl");
                        parserimpl = (MatchParser)parserClass.newInstance();
                        parserimpl.setMatching(this);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchingImpl", (Throwable)e, (String)"1:191:1.18");
                        if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            tc.debug(cclass, "UNABLE_TO_CREATE_MATCHING_INSTANCE_CWSIH0007", (Object)e);
                        }
                        throw new MatchingException((Exception)e);
                    }
                    catch (Exception ex) {
                        FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchingImpl", (Throwable)ex, (String)"1:203:1.18");
                        if (!tc.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        tc.debug(cclass, "UNABLE_TO_CREATE_MATCHING_INSTANCE_CWSIH0007", (Object)ex);
                        break;
                    }
                }
                parserimpl = parser;
                break;
            }
            default: {
                MatchingException mex = new MatchingException();
                FFDC.processException((Class)cclass, (String)"com.ibm.ws.sib.matchspace.impl.MatchingImpl", (Throwable)mex, (String)"1:221:1.18");
                if (tc.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    tc.debug(cclass, "UNABLE_TO_CREATE_MATCHING_INSTANCE_CWSIH0007", (Object)mex);
                }
                throw mex;
            }
        }
        return parserimpl;
    }

    @Override
    public PositionAssigner createPositionAssigner() {
        PositionAssignerImpl pa = new PositionAssignerImpl();
        return pa;
    }

    @Override
    public Resolver createMinimalResolver() {
        MinimalResolver resolver = new MinimalResolver();
        return resolver;
    }

    @Override
    public Conjunction createConjunction() {
        ConjunctionImpl conjunction = new ConjunctionImpl();
        return conjunction;
    }

    @Override
    public Conjunction createConjunction(Selector sel) {
        ConjunctionImpl conjunction = new ConjunctionImpl(sel);
        return conjunction;
    }

    @Override
    public Conjunction createConjunction(SimpleTest test) {
        ConjunctionImpl conjunction = new ConjunctionImpl(test);
        return conjunction;
    }

    @Override
    public Literal createLiteral(Object obj) {
        LiteralImpl literal = new LiteralImpl(obj);
        return literal;
    }

    @Override
    public Operator createOperator(int op, Selector operand) {
        OperatorImpl operator = new OperatorImpl(op, operand);
        return operator;
    }

    @Override
    public Operator createOperator(int op, Selector op1, Selector op2) {
        OperatorImpl operator = new OperatorImpl(op, op1, op2);
        return operator;
    }

    @Override
    public Operator createExtensionOperator(int op, Selector op1, Selector op2) {
        ExtensionOperatorImpl operator = null;
        operator = op1 == null ? new ExtensionOperatorImpl(op, op2) : new ExtensionOperatorImpl(op, op1, op2);
        return operator;
    }

    @Override
    public Operator createLikeOperator(Selector ar, String pattern, boolean escaped, char escape) {
        Object parsed = Pattern.parsePattern(pattern, escaped, escape);
        if (parsed == null) {
            return null;
        }
        if (parsed == Pattern.matchMany) {
            return this.createOperator(1, (Selector)this.createOperator(3, ar));
        }
        if (parsed instanceof String) {
            return this.createOperator(45, ar, (Selector)this.createLiteral(parsed));
        }
        return new LikeOperatorImpl(4, ar, (Pattern)parsed, pattern, escaped, escape);
    }

    @Override
    public Identifier createIdentifier(String name) {
        IdentifierImpl identifier = new IdentifierImpl(name);
        return identifier;
    }

    @Override
    public Operator createTopicLikeOperator(Selector ar, String pattern) {
        Object parsed = TopicPattern.parsePattern(pattern);
        if (parsed == Pattern.matchMany) {
            return this.createOperator(1, (Selector)this.createOperator(3, ar));
        }
        if (parsed instanceof String) {
            return this.createOperator(45, ar, (Selector)this.createLiteral(parsed));
        }
        return new LikeOperatorImpl(5, ar, (Pattern)parsed, pattern, false, '\u0000');
    }

    @Override
    public TopicSyntaxChecker createXPathTopicSyntaxChecker() {
        XPathTopicSyntaxChecker syntaxChecker = new XPathTopicSyntaxChecker();
        return syntaxChecker;
    }

    @Override
    public TopicSyntaxChecker createMQSITopicSyntaxChecker() {
        MQSITopicSyntaxChecker syntaxChecker = new MQSITopicSyntaxChecker();
        return syntaxChecker;
    }

    @Override
    public Operator createMQSITopicLikeOperator(Selector ar, String pattern) {
        Object parsed = TopicPattern.parseMQSIPattern(pattern);
        if (parsed == Pattern.matchMany) {
            return this.createOperator(1, (Selector)this.createOperator(3, ar));
        }
        if (parsed instanceof String) {
            return this.createOperator(45, ar, (Selector)this.createLiteral(parsed));
        }
        return new LikeOperatorImpl(5, ar, (Pattern)parsed, pattern, false, '\u0000');
    }
}

