/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TrustAssociationInterceptor;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TAIUtil {
    private static final TraceComponent tc = Tr.register(TAIUtil.class, null, null);
    public static final String KEY_DISABLE_LTPA_COOKIE = "disableLtpaCookie";
    private boolean invokeBeforeSSO = false;
    private boolean invokeAfterSSO = false;
    private Object disableLtpaCookie = null;
    static final long serialVersionUID = -5474523352999085378L;

    public TAIUtil(ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, String interceptorId) {
        this.processUserFeatureTaiProps(interceptorServiceRef, interceptorId);
    }

    public void processUserFeatureTaiProps(ConcurrentServiceReferenceMap<String, TrustAssociationInterceptor> interceptorServiceRef, String interceptorId) {
        this.invokeBeforeSSO = false;
        this.invokeAfterSSO = false;
        this.disableLtpaCookie = false;
        ServiceReference taiServiceRef = interceptorServiceRef.getReference((Object)interceptorId);
        Object beforeSsoProp = taiServiceRef.getProperty("invokeBeforeSSO");
        Object afterSsoProp = taiServiceRef.getProperty("invokeAfterSSO");
        this.disableLtpaCookie = taiServiceRef.getProperty(KEY_DISABLE_LTPA_COOKIE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("User feature interceptor properties of " + interceptorId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("     beforeSsoProp=" + beforeSsoProp + " afterSsoProp=" + afterSsoProp + " disableLtpaCookie=" + this.disableLtpaCookie), (Object[])new Object[0]);
        }
        if (beforeSsoProp == null && afterSsoProp == null) {
            this.invokeAfterSSO = true;
        } else if (beforeSsoProp == null && afterSsoProp != null) {
            this.resolveOnlyInvokeAfterSSOSpecified(afterSsoProp);
        } else if (beforeSsoProp != null && afterSsoProp == null) {
            this.resolveOnlyInvokeBeforeSSOSpecified(beforeSsoProp);
        } else if (beforeSsoProp != null && afterSsoProp != null) {
            this.invokeBeforeSSO = (Boolean)beforeSsoProp;
            this.invokeAfterSSO = (Boolean)afterSsoProp;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("User feature interceptor properties " + interceptorId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("     invokeBeforeSSO=" + this.invokeBeforeSSO + " invokeAfterSSO=" + this.invokeAfterSSO + " disableLtpaCookie=" + this.disableLtpaCookie), (Object[])new Object[0]);
        }
    }

    protected void resolveOnlyInvokeBeforeSSOSpecified(Object beforeSSO) {
        this.invokeBeforeSSO = (Boolean)beforeSSO;
        if (!this.invokeBeforeSSO) {
            this.invokeAfterSSO = true;
        }
    }

    protected void resolveOnlyInvokeAfterSSOSpecified(Object afterSSO) {
        this.invokeAfterSSO = (Boolean)afterSSO;
        if (!this.invokeAfterSSO) {
            this.invokeBeforeSSO = true;
        }
    }

    public boolean isInvokeBeforeSSO() {
        return this.invokeBeforeSSO;
    }

    public boolean isInvokeAfterSSO() {
        return this.invokeAfterSSO;
    }

    public Object isDisableLtpaCookie() {
        return this.disableLtpaCookie;
    }
}

