/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.url.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.url.UrlAttributesGetter;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.annotation.Nullable;
import java.util.function.Function;

public final class InternalUrlAttributesExtractor<REQUEST> {
    private final UrlAttributesGetter<REQUEST> getter;
    private final Function<REQUEST, String> alternateSchemeProvider;
    private final boolean emitStableUrlAttributes;
    private final boolean emitOldHttpAttributes;

    public InternalUrlAttributesExtractor(UrlAttributesGetter<REQUEST> getter, Function<REQUEST, String> alternateSchemeProvider, boolean emitStableUrlAttributes, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.alternateSchemeProvider = alternateSchemeProvider;
        this.emitStableUrlAttributes = emitStableUrlAttributes;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        String urlScheme = this.getUrlScheme(request);
        String urlPath = this.getter.getUrlPath(request);
        String urlQuery = this.getter.getUrlQuery(request);
        if (this.emitStableUrlAttributes) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_SCHEME, urlScheme);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_PATH, urlPath);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.URL_QUERY, urlQuery);
        }
        if (this.emitOldHttpAttributes) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_SCHEME, urlScheme);
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_TARGET, InternalUrlAttributesExtractor.getTarget(urlPath, urlQuery));
        }
    }

    private String getUrlScheme(REQUEST request) {
        String urlScheme = this.alternateSchemeProvider.apply(request);
        if (urlScheme == null) {
            urlScheme = this.getter.getUrlScheme(request);
        }
        return urlScheme;
    }

    @Nullable
    private static String getTarget(@Nullable String path, @Nullable String query) {
        if (path == null && query == null) {
            return null;
        }
        return (path == null ? "" : path) + (query == null || query.isEmpty() ? "" : "?" + query);
    }
}

