/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.manager;

import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Producer;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.injection.producer.ProducerMethodProducer;
import org.jboss.weld.manager.AbstractProducerFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.util.reflection.Reflections;

public class MethodProducerFactory<X>
extends AbstractProducerFactory<X> {
    private final AnnotatedMethod<X> method;

    protected MethodProducerFactory(AnnotatedMethod<? super X> method, Bean<X> declaringBean, BeanManagerImpl manager) {
        super(declaringBean, manager);
        this.method = (AnnotatedMethod)Reflections.cast(method);
    }

    @Override
    public <T> Producer<T> createProducer(final Bean<X> declaringBean, final Bean<T> bean, DisposalMethod<X, T> disposalMethod) {
        EnhancedAnnotatedMethod enhancedMethod = (EnhancedAnnotatedMethod)this.getManager().getServices().get(MemberTransformer.class).loadEnhancedMember(this.method, this.getManager().getId());
        return new ProducerMethodProducer<X, T>(enhancedMethod, disposalMethod){

            @Override
            public AnnotatedMethod<X> getAnnotated() {
                return MethodProducerFactory.this.method;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return MethodProducerFactory.this.getManager();
            }

            @Override
            public Bean<X> getDeclaringBean() {
                return declaringBean;
            }

            @Override
            public Bean<T> getBean() {
                return bean;
            }
        };
    }

    @Override
    protected AnnotatedMember<X> getAnnotatedMember() {
        return this.method;
    }
}

