/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.matchspace.MatchSpaceKey;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlRequestFlush;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.LockingCursor;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPConnectionLostException;
import com.ibm.ws.sib.processor.exceptions.SIMPErrorException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPLimitExceededException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotAuthorizedException;
import com.ibm.ws.sib.processor.exceptions.SIMPNotPossibleInCurrentConfigurationException;
import com.ibm.ws.sib.processor.exceptions.SIMPResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPRollbackException;
import com.ibm.ws.sib.processor.gd.ExpressTargetStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.GuaranteedTargetStream;
import com.ibm.ws.sib.processor.gd.InternalInputStreamManager;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AbstractInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.JSBrowseCursor;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.Browsable;
import com.ibm.ws.sib.processor.impl.interfaces.BrowseCursor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageProducer;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.filters.MessageSelectorFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProxyReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.TargetProtocolItemStream;
import com.ibm.ws.sib.processor.matching.MatchingConsumerDispatcher;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class PubSubInputHandler
extends AbstractInputHandler
implements DownstreamControl,
Browsable,
InputHandlerStore {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(PubSubInputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls_cwsik = TraceNLS.getTraceNLS((String)"com.ibm.websphere.sib.CWSIKMessages");
    private final SourceStreamManager _sourceStreamManager;
    private final BatchHandler _sourceBatchHandler;
    private final InternalInputStreamManager _internalInputStreamManager;
    private final SIBUuid8 _localMEUuid;
    private final SIMPReferenceStream _proxyReferenceStream;
    private final MessageProcessorMatching _matchspace;
    private final PubSubMessageItemStream _itemStream;
    private final HashMap<SIBUuid12, SIBUuid8> _originStreamMap;
    private boolean _flushedForDeleteSource = false;
    private FlushComplete _deleteFlushSource = null;
    private boolean _flushedForDeleteTarget = false;
    private AlarmListener _deleteFlushTarget = null;

    public PubSubInputHandler(DestinationHandler destination, TargetProtocolItemStream targetProtocolItemStream, PubSubMessageItemStream itemStream, ProxyReferenceStream proxyReferenceStream, ProtocolItemStream protocolItemStream) {
        super(destination, targetProtocolItemStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubInputHandler", (Object)new Object[]{destination, targetProtocolItemStream, itemStream, proxyReferenceStream, protocolItemStream});
        }
        this._proxyReferenceStream = proxyReferenceStream;
        proxyReferenceStream.setPubSubInputHandler(this);
        this._sourceStreamManager = new SourceStreamManager(this._messageProcessor, this, destination, protocolItemStream, destination.getMessageProcessor().getMessagingEngineUuid(), null);
        this._internalInputStreamManager = new InternalInputStreamManager(this._messageProcessor, this);
        this._localMEUuid = this._messageProcessor.getMessagingEngineUuid();
        this._itemStream = itemStream;
        this._matchspace = this._messageProcessor.getMessageProcessorMatching();
        this._sourceBatchHandler = this._messageProcessor.getSourceBatchHandler();
        this._originStreamMap = new HashMap();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubInputHandler", (Object)this);
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        if (event == 8) {
            this.eventPrecommitAdd(msg, tran);
        } else if (event == 2) {
            this.eventPostAdd(msg, tran, false);
        } else if (event == 4) {
            this.eventPostAdd(msg, tran, true);
        } else if (event == 9) {
            this.eventPostCommit(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    protected final void eventPrecommitAdd(SIMPMessage msg, TransactionCommon tran) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPrecommitAdd", (Object)new Object[]{msg, tran});
        }
        if (msg.isTransacted()) {
            this.localFanOut((MessageItem)msg, tran, false);
            msg.releaseJsMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPrecommitAdd");
        }
    }

    private void eventPostAdd(SIMPMessage msg, TransactionCommon tran, boolean rollback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostAdd", (Object)new Object[]{msg, tran, new Boolean(rollback)});
        }
        MessageItemReference ref = (MessageItemReference)msg;
        MessageItem msgItem = null;
        try {
            msgItem = (MessageItem)ref.getReferredItem();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.eventPostAdd", (String)"1:385:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostAdd", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        JsMessage jsMsg = msgItem.getMessage();
        if (rollback) {
            this._sourceStreamManager.updateSourceStream(msgItem, rollback);
        } else {
            this._sourceStreamManager.updateSourceStream(ref, rollback);
        }
        jsMsg.setBus(this._messageProcessor.getMessagingEngineBus());
        MessageProcessorSearchResults searchResults = ref.getSearchResults();
        List matchingPubsubOutputHandlers = searchResults.getPubSubOutputHandlers(null);
        ArrayList<SIBUuid8> fromTo = new ArrayList<SIBUuid8>(matchingPubsubOutputHandlers.size());
        Iterator itr = matchingPubsubOutputHandlers.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PubSubOutputHandler outputHandler = (PubSubOutputHandler)itr.next();
            if (!outputHandler.okToForward(msgItem)) continue;
            if (rollback) {
                outputHandler.rollbackInsert(msgItem);
            } else {
                outputHandler.commitInsert(msgItem);
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    UserTrace.traceOutboundSend(jsMsg, outputHandler.getTargetMEUuid(), this._destination.getName(), this._destination.isForeignBus() || this._destination.isLink(), this._destination.isMQLink(), this._destination.isTemporary());
                }
            }
            if (outputHandler.isLink()) {
                outputHandler.sendLinkMessage(msgItem, rollback);
                continue;
            }
            SIBUuid8 targetMEUuid = outputHandler.getTargetMEUuid();
            fromTo.add(targetMEUuid);
            ++i;
        }
        if (i > 0) {
            SIBUuid8[] fromToArray = fromTo.toArray(new SIBUuid8[fromTo.size()]);
            if (rollback) {
                ControlSilence cMsg = this.createSilenceMessage(jsMsg.getGuaranteedValueValueTick(), jsMsg.getGuaranteedValueCompletedPrefix(), msgItem.getPriority(), msgItem.getReliability(), jsMsg.getGuaranteedStreamUUID());
                this._mpio.sendDownTree(fromToArray, msgItem.getPriority(), (AbstractMessage)cMsg);
            } else {
                this._mpio.sendDownTree(fromToArray, msgItem.getPriority(), (AbstractMessage)jsMsg);
            }
        }
        ref.setSearchResults(null);
        msg.releaseJsMessage();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostAdd");
        }
    }

    @Override
    public void sendNackMessage(SIBUuid8 upstream, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNackMessage", (Object)new Object[]{new Long(startTick), new Long(endTick)});
        }
        ControlNack nackMsg = this.createControlNackMessage(priority, reliability, stream);
        nackMsg.setStartTick(startTick);
        nackMsg.setEndTick(endTick);
        if (upstream == null) {
            upstream = this._originStreamMap.get(stream);
        }
        this._mpio.sendToMe(upstream, priority + 2, (AbstractMessage)nackMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNackMessage ");
        }
    }

    @Override
    public void sendAckMessage(SIBUuid8 upstream, SIBUuid12 destUuid, SIBUuid8 busUuid, long ackPrefix, int priority, Reliability reliability, SIBUuid12 stream, boolean consolidate) throws SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckMessage", (Object)new Long(ackPrefix));
        }
        if (upstream == null) {
            upstream = this._originStreamMap.get(stream);
        }
        ControlAck ackMsg = this.createControlAckMessage(priority, reliability, stream);
        ackMsg.setAckPrefix(ackPrefix);
        if (consolidate && this._internalInputStreamManager.hasStream(stream, priority, reliability)) {
            try {
                this.processAck(ackMsg);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.sendAckMessage", (String)"1:600:1.329.1.1", (Object)this);
            }
        } else {
            this._mpio.sendToMe(upstream, priority + 1, (AbstractMessage)ackMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckMessage");
        }
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{cMsg});
        }
        if ((type = cMsg.getControlMessageType()) != ControlMessageType.REQUESTFLUSH) {
            if (type == ControlMessageType.ACK) {
                this.processAck((ControlAck)cMsg);
            } else if (type == ControlMessageType.NACK) {
                this.processNack((ControlNack)cMsg);
            } else if (type == ControlMessageType.ACKEXPECTED) {
                this.processAckExpected((ControlAckExpected)cMsg);
            } else {
                super.handleControlMessage(sourceMEUuid, cMsg);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIErrorException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessageWithReturnValue", (Object)new Object[]{cMsg});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessageWithReturnValue");
        }
        return this.processNackWithReturnValue((ControlNack)cMsg);
    }

    private void processAckExpected(ControlAckExpected ackExpMsg) throws SIResourceException {
        Reliability reliability;
        int priority;
        SIBUuid12 streamID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)ackExpMsg);
        }
        if (this._internalInputStreamManager.hasStream(streamID = ackExpMsg.getGuaranteedStreamUUID(), priority = ackExpMsg.getPriority().intValue(), reliability = ackExpMsg.getReliability())) {
            this._internalInputStreamManager.processAckExpected(ackExpMsg);
        } else {
            this._targetStreamManager.handleAckExpectedMessage(ackExpMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    private long processNackWithReturnValue(ControlNack nackMsg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNackWithReturnValue", (Object)nackMsg);
        }
        long returnValue = -1L;
        SIBUuid12 stream = nackMsg.getGuaranteedStreamUUID();
        if (this._sourceStreamManager.hasStream(stream)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring processNack on sourceStream at PubSubInputHandler");
            }
            returnValue = this._sourceStreamManager.getStreamSet().getStream(nackMsg.getPriority(), nackMsg.getReliability()).getCompletedPrefix();
        } else {
            this._internalInputStreamManager.processNack(nackMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNackWithReturnValue", (Object)new Long(returnValue));
        }
        return returnValue;
    }

    private void processNack(ControlNack nackMsg) throws SIResourceException {
        SIBUuid12 stream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)nackMsg);
        }
        if (this._sourceStreamManager.hasStream(stream = nackMsg.getGuaranteedStreamUUID())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring processNack on sourceStream at PubSubInputHandler");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"processNack");
            }
        } else {
            this._internalInputStreamManager.processNack(nackMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAck(ControlAck ack) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        block22: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processAck");
            }
            SIBUuid12 stream = ack.getGuaranteedStreamUUID();
            List indexList = null;
            long index = 0L;
            MessageItemReference msgItemRef = null;
            long min = Long.MAX_VALUE;
            Iterator outputHandlers = this._destination.getAllPubSubOutputHandlers().values().iterator();
            PubSubOutputHandler outputHandler = null;
            while (outputHandlers.hasNext()) {
                outputHandler = (PubSubOutputHandler)outputHandlers.next();
                min = outputHandler.checkAck(ack, min);
            }
            if (!this._sourceStreamManager.hasStream(stream)) {
                min = this._targetStreamManager.checkAck(ack, min);
            }
            try {
                PubSubInputHandler pubSubInputHandler = this;
                synchronized (pubSubInputHandler) {
                    indexList = this._sourceStreamManager.hasStream(stream) ? this._sourceStreamManager.processAck(ack, min) : this._internalInputStreamManager.processAck(ack, min);
                }
                if (indexList == null) break block22;
                TransactionCommon tran = this._sourceBatchHandler.registerInBatch();
                boolean messageAddCall = false;
                try {
                    SourceStream batchListener = this._sourceStreamManager.getBatchListener(ack);
                    TickRange tr = null;
                    for (int i = 0; i < indexList.size(); ++i) {
                        tr = (TickRange)indexList.get(i);
                        batchListener.addToBatchList(tr);
                        index = tr.itemStreamIndex;
                        try {
                            msgItemRef = (MessageItemReference)this._proxyReferenceStream.findById(index);
                            if (msgItemRef == null) continue;
                            Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
                            msgItemRef.remove(msTran, msgItemRef.getLockID());
                            continue;
                        }
                        catch (MessageStoreException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.processAck", (String)"1:951:1.329.1.1", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)((Object)e));
                            }
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:962:1.329.1.1", e});
                            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:970:1.329.1.1", e}, null), (Throwable)e);
                        }
                    }
                    messageAddCall = true;
                    this._sourceBatchHandler.messagesAdded(indexList.size(), batchListener);
                }
                finally {
                    block23: {
                        if (!messageAddCall) {
                            try {
                                this._sourceBatchHandler.messagesAdded(0);
                            }
                            catch (SIResourceException e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block23;
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                        }
                    }
                }
            }
            finally {
                this._destination.unlockPubsubOutputHandlers();
                this._sourceStreamManager.attemptFlushIfNecessary();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processAck");
                }
            }
        }
    }

    @Override
    public void handleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid});
        }
        JsDestinationAddress routingAddr = msg.getMessage().getRoutingDestination();
        boolean msgFRP = !msg.getMessage().isForwardRoutingPathEmpty();
        this.internalHandleMessage(msg, transaction, sourceMEUuid, routingAddr, null, msgFRP);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleMessage");
        }
    }

    @Override
    public void handleProducerMessage(MessageItem msg, TransactionCommon transaction, JsDestinationAddress inAddress, MessageProducer sender, boolean msgFRP) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleProducerMessage", (Object)new Object[]{msg, transaction, inAddress, sender, msgFRP});
        }
        this.internalHandleMessage(msg, transaction, this._messageProcessor.getMessagingEngineUuid(), inAddress, sender, msgFRP);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleProducerMessage");
        }
    }

    private void internalHandleMessage(MessageItem msg, TransactionCommon transaction, SIBUuid8 sourceMEUuid, JsDestinationAddress inAddress, MessageProducer sender, boolean msgFRP) throws SIConnectionLostException, SIRollbackException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"internalHandleMessage", (Object)new Object[]{msg, transaction, sourceMEUuid, inAddress, sender, msgFRP});
        }
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            this.traceSend(msg);
        }
        super.handleMessage(msg);
        msg.setTransacted(!transaction.isAutoCommit());
        if (!this._destination.isToBeDeleted()) {
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                msg.setDebugName(this._destination.getName());
            }
            if (sourceMEUuid.equals((Object)this._localMEUuid)) {
                this.localPut(msg, transaction);
            } else {
                try {
                    this.remotePut(msg, sourceMEUuid);
                }
                catch (SIResourceException e) {
                    SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                    ee.setExceptionReason(901);
                    ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler.handleMessage", "1:1134:1.329.1.1", SIMPUtils.getStackTrace(e)});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage", (Object)ee);
                    }
                    throw ee;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"internalHandleMessage");
        }
    }

    private void localPut(MessageItem msg, TransactionCommon transaction) throws SIIncorrectCallException, SIResourceException, SINotPossibleInCurrentConfigurationException, SINotAuthorizedException, SILimitExceededException {
        boolean forcePut;
        boolean isSendAllowed;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"localPut", (Object)new Object[]{msg, transaction});
        }
        boolean stored = false;
        if (!msg.getMessage().isForwardRoutingPathEmpty()) {
            SIMPIncorrectCallException e = new SIMPIncorrectCallException(nls.getFormattedMessage("FORWARD_ROUTING_PATH_ERROR_CWSIP0249", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            e.setExceptionReason(37);
            e.setExceptionInserts(new String[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName(), "unknown", SIMPUtils.getStackTrace((Throwable)e)});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)e);
            }
            throw e;
        }
        if (msg.isFromRemoteBus() && this._messageProcessor.isBusSecure()) {
            JsMessage jsMsg = msg.getMessage();
            if (!this._messageProcessor.getAuthorisationUtils().sentBySIBServer(jsMsg)) {
                String discriminator;
                SecurityContext secContext;
                String userid = null;
                if (this._destination.isLink() && !this._destination.isMQLink()) {
                    userid = ((LinkHandler)this._destination).getInboundUserid();
                }
                if (userid == null) {
                    userid = jsMsg.getSecurityUserid();
                }
                if (userid == null) {
                    userid = "";
                }
                if (!this._destination.checkDestinationAccess(secContext = new SecurityContext(userid, discriminator = msg.getMessage().getDiscriminator()), OperationType.SEND)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"not authorized to produce to this destination");
                    }
                    String nlsMessage = nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_18", new Object[]{this._destination.getName(), userid}, null);
                    this._messageProcessor.getAccessChecker().fireDestinationAccessNotAuthorizedEvent(this._destination.getName(), userid, OperationType.SEND, nlsMessage);
                    SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nlsMessage);
                    e.setExceptionReason(18);
                    e.setExceptionInserts(new String[]{this._destination.getName(), userid});
                    throw e;
                }
                if (!this._destination.checkDiscriminatorAccess(secContext, OperationType.SEND)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"not authorized to produce to this destination's discriminator");
                    }
                    SibTr.audit((TraceComponent)tc, (String)nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), secContext.getDiscriminator(), userid}, null));
                    SIMPNotAuthorizedException e = new SIMPNotAuthorizedException(nls_cwsik.getFormattedMessage("DELIVERY_ERROR_SIRC_20", new Object[]{this._destination.getName(), secContext.getDiscriminator(), userid}, null));
                    e.setExceptionReason(20);
                    e.setExceptionInserts(new String[]{this._destination.getName(), secContext.getDiscriminator(), userid});
                    throw e;
                }
            }
        }
        boolean bl = isSendAllowed = (forcePut = msg.isForcePut()) || this._itemStream.isSendAllowed() && this._destination.isSendAllowed();
        if (!isSendAllowed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"Destination send disallowed");
            }
            SIMPNotPossibleInCurrentConfigurationException e = new SIMPNotPossibleInCurrentConfigurationException(nls.getFormattedMessage("DESTINATION_SEND_DISALLOWED_CWSIP0253", new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName()}, null));
            e.setExceptionReason(901);
            e.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler.localPut", "1:1334:1.329.1.1", SIMPUtils.getStackTrace(e)});
            throw e;
        }
        long topicSpaceHighLimit = this._destination.getPublishPoint().getDestHighMsgs();
        if (!forcePut && topicSpaceHighLimit != -1L && this._itemStream.getTotalMsgCount() >= topicSpaceHighLimit) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)"Destination reached high limit");
            }
            SIMPLimitExceededException e = new SIMPLimitExceededException(nls.getFormattedMessage("DESTINATION_HIGH_MESSAGES_ERROR_CWSIP0251", new Object[]{this._destination.getName(), new Long(topicSpaceHighLimit), this._messageProcessor.getMessagingEngineName()}, null));
            e.setExceptionReason(25);
            e.setExceptionInserts(new String[]{this._destination.getName(), new Long(topicSpaceHighLimit).toString()});
            throw e;
        }
        if (msg.isTransacted()) {
            this.registerMessage(msg, transaction);
        } else {
            LocalTransaction siTran = this._txManager.createLocalTransaction(false);
            if (msg.getReportCOD() != null && this._destination instanceof BaseDestinationHandler) {
                msg.registerMessageEventListener(11, (BaseDestinationHandler)this._destination);
            }
            try {
                stored = this.localFanOut(msg, (TransactionCommon)siTran, false);
                if (stored) {
                    siTran.commit();
                } else {
                    siTran.rollback();
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.localPut", (String)"1:1397:1.329.1.1", (Object)this);
                SIMPErrorException ee = new SIMPErrorException((Throwable)e);
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1404:1.329.1.1", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)ee);
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)ee);
                }
                throw ee;
            }
            catch (SIRollbackException e) {
                this.handleRollback(siTran);
                SIMPRollbackException ee = new SIMPRollbackException(e.getMessage());
                ee.setStackTrace(e.getStackTrace());
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1424:1.329.1.1", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)ee);
                }
                throw ee;
            }
            catch (SIConnectionLostException e) {
                this.handleRollback(siTran);
                SIMPConnectionLostException ee = new SIMPConnectionLostException(e.getMessage());
                ee.setStackTrace(e.getStackTrace());
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1441:1.329.1.1", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)ee);
                }
                throw ee;
            }
            catch (SIIncorrectCallException e) {
                this.handleRollback(siTran);
                SIMPIncorrectCallException ee = new SIMPIncorrectCallException(e.getMessage());
                ee.setStackTrace(e.getStackTrace());
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1458:1.329.1.1", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)ee);
                }
                throw ee;
            }
            catch (SIResourceException e) {
                this.handleRollback(siTran);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)((Object)e));
                }
                SIMPResourceException ee = new SIMPResourceException((Throwable)e);
                ee.setExceptionReason(901);
                ee.setExceptionInserts(new String[]{"com.ibm.ws.sib.processor.impl.ProducerSessionImpl.handleMessage", "1:1475:1.329.1.1", SIMPUtils.getStackTrace(e)});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"localPut", (Object)ee);
                }
                throw ee;
            }
            msg.releaseJsMessage();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"localPut");
        }
    }

    private void remotePut(MessageItem msg, SIBUuid8 sourceMEUuid) throws SIResourceException, SIDiscriminatorSyntaxException {
        SIBUuid12 stream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remotePut", (Object)new Object[]{msg, sourceMEUuid});
        }
        if (!this._originStreamMap.containsKey(stream = msg.getMessage().getGuaranteedStreamUUID())) {
            this._originStreamMap.put(stream, sourceMEUuid);
        }
        MessageProcessorSearchResults searchResults = this.matchMessage(msg);
        String topic = msg.getMessage().getDiscriminator();
        HashMap allPubSubOutputHandlers = this._destination.getAllPubSubOutputHandlers();
        List matchingPubsubOutputHandlers = searchResults.getPubSubOutputHandlers(topic);
        if (allPubSubOutputHandlers != null && allPubSubOutputHandlers.size() > 0) {
            this.remoteToRemotePut(msg, allPubSubOutputHandlers, matchingPubsubOutputHandlers);
        }
        this._destination.unlockPubsubOutputHandlers();
        Set consumerDispatchers = searchResults.getConsumerDispatchers(topic);
        if (consumerDispatchers != null && consumerDispatchers.size() > 0) {
            msg.setSearchResults(searchResults);
            this.remoteToLocalPut(msg);
        } else {
            this.remoteToLocalPutSilence(msg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remotePut");
        }
    }

    private void remoteToRemotePut(MessageItem msg, HashMap allPubSubOutputHandlers, List matchingPubsubOutputHandlers) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToRemotePut", (Object)new Object[]{msg, matchingPubsubOutputHandlers});
        }
        boolean checkMatches = false;
        ArrayList<SIBUuid8> routes = null;
        Iterator itr = allPubSubOutputHandlers.values().iterator();
        JsMessage jsMessage = null;
        if (matchingPubsubOutputHandlers != null && matchingPubsubOutputHandlers.size() > 0) {
            routes = new ArrayList<SIBUuid8>(matchingPubsubOutputHandlers.size());
            checkMatches = true;
        }
        while (itr.hasNext()) {
            PubSubOutputHandler handler = (PubSubOutputHandler)itr.next();
            if (checkMatches && matchingPubsubOutputHandlers.contains(handler)) {
                if (!handler.okToForward(msg)) continue;
                this._internalInputStreamManager.processMessage(msg.getMessage());
                if (jsMessage == null) {
                    try {
                        boolean persistedAfterRestart;
                        boolean bl = persistedAfterRestart = msg.getReliability().compareTo((Object)Reliability.RELIABLE_PERSISTENT) > 0;
                        if (persistedAfterRestart) {
                            jsMessage = msg.getMessage().getReceived();
                            jsMessage.setBus(this._messageProcessor.getMessagingEngineBus());
                            MessageItem msg2 = new MessageItem(jsMessage);
                            msg2.setFromRemoteME(msg.isFromRemoteME());
                            msg2.setCurrentMEArrivalTimestamp(msg.getCurrentMEArrivalTimestamp());
                            msg = msg2;
                        } else {
                            jsMessage = msg.getMessage();
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.remoteToRemotePut", (String)"1:1660:1.329.1.1", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"remoteToRemotePut", (Object)e);
                        }
                        throw new SIResourceException((Throwable)e);
                    }
                }
                handler.put(msg, null, this, true);
                if (handler.isLink()) {
                    handler.sendLinkMessage(msg, false);
                    continue;
                }
                SIBUuid8 targetMEUuid = handler.getTargetMEUuid();
                routes.add(targetMEUuid);
                continue;
            }
            if (!handler.okToForward(msg)) continue;
            handler.putSilence(msg);
        }
        if (routes != null && routes.size() != 0) {
            SIBUuid8[] fromTo = new SIBUuid8[routes.size()];
            fromTo = routes.toArray(fromTo);
            this._mpio.sendDownTree(fromTo, msg.getPriority(), (AbstractMessage)msg.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToRemotePut");
        }
    }

    protected void remoteToLocalPutSilence(MessageItem msgItem) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteToLocalPutSilence", (Object)new Object[]{msgItem});
        }
        this._targetStreamManager.handleSilence(msgItem);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteToLocalPutSilence");
        }
    }

    private MessageProcessorSearchResults matchMessage(MessageItem msg) throws SIDiscriminatorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"matchMessage", (Object)new Object[]{msg});
        }
        JsMessage jsMsg = msg.getMessage();
        TopicAuthorization topicAuth = this._messageProcessor.getDiscriminatorAccessChecker();
        MessageProcessorSearchResults searchResults = new MessageProcessorSearchResults(topicAuth);
        int redelCount = msg.guessRedeliveredCount();
        if (redelCount > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set deliverycount into message: " + redelCount));
            }
            jsMsg.setDeliveryCount(redelCount);
        }
        this._matchspace.retrieveMatchingOutputHandlers(this._destination, jsMsg.getDiscriminator(), (MatchSpaceKey)jsMsg, searchResults);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"matchMessage", (Object)new Object[]{searchResults});
        }
        return searchResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean localFanOut(MessageItem msg, TransactionCommon tran, boolean stored) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)PubSubInputHandler.tc, (String)"localFanOut", (Object)new Object[]{msg, tran, new Boolean(stored)});
        }
        notBestEffort = msg.getReliability().compareTo((Object)Reliability.BEST_EFFORT_NONPERSISTENT) > 0;
        isTransacted = msg.isTransacted();
        searchResults = this.matchMessage(msg);
        topic = msg.getMessage().getDiscriminator();
        jsMsg = msg.getMessage();
        matchingPubsubOutputHandlers = searchResults.getPubSubOutputHandlers(topic);
        ref = null;
        sourceStreamUpdated = false;
        proxyRefStreamUpdated = false;
        if (matchingPubsubOutputHandlers != null && matchingPubsubOutputHandlers.size() > 0) {
            fromTo = null;
            if (notBestEffort || !isTransacted) {
                allPubSubOutputHandlers = this._destination.getAllPubSubOutputHandlers();
                try {
                    itr = allPubSubOutputHandlers.values().iterator();
                    i = 0;
                    while (itr.hasNext()) {
                        handler = (PubSubOutputHandler)itr.next();
                        if (!handler.okToForward(msg)) continue;
                        if (!sourceStreamUpdated) {
                            this.setPropertiesInMessage(jsMsg, this._destination.getUuid(), msg.getProducerConnectionUuid());
                            this._sourceStreamManager.addMessage(msg);
                            sourceStreamUpdated = true;
                        }
                        if (matchingPubsubOutputHandlers.contains(handler)) {
                            if (!proxyRefStreamUpdated) {
                                if (notBestEffort) {
                                    if (!stored) {
                                        this.storeMessage(msg, tran);
                                    }
                                    stored = true;
                                    ref = this.addProxyReference(msg, searchResults, tran);
                                } else if (isTransacted) {
                                    msg.setSearchResults(searchResults);
                                    msg.registerMessageEventListener(9, this);
                                } else {
                                    fromTo = new ArrayList<SIBUuid8>(matchingPubsubOutputHandlers.size());
                                }
                                proxyRefStreamUpdated = true;
                            }
                            stored = handler.put(msg, tran, this, stored);
                            if (notBestEffort) continue;
                            jsMsg.setBus(this._messageProcessor.getMessagingEngineBus());
                            if (handler.isLink()) {
                                handler.sendLinkMessage(msg, false);
                                continue;
                            }
                            targetCellule = handler.getTargetMEUuid();
                            fromTo.add(targetCellule);
                            ++i;
                            if (!TraceComponent.isAnyTracingEnabled() || !UserTrace.tc_mt.isDebugEnabled()) continue;
                            UserTrace.traceOutboundSend(jsMsg, handler.getTargetMEUuid(), this._destination.getName(), this._destination.isForeignBus() != false || this._destination.isLink() != false, this._destination.isMQLink(), this._destination.isTemporary());
                            continue;
                        }
                        if (!notBestEffort) continue;
                        handler.putSilence(msg);
                    }
                    if (i <= 0) ** GOTO lbl80
                    fromToArray = fromTo.toArray(new SIBUuid8[fromTo.size()]);
                    this._mpio.sendDownTree(fromToArray, msg.getPriority(), (AbstractMessage)jsMsg);
                }
                finally {
                    this._destination.unlockPubsubOutputHandlers();
                }
            } else {
                itr = this._destination.getAllPubSubOutputHandlers().values().iterator();
                try {
                    while (itr.hasNext()) {
                        handler = (PubSubOutputHandler)itr.next();
                        if (!handler.okToForward(msg) || !matchingPubsubOutputHandlers.contains(handler)) continue;
                        msg.setSearchResults(searchResults);
                        msg.registerMessageEventListener(9, this);
                    }
                }
                finally {
                    this._destination.unlockPubsubOutputHandlers();
                }
            }
        } else if (msg.getRequiresNewId() || jsMsg.getSystemMessageId() == null) {
            jsMsg.setSystemMessageSourceUuid(this._messageProcessor.getMessagingEngineUuid());
            jsMsg.setSystemMessageValue(this._messageProcessor.nextTick());
            msg.setRequiresNewId(false);
        }
lbl80:
        // 7 sources

        stored = this.deliverToConsumerDispatchers(searchResults, msg, tran, stored);
        if (TraceComponent.isAnyTracingEnabled() && PubSubInputHandler.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)PubSubInputHandler.tc, (String)"localFanOut", (Object)new Boolean(stored));
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean restoreFanOut(MessageItemReference ref, boolean commitInsert) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restoreFanOut", (Object)new Object[]{ref, new Boolean(commitInsert)});
        }
        boolean keepReference = true;
        MessageItem msg = null;
        try {
            msg = (MessageItem)ref.getReferredItem();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.restoreFanOut", (String)"1:2102:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restoreFanOut", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        MessageProcessorSearchResults searchResults = this.matchMessage(msg);
        String topic = msg.getMessage().getDiscriminator();
        List matchingPubsubOutputHandlers = searchResults.getPubSubOutputHandlers(topic);
        if (matchingPubsubOutputHandlers != null && matchingPubsubOutputHandlers.size() > 0) {
            HashMap allPubSubOutputHandlers = this._destination.getAllPubSubOutputHandlers();
            try {
                for (PubSubOutputHandler handler : allPubSubOutputHandlers.values()) {
                    if (!handler.okToForward(msg)) continue;
                    if (matchingPubsubOutputHandlers.contains(handler)) {
                        handler.putInsert(msg, commitInsert);
                        continue;
                    }
                    handler.putSilence(msg);
                }
            }
            finally {
                this._destination.unlockPubsubOutputHandlers();
            }
        } else {
            keepReference = false;
        }
        if (keepReference && !commitInsert) {
            ref.setSearchResults(searchResults);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restoreFanOut");
        }
        return keepReference;
    }

    private boolean deliverToConsumerDispatchers(MessageProcessorSearchResults searchResults, MessageItem msg, TransactionCommon tran, boolean stored) throws SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deliverToConsumerDispatchers", (Object)new Object[]{searchResults, msg, tran, new Boolean(stored)});
        }
        String topic = msg.getMessage().getDiscriminator();
        boolean hasInternalSubscription = false;
        Set consumerDispatchers = searchResults.getConsumerDispatchers(topic);
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && msg.getMessage().isApiMessage()) {
            String apiMsgId = null;
            if (msg.getMessage() instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)msg.getMessage()).getApiMessageId();
            } else if (msg.getMessage().getApiMessageIdAsBytes() != null) {
                apiMsgId = msg.getMessage().getApiMessageIdAsBytes().toString();
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("PUBLICATION_COUNT_CWSJU0008", new Object[]{apiMsgId, this._destination.getName(), new Integer(consumerDispatchers.size())}, null));
        }
        if (consumerDispatchers != null) {
            Iterator i = consumerDispatchers.iterator();
            while (i.hasNext()) {
                ConsumerDispatcher consumerDispatcher = ((MatchingConsumerDispatcher)i.next()).getConsumerDispatcher();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found consumerDispatcher: " + consumerDispatcher.getConsumerDispatcherState()));
                }
                if (consumerDispatcher.getConsumerDispatcherState().isReady()) {
                    stored = consumerDispatcher.put(msg, tran, this, stored);
                }
                hasInternalSubscription |= consumerDispatcher.getConsumerDispatcherState().getTargetDestination() != null;
            }
            msg.setFanOut(consumerDispatchers.size());
        }
        stored |= hasInternalSubscription;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverToConsumerDispatchers", (Object)new Boolean(stored));
        }
        return stored;
    }

    private MessageItemReference addProxyReference(MessageItem msg, MessageProcessorSearchResults matchingPubsubOutputHandlers, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addProxyReference", (Object)new Object[]{msg, tran});
        }
        MessageItemReference ref = new MessageItemReference(msg);
        msg.addPersistentRef();
        ref.setSearchResults(matchingPubsubOutputHandlers);
        try {
            ref.registerMessageEventListener(2, this);
            ref.registerMessageEventListener(4, this);
            Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
            this._proxyReferenceStream.add(ref, msTran);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addProxyReference", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.addProxyReference", (String)"1:2315:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2322:1.329.1.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addProxyReference", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2332:1.329.1.1", e}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addProxyReference");
        }
        return ref;
    }

    void referenceCountZeroCallback(MessageItem msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"referenceCountZeroCallback", (Object)msg);
        }
        LockingCursor getCursor = null;
        try {
            getCursor = this._itemStream.newLockingItemCursor(null);
            msg.lockItemIfAvailable(getCursor.getLockID());
            msg.remove((Transaction)this._txManager.createAutoCommitTransaction(), msg.getLockID());
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.referenceCountZeroCallback", (String)"1:2359:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"referenceCountZeroCallback", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        finally {
            getCursor.finished();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"referenceCountZeroCallback");
        }
    }

    void recordDurableSub(MessageItem msg, String durableSubId, TransactionCommon transaction) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendAckExpectedMessage(long ackExpStamp, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(ackExpStamp), new Integer(priority), reliability, stream});
        }
        HashMap allPubSubOutputHandlers = this._destination.getAllPubSubOutputHandlers();
        try {
            for (PubSubOutputHandler handler : allPubSubOutputHandlers.values()) {
                handler.processAckExpected(ackExpStamp, priority, reliability, stream);
            }
        }
        finally {
            this._destination.unlockPubsubOutputHandlers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    @Override
    public void sendSilenceMessage(long startStamp, long endStamp, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 stream) {
    }

    private ControlSilence createSilenceMessage(long tick, long completedPrefix, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(tick), new Long(completedPrefix), new Integer(priority), reliability, stream});
        }
        ControlSilence sMsg = null;
        try {
            sMsg = this._cmf.createNewControlSilence();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createSilenceMessage", (String)"1:2471:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2477:1.329.1.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2487:1.329.1.1", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)sMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destination.getUuid(), ProtocolType.PUBSUBOUTPUT, GDConfig.PROTOCOL_VERSION);
        sMsg.setStartTick(tick);
        sMsg.setEndTick(tick);
        sMsg.setPriority(priority);
        sMsg.setReliability(reliability);
        sMsg.setCompletedPrefix(completedPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)sMsg);
        }
        return sMsg;
    }

    @Override
    public List sendValueMessages(List msgList, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 stream) {
        return null;
    }

    @Override
    public MessageItem getValueMessage(long msgStoreID) throws SIResourceException {
        return null;
    }

    private ControlAck createControlAckMessage(int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlAck ackMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAckMessage");
        }
        try {
            ackMsg = this._cmf.createNewControlAck();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createControlAckMessage", (String)"1:2567:1.329.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2579:1.329.1.1", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2587:1.329.1.1", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)ackMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destination.getUuid(), ProtocolType.PUBSUBOUTPUT, GDConfig.PROTOCOL_VERSION);
        ackMsg.setPriority(priority);
        ackMsg.setReliability(reliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAckMessage");
        }
        return ackMsg;
    }

    private ControlNack createControlNackMessage(int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNackMessage", (Object)new Object[]{new Integer(priority), reliability, stream});
        }
        ControlNack nackMsg = null;
        try {
            nackMsg = this._cmf.createNewControlNack();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.createControlNackMessage", (String)"1:2643:1.329.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2655:1.329.1.1", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2663:1.329.1.1", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)nackMsg, this._messageProcessor.getMessagingEngineUuid(), null, stream, null, this._destination.getUuid(), ProtocolType.PUBSUBOUTPUT, GDConfig.PROTOCOL_VERSION);
        nackMsg.setPriority(priority);
        nackMsg.setReliability(reliability);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNackMessage");
        }
        return nackMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverOrderedMessages(List msgList, GuaranteedTargetStream targetStream, int priority, Reliability reliability) throws SIDiscriminatorSyntaxException {
        block24: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deliverOrderedMessages", (Object)new Object[]{msgList, targetStream, new Integer(priority), reliability});
            }
            TransactionCommon tran = this._targetBatchHandler.registerInBatch();
            boolean messageAddCall = false;
            try {
                MessageItem msgItem = null;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Get the tick from list of length: " + msgList.size()));
                }
                msgItem = (MessageItem)msgList.get(msgList.size() - 1);
                long endTick = msgItem.getMessage().getGuaranteedValueEndTick();
                if (targetStream.getDoubtHorizon() <= endTick) break block24;
                int lastSuccessfulMsg = -1;
                long lastSuccessfulEndTick = -1L;
                long currentEndTick = -1L;
                int length = msgList.size();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Process message list of length: " + length));
                }
                int i = 0;
                while (i < length) {
                    boolean resetRequired = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Deliver message: " + i));
                    }
                    try {
                        msgItem = (MessageItem)msgList.get(i);
                        currentEndTick = msgItem.getMessage().getGuaranteedValueEndTick();
                        msgItem.setTransacted(true);
                        MessageProcessorSearchResults searchResults = msgItem.getSearchResults();
                        this.deliverToConsumerDispatchers(searchResults, msgItem, tran, false);
                        lastSuccessfulMsg = i++;
                        lastSuccessfulEndTick = currentEndTick;
                        resetRequired = false;
                        msgItem.releaseJsMessage();
                    }
                    catch (SIResourceException e) {
                        break;
                    }
                    finally {
                        if (resetRequired) {
                            targetStream.resetDoubtHorizon(currentEndTick);
                        }
                    }
                }
                if (lastSuccessfulMsg != -1) {
                    messageAddCall = true;
                    targetStream.setNextCompletedPrefix(lastSuccessfulEndTick);
                    try {
                        this._targetBatchHandler.messagesAdded(lastSuccessfulMsg + 1, targetStream);
                    }
                    catch (SIResourceException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                }
            }
            finally {
                block25: {
                    if (!messageAddCall) {
                        try {
                            this._targetBatchHandler.messagesAdded(0);
                        }
                        catch (SIResourceException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block25;
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deliverOrderedMessages", (Object)new Boolean(messageAddCall));
                }
            }
        }
    }

    @Override
    public void deliverExpressMessage(MessageItem msgItem, ExpressTargetStream expressTargetStream) throws SIResourceException, SIIncorrectCallException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deliverExpressMessage", (Object)new Object[]{msgItem});
        }
        LocalTransaction siTran = this._txManager.createLocalTransaction(false);
        try {
            long endTick = msgItem.getMessage().getGuaranteedValueValueTick();
            msgItem.setTransacted(true);
            MessageProcessorSearchResults searchResults = msgItem.getSearchResults();
            boolean stored = this.deliverToConsumerDispatchers(searchResults, msgItem, (TransactionCommon)siTran, false);
            expressTargetStream.setCompletedPrefix(endTick);
            if (stored) {
                siTran.commit();
            } else {
                siTran.rollback();
            }
        }
        catch (SIResourceException e) {
            this.handleRollback(siTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.deliverExpressMessage", (String)"1:2908:1.329.1.1", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)e);
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)e);
            }
            throw e;
        }
        catch (SIIncorrectCallException e) {
            this.handleRollback(siTran);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deliverExpressMessage");
        }
    }

    @Override
    public BrowseCursor getBrowseCursor(SelectionCriteria criteria) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrowseCursor", (Object)criteria);
        }
        NonLockingCursor msgStoreCur = null;
        MessageSelectorFilter filter = null;
        JSBrowseCursor cursor = null;
        try {
            if (criteria != null && (criteria.getSelectorString() != null && !criteria.getSelectorString().equals("") || criteria.getDiscriminator() != null && !criteria.getDiscriminator().equals(""))) {
                filter = new MessageSelectorFilter(this._messageProcessor, criteria);
            }
            msgStoreCur = this._itemStream.newNonLockingItemCursor(filter);
            cursor = new JSBrowseCursor(msgStoreCur);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.getBrowseCursor", (String)"1:2962:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2969:1.329.1.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:2977:1.329.1.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrowseCursor", (Object)cursor);
        }
        return cursor;
    }

    @Override
    public void storeMessage(MessageItem msg, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"storeMessage", (Object)new Object[]{msg, tran});
        }
        try {
            if (tran == null) {
                tran = this._txManager.createAutoCommitTransaction();
            }
            this._destination.registerForMessageEvents(msg);
            Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
            this._itemStream.addItem(msg, msTran);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"storeMessage", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.storeMessage", (String)"1:3018:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3023:1.329.1.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"storeMessage", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3031:1.329.1.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"storeMessage");
        }
    }

    @Override
    public ItemStream getItemStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getItemStream");
            SibTr.exit((TraceComponent)tc, (String)"getItemStream", (Object)this._itemStream);
        }
        return this._itemStream;
    }

    public void setPropertiesInMessage(JsMessage jsMsg, SIBUuid12 destinationUuid, SIBUuid12 producerConnectionUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPropertiesInMessage", (Object)new Object[]{jsMsg, destinationUuid, producerConnectionUuid});
        }
        SIMPUtils.setGuaranteedDeliveryProperties(jsMsg, this._messageProcessor.getMessagingEngineUuid(), null, null, null, destinationUuid, ProtocolType.PUBSUBINPUT, GDConfig.PROTOCOL_VERSION);
        if (jsMsg.getConnectionUuid() == null) {
            jsMsg.setConnectionUuid(producerConnectionUuid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setPropertiesInMessage");
        }
    }

    public void reconstitutePubSubSourceStreams(StreamSet streamSet, int startMode) throws SIErrorException, SIDiscriminatorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)new Object[]{streamSet, new Integer(startMode)});
        }
        this._sourceStreamManager.reconstituteStreamSet(streamSet);
        if ((startMode & 1) == 1 && (startMode & 2) == 0) {
            this.sendFlushedMessage(null, streamSet.getStreamID());
            streamSet.setStreamID(new SIBUuid12());
            ExternalAutoCommitTransaction tran = this._txManager.createAutoCommitTransaction();
            try {
                streamSet.requestUpdate((Transaction)tran);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.reconstitutePubSubSourceStreams", (String)"1:3145:1.329.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        try {
            NonLockingCursor cursor = this._proxyReferenceStream.newNonLockingCursor(new ClassEqualsFilter(MessageItemReference.class));
            cursor.allowUnavailableItems();
            MessageItemReference ref = (MessageItemReference)cursor.next();
            LocalTransaction siTran = null;
            Transaction msTran = null;
            int batchCount = 0;
            while (ref != null) {
                if (batchCount >= 50) {
                    try {
                        siTran.commit();
                        siTran = null;
                    }
                    catch (SIIncorrectCallException e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)"SIResourceException");
                        }
                        throw new SIResourceException((Throwable)e);
                    }
                }
                if (siTran == null) {
                    siTran = this._txManager.createLocalTransaction(true);
                    msTran = (Transaction)siTran;
                    batchCount = 0;
                }
                boolean commitInsert = false;
                if (ref.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    ref.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!ref.isAdding() && !ref.isRemoving()) {
                    commitInsert = true;
                }
                if (!(this.restoreFanOut(ref, commitInsert) || ref.isAdding() || ref.isRemoving())) {
                    ref.remove(msTran, ref.getLockID());
                    ++batchCount;
                }
                ref = (MessageItemReference)cursor.next();
            }
            try {
                if (siTran != null) {
                    siTran.commit();
                }
            }
            catch (SIIncorrectCallException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)"SIResourceException");
                }
                throw new SIResourceException((Throwable)e);
            }
            cursor.finished();
            cursor = this._proxyReferenceStream.newNonLockingCursor(new ClassEqualsFilter(MessageItemReference.class));
            cursor.allowUnavailableItems();
            ref = (MessageItemReference)cursor.next();
            while (ref != null) {
                if (ref.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    ref.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!ref.isAdding() && !ref.isRemoving()) {
                    this._sourceStreamManager.restoreMessage(ref, true);
                } else {
                    this._sourceStreamManager.restoreMessage(ref, false);
                }
                ref = (MessageItemReference)cursor.next();
            }
            this._sourceStreamManager.consolidateStreams(startMode);
            cursor.finished();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.reconstitutePubSubSourceStreams", (String)"1:3277:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3284:1.329.1.1", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3295:1.329.1.1", e}, null), (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitutePubSubSourceStreams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendFlushedMessage(SIBUuid8 ignore, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{streamID});
        }
        HashMap allPubSubOutputHandlers = this._destination.getAllPubSubOutputHandlers();
        try {
            for (PubSubOutputHandler handler : allPubSubOutputHandlers.values()) {
                handler.sendFlushedMessage(null, streamID);
                handler.removeStream(streamID);
            }
        }
        finally {
            this._destination.unlockPubsubOutputHandlers();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    @Override
    public void sendNotFlushedMessage(SIBUuid8 target, SIBUuid12 streamID, long requestID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{target, streamID, new Long(requestID)});
        }
        InvalidOperationException e = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3366:1.329.1.1"}, null));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3372:1.329.1.1"});
        FFDCFilter.processException((Throwable)((Object)e), (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.sendNotFlushedMessage", (String)"1:3378:1.329.1.1", (Object)this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    @Override
    public void sendAreYouFlushedMessage(SIBUuid8 upstream, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAreYouFlushedMessage", (Object)new Object[]{upstream, new Long(queryID), streamID});
        }
        ControlAreYouFlushed flushQuery = this.createControlAreYouFlushed(upstream, queryID, streamID);
        this._mpio.sendToMe(upstream, 9, (AbstractMessage)flushQuery);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAreYouFlushedMessage");
        }
    }

    @Override
    public void sendRequestFlushMessage(SIBUuid8 upstream, SIBUuid12 destUuid, SIBUuid8 busUuid, long queryID, SIBUuid12 streamID, boolean indoubtDiscard) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendRequestFlushMessage", (Object)new Object[]{upstream, new Long(queryID), streamID});
        }
        ControlRequestFlush flushRequest = this.createControlRequestFlush(upstream, queryID, streamID);
        flushRequest.setIndoubtDiscard(indoubtDiscard);
        this._mpio.sendToMe(upstream, 9, (AbstractMessage)flushRequest);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendRequestFlushMessage");
        }
    }

    public void startFlush(FlushComplete complete) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, FlushAlreadyInProgressException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush", (Object)complete);
        }
        this._sourceStreamManager.startFlush(complete);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    private void traceSend(MessageItem message) {
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && message.getMessage().isApiMessage()) {
            String text = "PRODUCER_SEND_TOPICSPACE_CWSJU0005";
            if (this._destination.isTemporary()) {
                text = "PRODUCER_SEND_TEMPORARY_TOPICSPACE_CWSJU0102";
            }
            String apiMsgId = null;
            String correlationId = null;
            if (message.getMessage() instanceof JsApiMessage) {
                apiMsgId = ((JsApiMessage)message.getMessage()).getApiMessageId();
                correlationId = ((JsApiMessage)message.getMessage()).getCorrelationId();
            } else {
                if (message.getMessage().getApiMessageIdAsBytes() != null) {
                    apiMsgId = new String(message.getMessage().getApiMessageIdAsBytes());
                }
                if (message.getMessage().getCorrelationIdAsBytes() != null) {
                    correlationId = new String(message.getMessage().getCorrelationIdAsBytes());
                }
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage(text, new Object[]{apiMsgId, correlationId, this._destination.getName()}, null));
        }
    }

    private void eventPostCommit(SIMPMessage msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommit", (Object)msg);
        }
        MessageItem msgItem = (MessageItem)msg;
        JsMessage jsMsg = msgItem.getMessage();
        MessageItem msgItemCopy = null;
        JsMessage jsMsgCopy = null;
        MessageProcessorSearchResults searchResults = msgItem.getSearchResults();
        boolean sourceStreamUpdated = false;
        List matchingPubsubOutputHandlers = searchResults.getPubSubOutputHandlers(null);
        ArrayList<SIBUuid8> fromTo = new ArrayList<SIBUuid8>(matchingPubsubOutputHandlers.size());
        Iterator itr = matchingPubsubOutputHandlers.iterator();
        int i = 0;
        while (itr.hasNext()) {
            PubSubOutputHandler outputHandler = (PubSubOutputHandler)itr.next();
            if (!outputHandler.okToForward(msgItem)) continue;
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                UserTrace.traceOutboundSend(jsMsg, outputHandler.getTargetMEUuid(), this._destination.getName(), this._destination.isForeignBus() || this._destination.isLink(), this._destination.isMQLink(), this._destination.isTemporary());
            }
            if (!sourceStreamUpdated) {
                try {
                    jsMsgCopy = jsMsg.getReceived();
                    msgItemCopy = new MessageItem(jsMsgCopy);
                }
                catch (MessageCopyFailedException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.eventPostCommit", (String)"1:3562:1.329.1.1", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.exit((TraceComponent)tc, (String)"eventPostCommit", (Object)((Object)e));
                    }
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3574:1.329.1.1", e});
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PubSubInputHandler", "1:3582:1.329.1.1", e}, null), (Throwable)e);
                }
                this.setPropertiesInMessage(jsMsgCopy, this._destination.getUuid(), msgItemCopy.getProducerConnectionUuid());
                jsMsgCopy.setBus(this._messageProcessor.getMessagingEngineBus());
                this._sourceStreamManager.addMessage(msgItemCopy);
                sourceStreamUpdated = true;
            }
            outputHandler.put(msgItemCopy, null, null, false);
            if (outputHandler.isLink()) {
                outputHandler.sendLinkMessage(msgItemCopy, false);
                continue;
            }
            SIBUuid8 targetMEUuid = outputHandler.getTargetMEUuid();
            fromTo.add(targetMEUuid);
            ++i;
        }
        if (i > 0) {
            SIBUuid8[] fromToArray = fromTo.toArray(new SIBUuid8[fromTo.size()]);
            this._mpio.sendDownTree(fromToArray, msgItemCopy.getPriority(), (AbstractMessage)jsMsgCopy);
        }
        msgItem.setSearchResults(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDeleteSource() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDeleteSource");
        }
        PubSubInputHandler pubSubInputHandler = this;
        synchronized (pubSubInputHandler) {
            if (this._flushedForDeleteSource) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this._deleteFlushSource != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.FALSE);
                }
                return false;
            }
            final PubSubInputHandler psIH = this;
            this._deleteFlushSource = new FlushComplete(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flushComplete(DestinationHandler destinationHandler) {
                    PubSubInputHandler pubSubInputHandler = psIH;
                    synchronized (pubSubInputHandler) {
                        psIH._flushedForDeleteSource = true;
                        psIH._deleteFlushSource = null;
                    }
                    ((BaseDestinationHandler)psIH._destination).deleteAllPubSubOutputHandlers();
                    psIH._messageProcessor.getDestinationManager().startAsynchDeletion();
                }
            };
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)("Started source flush for destination: " + this._destination.getName()));
            }
            this.startFlush(this._deleteFlushSource);
        }
        catch (FlushAlreadyInProgressException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.flushAllForDeleteSource", (String)"1:3718:1.329.1.1", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)"FlushAlreadyInProgressException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteSource", (Object)Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDeleteTarget() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDeleteTarget");
        }
        PubSubInputHandler pubSubInputHandler = this;
        synchronized (pubSubInputHandler) {
            if (this._flushedForDeleteTarget) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this._deleteFlushTarget != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.FALSE);
                }
                return false;
            }
            if (this._targetStreamManager.isEmpty()) {
                this._flushedForDeleteTarget = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.TRUE);
                }
                return true;
            }
            this._deleteFlushTarget = new AlarmListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void alarm(Object al) {
                    block10: {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)al);
                        }
                        PubSubInputHandler psIH = (PubSubInputHandler)al;
                        if (psIH._targetStreamManager.isEmpty()) {
                            PubSubInputHandler pubSubInputHandler = psIH;
                            synchronized (pubSubInputHandler) {
                                psIH._flushedForDeleteTarget = true;
                                psIH._deleteFlushTarget = null;
                            }
                            psIH._messageProcessor.getDestinationManager().startAsynchDeletion();
                        } else {
                            try {
                                psIH._targetStreamManager.queryUnflushedStreams();
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                    SibTr.event((TraceComponent)tc, (String)("Querying target for flush on destination: " + PubSubInputHandler.this._destination.getName()));
                                }
                                psIH._messageProcessor.getAlarmManager().create(3000L, this, psIH);
                            }
                            catch (SIResourceException e) {
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PubSubInputHandler.alarm", (String)"1:3815:1.329.1.1", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                                SibTr.event((TraceComponent)tc, (String)"Target flushed cancelled by SIResourceException");
                            }
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"alarm");
                    }
                }
            };
            this._targetStreamManager.queryUnflushedStreams();
            this._messageProcessor.getAlarmManager().create(3000L, this._deleteFlushTarget, this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDeleteTarget", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public int checkAbleToAcceptMessage(JsDestinationAddress addr) {
        boolean canAccept;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkAbleToAcceptMessage", (Object)addr);
        }
        int blockingReason = 1;
        boolean bl = canAccept = !this._itemStream.isRemoteQueueHighLimit();
        if (!canAccept) {
            blockingReason = 3;
            long destHighMsg = this._itemStream.getDestHighMsgs();
            SibTr.info((TraceComponent)tc, (String)"NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0553", (Object)new Object[]{this._destination.getName(), this._messageProcessor.getMessagingEngineName(), destHighMsg});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkAbleToAcceptMessage", (Object)blockingReason);
        }
        return blockingReason;
    }

    @Override
    public int checkStillBlocked() {
        boolean isBlocked;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkStillBlocked");
        }
        int blockingReason = 1;
        boolean bl = isBlocked = !this._itemStream.isQLowRemoteLimit();
        if (isBlocked) {
            blockingReason = 3;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkStillBlocked", (Object)blockingReason);
        }
        return blockingReason;
    }

    @Override
    public void reportUnresolvedGap(String sourceMEUuid, long gap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportUnresolvedGap", (Object)new Object[]{sourceMEUuid, new Long(gap)});
        }
        SibTr.info((TraceComponent)tc, (String)"UNRESOLVED_GAP_IN_DESTINATION_TRANSMITTER_CWSIP0792", (Object)new Object[]{new Long(gap).toString(), this._destination.getName(), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportUnresolvedGap");
        }
    }

    @Override
    public void reportResolvedGap(String sourceMEUuid, long filledGap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportResolvedGap", (Object)new Object[]{sourceMEUuid, new Long(filledGap)});
        }
        SibTr.info((TraceComponent)tc, (String)"RESOLVED_GAP_IN_DESTINATION_TRANSMITTER_CWSIP0793", (Object)new Object[]{new Long(filledGap).toString(), this._destination.getName(), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportResolvedGap");
        }
    }

    @Override
    public void reportRepeatedMessages(String sourceMEUuid, int percent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportRepeatedMessages", (Object)new Object[]{sourceMEUuid, new Integer(percent)});
        }
        SibTr.info((TraceComponent)tc, (String)"REPEATED_MESSAGE_THRESHOLD_REACHED_ON_DESTINATION_CWSIP0795", (Object)new Object[]{new Integer(percent), SIMPUtils.getMENameFromUuid(sourceMEUuid), this._messageProcessor.getMessagingEngineName(), this._destination.getName()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportRepeatedMessages");
        }
    }

    @Override
    public long sendNackMessageWithReturnValue(SIBUuid8 source, SIBUuid12 destUuid, SIBUuid8 busUuid, long startTick, long endTick, int priority, Reliability reliability, SIBUuid12 streamID) throws SIResourceException {
        return 0L;
    }
}

