/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.internal.BNFHeadersImpl;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.HeaderField;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import java.nio.BufferUnderflowException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class HeaderElement
implements HeaderField,
Comparable<HeaderElement> {
    private static final TraceComponent tc = Tr.register(HeaderElement.class, (String)"GenericBNF", null);
    private static final int initHash = 629;
    private static final int ELEM_INIT = 0;
    private static final int ELEM_CHANGED = 1;
    private static final int ELEM_REMOVED = 2;
    private static final int ELEM_ADDED = 3;
    protected HeaderElement nextInstance = null;
    protected HeaderElement nextSequence = null;
    protected HeaderElement prevSequence = null;
    private HeaderKeys key = null;
    private int buffIndex = -1;
    private int offset = 0;
    private int valueLength = 0;
    private byte[] bValue = null;
    private String sValue = null;
    private BNFHeadersImpl myOwner;
    private int myHashCode = -1;
    private int status = 3;
    private int lastCRLFBufferIndex = -1;
    private int lastCRLFPosition = -1;
    private boolean lastCRLFisCR = false;

    HeaderElement(HeaderKeys header, BNFHeadersImpl owner) {
        this.key = header;
        this.myOwner = owner;
    }

    @Override
    public HeaderKeys getKey() {
        return this.key;
    }

    protected void setParseInformation(int index, int start) {
        this.buffIndex = index;
        this.offset = start;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set parse information " + this.buffIndex + " " + this.offset), (Object[])new Object[0]);
        }
    }

    protected void setValueLength(int len) {
        this.valueLength = len;
    }

    protected int getValueLength() {
        return this.valueLength;
    }

    protected int getOffset() {
        return this.offset;
    }

    private boolean extractInitialValue() {
        if (-1 == this.buffIndex) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extract: -1 index", (Object[])new Object[0]);
            }
            return false;
        }
        this.bValue = new byte[this.valueLength];
        WsByteBuffer buff = this.myOwner.getParseBuffer(this.buffIndex);
        int savePosition = buff.position();
        try {
            buff.position(this.offset);
            buff.get(this.bValue, 0, this.valueLength);
            buff.position(savePosition);
        }
        catch (BufferUnderflowException bue) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Header value straddled buffers", (Object[])new Object[0]);
            }
            int lengthNeeded = this.valueLength;
            int arrayOffset = 0;
            buff.position(this.offset);
            int spaceLeftInBuffer = buff.remaining();
            int index = this.buffIndex + 1;
            while (true) {
                if (lengthNeeded <= spaceLeftInBuffer) {
                    buff.get(this.bValue, arrayOffset, lengthNeeded);
                    buff.position(savePosition);
                    break;
                }
                buff.get(this.bValue, arrayOffset, spaceLeftInBuffer);
                buff.position(savePosition);
                lengthNeeded -= spaceLeftInBuffer;
                arrayOffset += spaceLeftInBuffer;
                buff = this.myOwner.getParseBuffer(index);
                ++index;
                savePosition = buff.position();
                buff.position(0);
                spaceLeftInBuffer = buff.limit();
            }
        }
        this.offset = 0;
        this.buffIndex = -1;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            this.sValue = GenericUtils.getEnglishString(this.bValue);
            Tr.debug((TraceComponent)tc, (String)("extractInitialValue parsed [" + this.getDebugValue() + "]"), (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public byte[] asBytes() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"byte[] value requested from empty structure", (Object[])new Object[0]);
            }
        } else if (this.valueLength != this.bValue.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracting value from larger input array", (Object[])new Object[0]);
            }
            byte[] temp = new byte[this.valueLength];
            System.arraycopy(this.bValue, this.offset, temp, 0, temp.length);
            this.bValue = temp;
            this.offset = 0;
            this.valueLength = temp.length;
        }
        return this.bValue;
    }

    protected byte[] asRawBytes() {
        if (null == this.bValue) {
            if (null != this.sValue) {
                this.bValue = GenericUtils.getEnglishBytes(this.sValue);
            } else if (!this.extractInitialValue() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"no byte[] value present", (Object[])new Object[0]);
            }
        }
        return this.bValue;
    }

    @Override
    public String asString() {
        if (null == this.sValue) {
            if (null == this.bValue && !this.extractInitialValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"String value requested from empty structure", (Object[])new Object[0]);
                }
                return null;
            }
            this.sValue = GenericUtils.getEnglishString(this.bValue, this.offset, this.offset + this.valueLength);
        }
        return this.sValue;
    }

    protected String getDebugValue() {
        if (this.key.shouldLogValue()) {
            return this.asString();
        }
        return GenericUtils.blockContents(this.asString());
    }

    @Override
    public Date asDate() throws ParseException {
        return HttpDispatcher.getDateFormatter().parseTime(this.asString());
    }

    @Override
    public int asInteger() {
        String value = this.asString();
        if (null != value) {
            return Integer.parseInt(value.trim());
        }
        throw new NumberFormatException("Missing value");
    }

    @Override
    public List<byte[]> asTokens(byte delimiter) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] input = this.asBytes();
        if (null == input || 0 == input.length) {
            return list;
        }
        byte[] token = null;
        int tokenStartPosition = 0;
        int tokenLength = 0;
        for (int i = 0; i < input.length; ++i) {
            if (32 == input[i] || delimiter == input[i]) {
                if (0 < tokenLength) {
                    token = new byte[tokenLength];
                    System.arraycopy(input, tokenStartPosition, token, 0, tokenLength);
                    list.add(token);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Parsed token [" + GenericUtils.getEnglishString(token) + "]"), (Object[])new Object[0]);
                    }
                }
                tokenLength = 0;
                tokenStartPosition = i + 1;
                continue;
            }
            ++tokenLength;
        }
        if (0 < tokenLength) {
            token = new byte[tokenLength];
            System.arraycopy(input, tokenStartPosition, token, 0, tokenLength);
            list.add(token);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Parsed token [" + GenericUtils.getEnglishString(token) + "]"), (Object[])new Object[0]);
            }
        }
        return list;
    }

    protected void setByteArrayValue(byte[] input) {
        this.sValue = null;
        this.bValue = input;
        this.offset = 0;
        this.valueLength = input.length;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    protected void setByteArrayValue(byte[] input, int offset, int length) {
        if (offset + length > input.length) {
            throw new IllegalArgumentException("Invalid length: " + offset + "+" + length + " > " + input.length);
        }
        this.sValue = null;
        this.bValue = input;
        this.offset = offset;
        this.valueLength = length;
        if (3 != this.status) {
            this.status = 1;
        }
    }

    protected void setStringValue(String input) {
        this.bValue = null;
        this.sValue = input;
        this.offset = 0;
        int n = this.valueLength = null == input ? 0 : input.length();
        if (3 != this.status) {
            this.status = 1;
        }
    }

    public boolean equals(Object inElem) {
        if (this == inElem) {
            return true;
        }
        if (!(inElem instanceof HeaderElement)) {
            return false;
        }
        return this.key.equals(((HeaderElement)inElem).getKey());
    }

    protected boolean isSameName(HeaderElement elem) {
        return this.key.getOrdinal() == elem.key.getOrdinal();
    }

    protected boolean isSameValue(HeaderElement elem) {
        return this.asString().equals(elem.asString());
    }

    protected boolean isSameValueIgnoreCase(HeaderElement elem) {
        return this.asString().equalsIgnoreCase(elem.asString());
    }

    public int hashCode() {
        if (-1 == this.myHashCode) {
            this.myHashCode = 629 + this.key.hashCode();
        }
        return this.myHashCode;
    }

    @Override
    public int compareTo(HeaderElement o) {
        if (this == o) {
            return 0;
        }
        return this.hashCode() - o.hashCode();
    }

    protected boolean wasRemoved() {
        return 2 == this.status;
    }

    protected boolean wasChanged() {
        return 1 == this.status;
    }

    protected boolean wasAdded() {
        return 3 == this.status;
    }

    protected void remove() {
        if (2 != this.status) {
            this.status = 2;
            this.myOwner.decrementHeaderCounter();
        }
    }

    protected void startTracking() {
        this.status = 0;
    }

    protected void updateLastCRLFInfo(int index, int pos, boolean isCR) {
        this.lastCRLFBufferIndex = index;
        this.lastCRLFPosition = pos;
        this.lastCRLFisCR = isCR;
    }

    protected int getLastCRLFPosition() {
        return this.lastCRLFPosition;
    }

    protected int getLastCRLFBufferIndex() {
        return this.lastCRLFBufferIndex;
    }

    protected boolean isLastCRLFaCR() {
        return this.lastCRLFisCR;
    }

    @Override
    public String getName() {
        return this.key.getName();
    }

    protected void destroy() {
        this.nextSequence = null;
        this.prevSequence = null;
        this.bValue = null;
        this.sValue = null;
        this.buffIndex = -1;
        this.offset = 0;
        this.valueLength = 0;
        this.myHashCode = -1;
        this.lastCRLFBufferIndex = -1;
        this.lastCRLFisCR = false;
        this.lastCRLFPosition = -1;
        this.status = 3;
        this.myOwner.freeElement(this);
    }

    protected void init(HeaderKeys name) {
        this.key = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append('[').append(this.key.getName()).append('=');
        sb.append(this.getDebugValue()).append("] ").append(this.status);
        return sb.toString();
    }
}

