/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastSerializableHashMap
implements Map,
Externalizable {
    private Map delegate = new HashMap();
    private static final long serialVersionUID = 8450249571767958267L;

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (ValueHolder valueHolder : this.delegate.values()) {
            if (!valueHolder.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        ValueHolder holder = (ValueHolder)this.delegate.get(key);
        if (holder == null) {
            return null;
        }
        return holder.getValue();
    }

    public Object put(Object key, Object value) {
        ValueHolder valueHolder = this.delegate.put(key, new ValueHolder(value));
        if (valueHolder == null) {
            return null;
        }
        return valueHolder.getValue();
    }

    public Object remove(Object key) {
        ValueHolder holder = (ValueHolder)this.delegate.remove(key);
        if (holder == null) {
            return null;
        }
        return holder.getValue();
    }

    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Set keySet() {
        return this.delegate.keySet();
    }

    public Collection values() {
        Collection c = this.delegate.values();
        ArrayList<Object> newC = new ArrayList<Object>(c.size());
        for (ValueHolder holder : c) {
            newC.add(holder.getValue());
        }
        return newC;
    }

    public Set entrySet() {
        Iterator entries = this.delegate.entrySet().iterator();
        HashSet<EntryDelegator> newEntries = new HashSet<EntryDelegator>();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            newEntries.add(new EntryDelegator(entry));
        }
        return newEntries;
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(8450249571767958267L);
        for (Map.Entry entry : this.delegate.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                out.writeByte(85);
                out.writeUTF((String)key);
            } else if (key instanceof Byte) {
                out.writeByte(66);
                out.writeByte(((Byte)key).byteValue());
            } else if (key instanceof Short) {
                out.writeByte(83);
                out.writeShort(((Short)key).shortValue());
            } else if (key instanceof Character) {
                out.writeByte(67);
                out.writeChar(((Character)key).charValue());
            } else if (key instanceof Integer) {
                out.writeByte(73);
                out.writeInt((Integer)key);
            } else if (key instanceof Long) {
                out.writeByte(74);
                out.writeLong((Long)key);
            } else if (key instanceof Float) {
                out.writeByte(70);
                out.writeFloat(((Float)key).floatValue());
            } else if (key instanceof Double) {
                out.writeByte(68);
                out.writeDouble((Double)key);
            } else if (key instanceof Boolean) {
                out.writeByte(90);
                out.writeBoolean((Boolean)key);
            } else {
                out.writeByte(76);
                out.writeObject(key);
            }
            ValueHolder holder = (ValueHolder)entry.getValue();
            holder.writeExternal(out);
        }
        out.writeByte(101);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readLong();
        byte keyByte = in.readByte();
        while (keyByte != 101) {
            Object key;
            switch (keyByte) {
                case 66: {
                    key = new Byte(in.readByte());
                    break;
                }
                case 67: {
                    key = new Character(in.readChar());
                    break;
                }
                case 83: {
                    key = new Short(in.readShort());
                    break;
                }
                case 73: {
                    key = new Integer(in.readInt());
                    break;
                }
                case 74: {
                    key = new Long(in.readLong());
                    break;
                }
                case 70: {
                    key = new Float(in.readFloat());
                    break;
                }
                case 68: {
                    key = new Double(in.readDouble());
                    break;
                }
                case 90: {
                    key = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 85: {
                    key = in.readUTF();
                    break;
                }
                case 76: {
                    key = in.readObject();
                    break;
                }
                default: {
                    throw new IOException("Unable to parse input stream");
                }
            }
            ValueHolder holder = new ValueHolder();
            holder.readExternal(in);
            this.delegate.put(key, holder);
            keyByte = in.readByte();
        }
    }

    private static class ValueHolder
    implements Externalizable {
        private Object _value;
        private byte[] _valueBytes;
        private static final long serialVersionUID = 6780206225209223097L;

        public ValueHolder() {
        }

        public ValueHolder(Object value) {
            this._value = value;
        }

        public void setValue(Object obj) {
            this._value = obj;
        }

        public Object getValue() {
            if (this._value != null) {
                return this._value;
            }
            if (this._value == null && this._valueBytes != null) {
                try {
                    ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(this._valueBytes));
                    this._value = in.readObject();
                    return this._value;
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            if (this._value instanceof String) {
                out.writeByte(85);
                out.writeUTF((String)this._value);
            } else if (this._value instanceof Byte) {
                out.writeByte(66);
                out.writeByte(((Byte)this._value).byteValue());
            } else if (this._value instanceof Short) {
                out.writeByte(83);
                out.writeShort(((Short)this._value).shortValue());
            } else if (this._value instanceof Character) {
                out.writeByte(67);
                out.writeChar(((Character)this._value).charValue());
            } else if (this._value instanceof Integer) {
                out.writeByte(73);
                out.writeInt((Integer)this._value);
            } else if (this._value instanceof Long) {
                out.writeByte(74);
                out.writeLong((Long)this._value);
            } else if (this._value instanceof Float) {
                out.writeByte(70);
                out.writeFloat(((Float)this._value).floatValue());
            } else if (this._value instanceof Double) {
                out.writeByte(68);
                out.writeDouble((Double)this._value);
            } else if (this._value instanceof Boolean) {
                out.writeByte(90);
                out.writeBoolean((Boolean)this._value);
            } else {
                if (this._valueBytes == null) {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
                    objOut.writeObject(this._value);
                    this._valueBytes = byteOut.toByteArray();
                }
                out.writeByte(76);
                out.writeInt(this._valueBytes.length);
                out.write(this._valueBytes);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte valueByte = in.readByte();
            switch (valueByte) {
                case 66: {
                    this._value = new Byte(in.readByte());
                    break;
                }
                case 67: {
                    this._value = new Character(in.readChar());
                    break;
                }
                case 83: {
                    this._value = new Short(in.readShort());
                    break;
                }
                case 73: {
                    this._value = new Integer(in.readInt());
                    break;
                }
                case 74: {
                    this._value = new Long(in.readLong());
                    break;
                }
                case 70: {
                    this._value = new Float(in.readFloat());
                    break;
                }
                case 68: {
                    this._value = new Double(in.readDouble());
                    break;
                }
                case 90: {
                    this._value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 85: {
                    this._value = in.readUTF();
                    break;
                }
                case 76: {
                    this._valueBytes = new byte[in.readInt()];
                    in.readFully(this._valueBytes);
                    break;
                }
                default: {
                    throw new IOException("Unable to parse input stream");
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return obj.equals(this.getValue());
        }

        public int hashCode() {
            Object value = this.getValue();
            int hashCode = value == null ? 0 : value.hashCode();
            return hashCode;
        }
    }

    private static class EntryDelegator
    implements Map.Entry {
        private Map.Entry _delegate;

        public EntryDelegator(Map.Entry entry) {
            this._delegate = entry;
        }

        public Object getKey() {
            return this._delegate.getKey();
        }

        public Object getValue() {
            ValueHolder holder = (ValueHolder)this._delegate.getValue();
            if (holder != null) {
                return holder.getValue();
            }
            return null;
        }

        public Object setValue(Object value) {
            ValueHolder holder = (ValueHolder)this._delegate.getValue();
            Object result = null;
            if (holder == null) {
                this._delegate.setValue(new ValueHolder(value));
            } else {
                result = holder.getValue();
                holder.setValue(value);
            }
            return result;
        }
    }
}

